/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.core;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import de.gesellix.docker.client.filesocket.NamedPipeSocket;
import de.gesellix.docker.client.filesocket.NamedPipeSocketFactory;
import de.gesellix.docker.client.filesocket.UnixSocket;
import de.gesellix.docker.client.filesocket.UnixSocketFactory;
import de.gesellix.docker.client.filesocket.UnixSocketFactorySupport;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineRequest;
import de.gesellix.docker.engine.RequestMethod;
import de.gesellix.docker.remote.api.core.ApiInfrastructureResponse;
import de.gesellix.docker.remote.api.core.ClientError;
import de.gesellix.docker.remote.api.core.EnforceResponseContentTypeConfig;
import de.gesellix.docker.remote.api.core.EnforceResponseContentTypeInterceptor;
import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.remote.api.core.Informational;
import de.gesellix.docker.remote.api.core.Redirection;
import de.gesellix.docker.remote.api.core.RequestConfig;
import de.gesellix.docker.remote.api.core.RequestExtensionsKt;
import de.gesellix.docker.remote.api.core.ResponseConsumerKt;
import de.gesellix.docker.remote.api.core.ResponseExtensionsKt;
import de.gesellix.docker.remote.api.core.Serializer;
import de.gesellix.docker.remote.api.core.ServerError;
import de.gesellix.docker.remote.api.core.Success;
import de.gesellix.docker.remote.api.core.SuccessStream;
import de.gesellix.docker.response.JsonChunksReader;
import de.gesellix.docker.ssl.DockerSslSocket;
import de.gesellix.docker.ssl.SslSocketConfigFactory;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t\"\u0006\b\u0000\u0010\n\u0018\u00012\u0006\u0010\u000b\u001a\u0002H\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0084\b\u00a2\u0006\u0002\u0010\u000eJ@\u0010\u000f\u001a\u0004\u0018\u0001H\n\"\f\b\u0000\u0010\n\u0018\u0001*\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0084\b\u00a2\u0006\u0002\u0010\u0014J'\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\u0016\"\f\b\u0000\u0010\n\u0018\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0084\bJ'\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\u0016\"\f\b\u0000\u0010\n\u0018\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0084\bJ \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0004J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\rH\u0004J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020 H\u0004J;\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\u0016\"\f\b\u0000\u0010\n\u0018\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020#2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0013H\u0084\bJ/\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\u0016\"\f\b\u0000\u0010\n\u0018\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020#H\u0084\bJ(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020#2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0004J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/gesellix/docker/remote/api/core/ApiClient;", "", "dockerClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "proxy", "Ljava/net/Proxy;", "<init>", "(Lde/gesellix/docker/engine/DockerClientConfig;Ljava/net/Proxy;)V", "requestBody", "Lokhttp3/RequestBody;", "T", "content", "mediaType", "", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "body", "Lokhttp3/ResponseBody;", "type", "Ljava/lang/reflect/Type;", "(Lokhttp3/ResponseBody;Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "request", "Lde/gesellix/docker/remote/api/core/ApiInfrastructureResponse;", "requestConfig", "Lde/gesellix/docker/remote/api/core/RequestConfig;", "requestStream", "requestFrames", "Lde/gesellix/docker/remote/api/core/Frame;", "expectMultiplexedResponse", "", "prepareRequest", "Lokhttp3/Request;", "Lde/gesellix/docker/engine/EngineRequest;", "fallbackContentType", "prepareClient", "Lokhttp3/OkHttpClient;", "client", "elementType", "buildHttpUrl", "Lokhttp3/HttpUrl$Builder;", "buildHttpClient", "Lokhttp3/OkHttpClient$Builder;", "builder", "Companion", "api-client"})
@SourceDebugExtension(value={"SMAP\nApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClient.kt\nde/gesellix/docker/remote/api/core/ApiClient\n+ 2 ResponseConsumer.kt\nde/gesellix/docker/remote/api/core/ResponseConsumerKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,392:1\n236#1,16:399\n90#1,16:415\n106#1:433\n108#1,6:438\n252#1,14:444\n271#1,16:458\n287#1,14:491\n72#1,12:509\n72#1,12:521\n72#1,12:533\n72#1,12:545\n90#1,16:559\n106#1:577\n108#1,6:582\n90#1,16:588\n106#1:606\n108#1,6:611\n86#2,2:393\n91#2,4:395\n86#2,2:431\n91#2,4:434\n39#2,17:474\n86#2,2:575\n91#2,4:578\n86#2,2:604\n91#2,4:607\n39#2,17:617\n216#3:505\n217#3:508\n216#3,2:557\n1863#4,2:506\n*S KotlinDebug\n*F\n+ 1 ApiClient.kt\nde/gesellix/docker/remote/api/core/ApiClient\n*L\n125#1:399,16\n125#1:415,16\n125#1:433\n125#1:438,6\n125#1:444,14\n136#1:458,16\n136#1:491,14\n195#1:509,12\n203#1:521,12\n206#1:533,12\n209#1:545,12\n251#1:559,16\n251#1:577\n251#1:582,6\n251#1:588,16\n251#1:606\n251#1:611,6\n105#1:393,2\n106#1:395,4\n125#1:431,2\n125#1:434,4\n136#1:474,17\n251#1:575,2\n251#1:578,4\n251#1:604,2\n251#1:607,4\n286#1:617,17\n165#1:505\n165#1:508\n215#1:557,2\n166#1:506,2\n*E\n"})
public class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerClientConfig dockerClientConfig;
    @Nullable
    private final Proxy proxy;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    protected static final String Authorization = "Authorization";
    @NotNull
    protected static final String TextPlainMediaType = "text/plain";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String OctetStreamMediaType = "application/octet-stream";
    @NotNull
    protected static final String DockerRawStreamMediaType = "application/vnd.docker.raw-stream";
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @NotNull
    private static final Map<String, Function1<OkHttpClient.Builder, OkHttpClient.Builder>> socketFactories;
    @NotNull
    private static final Lazy<OkHttpClient> client$delegate;
    @NotNull
    private static final OkHttpClient.Builder builder;

    public ApiClient(@NotNull DockerClientConfig dockerClientConfig, @Nullable Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        this.dockerClientConfig = dockerClientConfig;
        this.proxy = proxy;
        if (new UnixSocketFactorySupport().isSupported()) {
            socketFactories.put("unix", (Function1<OkHttpClient.Builder, OkHttpClient.Builder>)((Function1)ApiClient::_init_$lambda$9));
        }
        socketFactories.put("npipe", (Function1<OkHttpClient.Builder, OkHttpClient.Builder>)((Function1)ApiClient::_init_$lambda$10));
        socketFactories.put("https", (Function1<OkHttpClient.Builder, OkHttpClient.Builder>)((Function1)arg_0 -> ApiClient._init_$lambda$11(this, arg_0)));
        socketFactories.put("http", (Function1<OkHttpClient.Builder, OkHttpClient.Builder>)((Function1)ApiClient::_init_$lambda$12));
        socketFactories.put("tcp", (Function1<OkHttpClient.Builder, OkHttpClient.Builder>)((Function1)ApiClient::_init_$lambda$13));
    }

    public /* synthetic */ ApiClient(DockerClientConfig dockerClientConfig, Proxy proxy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = new DockerClientConfig();
        }
        if ((n & 2) != 0) {
            proxy = null;
        }
        this(dockerClientConfig, proxy);
    }

    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (content instanceof Source) {
            requestBody = RequestExtensionsKt.asRequestBody((Source)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
            Moshi moshi = Serializer.getMoshi();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = moshi.adapter(Object.class).toJson(content);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(mediaType));
        } else {
            throw new UnsupportedOperationException("requestBody only supports JSON body and File body, not " + mediaType + '.');
        }
        return requestBody;
    }

    public static /* synthetic */ RequestBody requestBody$default(ApiClient $this, Object content, String mediaType, int n, Object object) {
        RequestBody requestBody;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (content instanceof Source) {
            requestBody = RequestExtensionsKt.asRequestBody((Source)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
            Moshi moshi = Serializer.getMoshi();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = moshi.adapter(Object.class).toJson(content);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(mediaType));
        } else {
            throw new UnsupportedOperationException("requestBody only supports JSON body and File body, not " + mediaType + '.');
        }
        return requestBody;
    }

    protected final /* synthetic */ <T> T responseBody(ResponseBody body, String mediaType, Type type) {
        Object object;
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, InputStream.class)) {
            InputStream inputStream = ResponseConsumerKt.consumeInputStream(body);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)inputStream;
        }
        String string = mediaType;
        if (Intrinsics.areEqual((Object)string, (Object)JsonMediaType)) {
            if (type == null) {
                ResponseBody $this$consumeJson$iv = body;
                boolean $i$f$consumeJson = false;
                String content$iv = $this$consumeJson$iv.string();
                Moshi moshi = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                object = moshi.adapter(Object.class).fromJson(content$iv);
            } else {
                ResponseBody $this$consumeJson$iv = body;
                boolean $i$f$consumeJson = false;
                String content$iv = $this$consumeJson$iv.string();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                Type[] typeArray = new Type[]{type};
                ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                Type adapterType$iv = parameterizedType;
                JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter adapter$iv = jsonAdapter;
                object = adapter$iv.fromJson(content$iv);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)TextPlainMediaType)) {
            String string2 = body.string();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = string2;
        } else if (string == null) {
            body.close();
            object = null;
        } else {
            throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType + '.');
        }
        return (T)object;
    }

    public static /* synthetic */ Object responseBody$default(ApiClient $this, ResponseBody body, String mediaType, Type type, int n, Object object) {
        Object object2;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        if ((n & 4) != 0) {
            type = null;
        }
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, InputStream.class)) {
            InputStream inputStream = ResponseConsumerKt.consumeInputStream(body);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return inputStream;
        }
        object = mediaType;
        if (Intrinsics.areEqual((Object)object, (Object)JsonMediaType)) {
            if (type == null) {
                ResponseBody $this$consumeJson$iv = body;
                boolean $i$f$consumeJson = false;
                String content$iv = $this$consumeJson$iv.string();
                Moshi moshi = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                object2 = moshi.adapter(Object.class).fromJson(content$iv);
            } else {
                ResponseBody $this$consumeJson$iv = body;
                boolean $i$f$consumeJson = false;
                String content$iv = $this$consumeJson$iv.string();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                Type[] typeArray = new Type[]{type};
                ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                Type adapterType$iv = parameterizedType;
                JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter adapter$iv = jsonAdapter;
                object2 = adapter$iv.fromJson(content$iv);
            }
        } else if (Intrinsics.areEqual((Object)object, (Object)TextPlainMediaType)) {
            String string = body.string();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object2 = string;
        } else if (object == null) {
            body.close();
            object2 = null;
        } else {
            throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType + '.');
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    protected final /* synthetic */ <T> ApiInfrastructureResponse<T> request(RequestConfig requestConfig) {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        boolean $i$f$request = false;
        EngineRequest it = engineRequest = new EngineRequest(requestConfig.getMethod(), requestConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$22 = false;
        it.setHeaders(requestConfig.getHeaders());
        it.setQuery(requestConfig.getQuery());
        it.setBody(requestConfig.getBody());
        EngineRequest engineRequest2 = engineRequest;
        Request request = ApiClient.prepareRequest$default(this, engineRequest2, null, 2, null);
        OkHttpClient client = this.prepareClient(engineRequest2);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$22 = this;
        Type elementType$iv = requestConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv = client.newCall(request).execute();
        String string2 = Response.header$default((Response)response$iv, (String)ContentType, null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv = string;
        if (response$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiInfrastructureResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object;
            void this_$iv;
            void var12_14 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object = null;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                    InputStream inputStream = ResponseConsumerKt.consumeInputStream(body$iv$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                    object = inputStream;
                } else {
                    String string5 = mediaType$iv;
                    if (Intrinsics.areEqual((Object)string5, (Object)JsonMediaType)) {
                        if (elementType$iv == null) {
                            ResponseBody $this$consumeJson$iv$iv$iv = body$iv$iv;
                            boolean $i$f$consumeJson = false;
                            String content$iv$iv$iv = $this$consumeJson$iv$iv$iv.string();
                            Moshi moshi = Serializer.getMoshi();
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                            object = moshi.adapter(Object.class).fromJson(content$iv$iv$iv);
                        } else {
                            ResponseBody $this$consumeJson$iv$iv$iv = body$iv$iv;
                            boolean $i$f$consumeJson = false;
                            String content$iv$iv$iv = $this$consumeJson$iv$iv$iv.string();
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                            Type[] typeArray = new Type[]{elementType$iv};
                            ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                            Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                            Type adapterType$iv$iv$iv = parameterizedType;
                            JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                            JsonAdapter adapter$iv$iv$iv = jsonAdapter;
                            object = adapter$iv$iv$iv.fromJson(content$iv$iv$iv);
                        }
                    } else if (Intrinsics.areEqual((Object)string5, (Object)TextPlainMediaType)) {
                        String string6 = body$iv$iv.string();
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                        object = string6;
                    } else if (string5 == null) {
                        body$iv$iv.close();
                        object = null;
                    } else {
                        throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv + '.');
                    }
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiInfrastructureResponse;
    }

    protected final /* synthetic */ <T> ApiInfrastructureResponse<T> requestStream(RequestConfig requestConfig) {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        boolean $i$f$requestStream = false;
        EngineRequest it = engineRequest = new EngineRequest(requestConfig.getMethod(), requestConfig.getPath());
        boolean bl = false;
        it.setHeaders(requestConfig.getHeaders());
        it.setQuery(requestConfig.getQuery());
        it.setBody(requestConfig.getBody());
        EngineRequest engineRequest2 = engineRequest;
        Request request = this.prepareRequest(engineRequest2, JsonMediaType);
        OkHttpClient client = this.prepareClient(engineRequest2);
        ApiClient this_$iv = this;
        boolean $i$f$requestStream2 = false;
        Response response$iv = client.newCall(request).execute();
        String string2 = Response.header$default((Response)response$iv, (String)ContentType, null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv = string;
        if (response$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiInfrastructureResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Flow flow;
            ResponseBody $this$consumeStream$iv$iv = response$iv.body();
            boolean $i$f$consumeStream = false;
            if ($this$consumeStream$iv$iv == null) {
                flow = FlowKt.emptyFlow();
            } else if (Intrinsics.areEqual((Object)mediaType$iv, (Object)JsonMediaType)) {
                Flow events$iv$iv;
                JsonChunksReader reader$iv$iv = new JsonChunksReader((Source)$this$consumeStream$iv$iv.source(), Serializer.getMoshi());
                Intrinsics.needClassReification();
                flow = events$iv$iv = FlowKt.flow((Function2)new Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object>(reader$iv$iv, $this$consumeStream$iv$iv, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ JsonChunksReader $reader;
                    final /* synthetic */ ResponseBody $this_consumeStream;
                    {
                        this.$reader = $reader;
                        this.$this_consumeStream = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$flow = (FlowCollector)this.L$0;
lbl6:
                                // 3 sources

                                while (this.$reader.hasNext()) {
                                    Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                                    next = this.$reader.readNext(Object.class);
                                    this.L$0 = $this$flow;
                                    this.label = 1;
                                    v0 = $this$flow.emit(next, (Continuation)this);
                                    if (v0 != var2_2) continue;
                                    var5_5 = var2_2;
                                    return var5_5;
                                }
                                break;
                            }
                            case 1: {
                                $this$flow = (FlowCollector)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl6
                            }
                        }
                        Util.closeQuietly((Closeable)((Closeable)this.$this_consumeStream));
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(FlowCollector<? super T> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            } else {
                throw new UnsupportedOperationException("Can't handle media type " + mediaType$iv);
            }
            apiInfrastructureResponse = new SuccessStream(flow, response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiInfrastructureResponse;
    }

    @NotNull
    protected final ApiInfrastructureResponse<Frame> requestFrames(@NotNull RequestConfig requestConfig, boolean expectMultiplexedResponse) {
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        EngineRequest it = engineRequest = new EngineRequest(requestConfig.getMethod(), requestConfig.getPath());
        boolean bl = false;
        it.setHeaders(requestConfig.getHeaders());
        it.setQuery(requestConfig.getQuery());
        it.setBody(requestConfig.getBody());
        EngineRequest engineRequest2 = engineRequest;
        Request request = this.prepareRequest(engineRequest2, DockerRawStreamMediaType);
        OkHttpClient client = this.prepareClient(engineRequest2);
        return this.requestFrames(request, client, expectMultiplexedResponse);
    }

    public static /* synthetic */ ApiInfrastructureResponse requestFrames$default(ApiClient apiClient, RequestConfig requestConfig, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestFrames");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return apiClient.requestFrames(requestConfig, bl);
    }

    @NotNull
    protected final Request prepareRequest(@NotNull EngineRequest requestConfig, @NotNull String fallbackContentType) {
        Request.Builder builder;
        Request.Builder builder2;
        Map headers;
        String string;
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        Intrinsics.checkNotNullParameter((Object)fallbackContentType, (String)"fallbackContentType");
        HttpUrl httpUrl = this.buildHttpUrl().build();
        String pathWithOptionalApiVersion = requestConfig.getApiVersion() != null ? requestConfig.getApiVersion() + '/' + requestConfig.getPath() : requestConfig.getPath();
        HttpUrl.Builder builder3 = httpUrl.newBuilder();
        Intrinsics.checkNotNull((Object)pathWithOptionalApiVersion);
        Object object = new char[]{'/'};
        object = builder3.addPathSegments(StringsKt.trimStart((String)pathWithOptionalApiVersion, (char[])object));
        Object $this$prepareRequest_u24lambda_u245 = object;
        boolean bl4 = false;
        Map map = requestConfig.getQuery();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getQuery(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry query = element$iv = object2.next();
            boolean bl2 = false;
            Object v = query.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            Iterable $this$forEach$iv2 = (Iterable)v;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String queryValue = (String)element$iv2;
                boolean bl3 = false;
                Object k = query.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                $this$prepareRequest_u24lambda_u245.addQueryParameter((String)k, queryValue);
            }
        }
        HttpUrl url = object.build();
        object = (CharSequence)requestConfig.getHeaders().get(ContentType);
        if (object == null || object.length() == 0) {
            Map map2 = requestConfig.getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getHeaders(...)");
            object = map2;
            $this$prepareRequest_u24lambda_u245 = ContentType;
            String bl4 = JsonMediaType;
            object.put($this$prepareRequest_u24lambda_u245, bl4);
        }
        if ((object = (CharSequence)requestConfig.getHeaders().get(Accept)) == null || object.length() == 0) {
            Map map3 = requestConfig.getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getHeaders(...)");
            object = map3;
            $this$prepareRequest_u24lambda_u245 = Accept;
            String bl4 = JsonMediaType;
            object.put($this$prepareRequest_u24lambda_u245, bl4);
        }
        if ((string = (String)(headers = requestConfig.getHeaders()).get(ContentType)) == null) {
            string = "";
        }
        if (Intrinsics.areEqual((Object)string, (Object)"")) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        String string2 = (String)headers.get(Accept);
        if (string2 == null) {
            string2 = "";
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"")) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        Object v = headers.get(ContentType);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        String bl4 = StringsKt.substringBefore$default((String)((String)v), (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = bl4.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String mediaType = string3;
        RequestMethod requestMethod = requestConfig.getMethod();
        switch (requestMethod == null ? -1 : WhenMappings.$EnumSwitchMapping$0[requestMethod.ordinal()]) {
            case 1: {
                RequestBody requestBody;
                Request.Builder builder4 = new Request.Builder().url(url);
                object2 = this;
                Object content$iv = requestConfig.getBody();
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(mediaType));
                } else if (content$iv instanceof Source) {
                    requestBody = RequestExtensionsKt.asRequestBody((Source)content$iv, MediaType.Companion.parse(mediaType));
                } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
                    String string4 = Serializer.getMoshi().adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                    requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(mediaType));
                } else {
                    throw new UnsupportedOperationException("requestBody only supports JSON body and File body, not " + mediaType + '.');
                }
                builder2 = builder4.delete(requestBody);
                break;
            }
            case 2: {
                builder2 = new Request.Builder().url(url);
                break;
            }
            case 3: {
                builder2 = new Request.Builder().url(url).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                Request.Builder builder5 = new Request.Builder().url(url);
                ApiClient this_$iv = this;
                Object content$iv = requestConfig.getBody();
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(mediaType));
                } else if (content$iv instanceof Source) {
                    requestBody = RequestExtensionsKt.asRequestBody((Source)content$iv, MediaType.Companion.parse(mediaType));
                } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
                    String string5 = Serializer.getMoshi().adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                    requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(mediaType));
                } else {
                    throw new UnsupportedOperationException("requestBody only supports JSON body and File body, not " + mediaType + '.');
                }
                builder2 = builder5.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                Request.Builder builder6 = new Request.Builder().url(url);
                ApiClient this_$iv = this;
                Object content$iv = requestConfig.getBody();
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(mediaType));
                } else if (content$iv instanceof Source) {
                    requestBody = RequestExtensionsKt.asRequestBody((Source)content$iv, MediaType.Companion.parse(mediaType));
                } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
                    String string6 = Serializer.getMoshi().adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                    requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(mediaType));
                } else {
                    throw new UnsupportedOperationException("requestBody only supports JSON body and File body, not " + mediaType + '.');
                }
                builder2 = builder6.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                Request.Builder builder7 = new Request.Builder().url(url);
                ApiClient this_$iv = this;
                Object content$iv = requestConfig.getBody();
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(mediaType));
                } else if (content$iv instanceof Source) {
                    requestBody = RequestExtensionsKt.asRequestBody((Source)content$iv, MediaType.Companion.parse(mediaType));
                } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
                    String string7 = Serializer.getMoshi().adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                    requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(mediaType));
                } else {
                    throw new UnsupportedOperationException("requestBody only supports JSON body and File body, not " + mediaType + '.');
                }
                builder2 = builder7.post(requestBody);
                break;
            }
            case 7: {
                builder2 = new Request.Builder().url(url).method("OPTIONS", null);
                break;
            }
            case -1: {
                throw new IllegalStateException("Request method is null");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$prepareRequest_u24lambda_u247 = builder = builder2;
        boolean bl5 = false;
        Intrinsics.checkNotNull((Object)headers);
        Map $this$forEach$iv3 = headers;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry header = element$iv = iterator.next();
            boolean bl6 = false;
            Object k = header.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            String string8 = (String)k;
            Object v2 = header.getValue();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
            $this$prepareRequest_u24lambda_u247.addHeader(string8, (String)v2);
        }
        Request.Builder $this$prepareRequest_u24lambda_u248 = builder;
        boolean bl7 = false;
        $this$prepareRequest_u24lambda_u248.tag(EnforceResponseContentTypeConfig.class, (Object)new EnforceResponseContentTypeConfig(fallbackContentType));
        Request.Builder requestBuilder = builder;
        return requestBuilder.build();
    }

    public static /* synthetic */ Request prepareRequest$default(ApiClient apiClient, EngineRequest engineRequest, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareRequest");
        }
        if ((n & 2) != 0) {
            string = "";
        }
        return apiClient.prepareRequest(engineRequest, string);
    }

    @NotNull
    protected final OkHttpClient prepareClient(@NotNull EngineRequest requestConfig) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        OkHttpClient.Builder actualClient = this.buildHttpClient(Companion.getClient().newBuilder()).connectTimeout((long)requestConfig.getTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)requestConfig.getTimeout(), TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new EnforceResponseContentTypeInterceptor());
        return actualClient.build();
    }

    protected final /* synthetic */ <T> ApiInfrastructureResponse<T> request(Request request, OkHttpClient client, Type elementType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        boolean $i$f$request = false;
        Response response = client.newCall(request).execute();
        String string2 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType = string;
        if (response.isRedirect()) {
            return new Redirection(response.code(), response.headers().toMultimap());
        }
        if (ResponseExtensionsKt.isInformational(response)) {
            return new Informational(response.message(), response.code(), response.headers().toMultimap());
        }
        if (response.isSuccessful()) {
            Object object;
            ApiClient apiClient = this;
            ResponseBody body$iv = response.body();
            boolean $i$f$responseBody = false;
            if (body$iv == null) {
                object = null;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                    InputStream inputStream = ResponseConsumerKt.consumeInputStream(body$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                    object = inputStream;
                } else {
                    String string5 = mediaType;
                    if (Intrinsics.areEqual((Object)string5, (Object)JsonMediaType)) {
                        if (elementType == null) {
                            ResponseBody $this$consumeJson$iv$iv = body$iv;
                            boolean $i$f$consumeJson = false;
                            String content$iv$iv = $this$consumeJson$iv$iv.string();
                            Moshi moshi = Serializer.getMoshi();
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                            object = moshi.adapter(Object.class).fromJson(content$iv$iv);
                        } else {
                            ResponseBody $this$consumeJson$iv$iv = body$iv;
                            boolean $i$f$consumeJson = false;
                            String content$iv$iv = $this$consumeJson$iv$iv.string();
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                            Type[] typeArray = new Type[]{elementType};
                            ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                            Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                            Type adapterType$iv$iv = parameterizedType;
                            JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                            JsonAdapter adapter$iv$iv = jsonAdapter;
                            object = adapter$iv$iv.fromJson(content$iv$iv);
                        }
                    } else if (Intrinsics.areEqual((Object)string5, (Object)TextPlainMediaType)) {
                        String string6 = body$iv.string();
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                        object = string6;
                    } else if (string5 == null) {
                        body$iv.close();
                        object = null;
                    } else {
                        throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType + '.');
                    }
                }
            }
            return new Success<Object>(object, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
        }
        if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            return new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        ResponseBody responseBody = response.body();
        return new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
    }

    public static /* synthetic */ ApiInfrastructureResponse request$default(ApiClient $this, Request request, OkHttpClient client, Type elementType, int n, Object object) {
        String string;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: request");
        }
        if ((n & 4) != 0) {
            elementType = null;
        }
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        boolean $i$f$request = false;
        Response response = client.newCall(request).execute();
        String string2 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType = string;
        if (response.isRedirect()) {
            return new Redirection(response.code(), response.headers().toMultimap());
        }
        if (ResponseExtensionsKt.isInformational(response)) {
            return new Informational(response.message(), response.code(), response.headers().toMultimap());
        }
        if (response.isSuccessful()) {
            Object object2;
            ApiClient apiClient = $this;
            ResponseBody body$iv = response.body();
            boolean $i$f$responseBody = false;
            if (body$iv == null) {
                object2 = null;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                    InputStream inputStream = ResponseConsumerKt.consumeInputStream(body$iv);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                    object2 = inputStream;
                } else {
                    String string5 = mediaType;
                    if (Intrinsics.areEqual((Object)string5, (Object)JsonMediaType)) {
                        if (elementType == null) {
                            ResponseBody $this$consumeJson$iv$iv = body$iv;
                            boolean $i$f$consumeJson = false;
                            String content$iv$iv = $this$consumeJson$iv$iv.string();
                            Moshi moshi = Serializer.getMoshi();
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                            object2 = moshi.adapter(Object.class).fromJson(content$iv$iv);
                        } else {
                            ResponseBody $this$consumeJson$iv$iv = body$iv;
                            boolean $i$f$consumeJson = false;
                            String content$iv$iv = $this$consumeJson$iv$iv.string();
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                            Type[] typeArray = new Type[]{elementType};
                            ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                            Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                            Type adapterType$iv$iv = parameterizedType;
                            JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                            JsonAdapter adapter$iv$iv = jsonAdapter;
                            object2 = adapter$iv$iv.fromJson(content$iv$iv);
                        }
                    } else if (Intrinsics.areEqual((Object)string5, (Object)TextPlainMediaType)) {
                        String string6 = body$iv.string();
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                        object2 = string6;
                    } else if (string5 == null) {
                        body$iv.close();
                        object2 = null;
                    } else {
                        throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType + '.');
                    }
                }
            }
            return new Success<Object>(object2, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
        }
        if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            return new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        ResponseBody responseBody = response.body();
        return new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
    }

    protected final /* synthetic */ <T> ApiInfrastructureResponse<T> requestStream(Request request, OkHttpClient client) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        boolean $i$f$requestStream = false;
        Response response = client.newCall(request).execute();
        String string2 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType = string;
        if (response.isRedirect()) {
            return new Redirection(response.code(), response.headers().toMultimap());
        }
        if (ResponseExtensionsKt.isInformational(response)) {
            return new Informational(response.message(), response.code(), response.headers().toMultimap());
        }
        if (response.isSuccessful()) {
            Flow flow;
            ResponseBody $this$consumeStream$iv = response.body();
            boolean $i$f$consumeStream = false;
            if ($this$consumeStream$iv == null) {
                flow = FlowKt.emptyFlow();
            } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
                Flow events$iv;
                JsonChunksReader reader$iv = new JsonChunksReader((Source)$this$consumeStream$iv.source(), Serializer.getMoshi());
                Intrinsics.needClassReification();
                flow = events$iv = FlowKt.flow((Function2)new Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object>(reader$iv, $this$consumeStream$iv, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ JsonChunksReader $reader;
                    final /* synthetic */ ResponseBody $this_consumeStream;
                    {
                        this.$reader = $reader;
                        this.$this_consumeStream = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$flow = (FlowCollector)this.L$0;
lbl6:
                                // 3 sources

                                while (this.$reader.hasNext()) {
                                    Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                                    next = this.$reader.readNext(Object.class);
                                    this.L$0 = $this$flow;
                                    this.label = 1;
                                    v0 = $this$flow.emit(next, (Continuation)this);
                                    if (v0 != var2_2) continue;
                                    var5_5 = var2_2;
                                    return var5_5;
                                }
                                break;
                            }
                            case 1: {
                                $this$flow = (FlowCollector)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl6
                            }
                        }
                        Util.closeQuietly((Closeable)((Closeable)this.$this_consumeStream));
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(FlowCollector<? super T> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            } else {
                throw new UnsupportedOperationException("Can't handle media type " + mediaType);
            }
            return new SuccessStream(flow, response.code(), response.headers().toMultimap());
        }
        if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            return new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        ResponseBody responseBody = response.body();
        return new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
    }

    @NotNull
    protected final ApiInfrastructureResponse<Frame> requestFrames(@NotNull Request request, @NotNull OkHttpClient client, boolean expectMultiplexedResponse) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Response response = client.newCall(request).execute();
        String string2 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType = string;
        if (response.isRedirect()) {
            return new Redirection(response.code(), response.headers().toMultimap());
        }
        if (ResponseExtensionsKt.isInformational(response)) {
            return new Informational(response.message(), response.code(), response.headers().toMultimap());
        }
        if (response.isSuccessful()) {
            return new SuccessStream<Frame>(ResponseConsumerKt.consumeFrames(response.body(), mediaType, expectMultiplexedResponse), response.code(), response.headers().toMultimap());
        }
        if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            return new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        ResponseBody responseBody = response.body();
        return new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
    }

    public static /* synthetic */ ApiInfrastructureResponse requestFrames$default(ApiClient apiClient, Request request, OkHttpClient okHttpClient, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestFrames");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return apiClient.requestFrames(request, okHttpClient, bl);
    }

    @NotNull
    public HttpUrl.Builder buildHttpUrl() {
        HttpUrl.Builder builder;
        String string = this.dockerClientConfig.getScheme();
        if (Intrinsics.areEqual((Object)string, (Object)"unix")) {
            HttpUrl.Builder builder2 = new HttpUrl.Builder().scheme("http");
            String string2 = new UnixSocket().encodeHostname(this.dockerClientConfig.getHost());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeHostname(...)");
            builder = builder2.host(string2);
        } else if (Intrinsics.areEqual((Object)string, (Object)"npipe")) {
            HttpUrl.Builder builder3 = new HttpUrl.Builder().scheme("http");
            String string3 = new NamedPipeSocket().encodeHostname(this.dockerClientConfig.getHost());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeHostname(...)");
            builder = builder3.host(string3);
        } else {
            HttpUrl.Builder builder4 = new HttpUrl.Builder();
            String string4 = this.dockerClientConfig.getScheme();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getScheme(...)");
            HttpUrl.Builder builder5 = builder4.scheme(string4);
            String string5 = this.dockerClientConfig.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getHost(...)");
            builder = builder5.host(string5).port(this.dockerClientConfig.getPort());
        }
        return builder;
    }

    @NotNull
    public OkHttpClient.Builder buildHttpClient(@NotNull OkHttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.proxy(this.proxy);
        String protocol = this.dockerClientConfig.getScheme();
        Function1<OkHttpClient.Builder, OkHttpClient.Builder> socketFactoryConfiguration = socketFactories.get(protocol);
        if (socketFactoryConfiguration != null) {
            return (OkHttpClient.Builder)socketFactoryConfiguration.invoke((Object)builder);
        }
        throw new IllegalStateException(protocol + " socket not supported.");
    }

    private static final OkHttpClient.Builder _init_$lambda$9(OkHttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        UnixSocketFactory factory = new UnixSocketFactory();
        return builder.socketFactory((SocketFactory)factory).dns((Dns)factory);
    }

    private static final OkHttpClient.Builder _init_$lambda$10(OkHttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        NamedPipeSocketFactory factory = new NamedPipeSocketFactory();
        return builder.socketFactory((SocketFactory)factory).dns((Dns)factory);
    }

    private static final OkHttpClient.Builder _init_$lambda$11(ApiClient this$0, OkHttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DockerSslSocket dockerSslSocket = new SslSocketConfigFactory().createDockerSslSocket(this$0.dockerClientConfig.getCertPath());
        SSLSocketFactory sSLSocketFactory = dockerSslSocket.getSslSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getSslSocketFactory(...)");
        X509TrustManager x509TrustManager = dockerSslSocket.getTrustManager();
        Intrinsics.checkNotNullExpressionValue((Object)x509TrustManager, (String)"getTrustManager(...)");
        return builder.sslSocketFactory(sSLSocketFactory, x509TrustManager);
    }

    private static final OkHttpClient.Builder _init_$lambda$12(OkHttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return builder;
    }

    private static final OkHttpClient.Builder _init_$lambda$13(OkHttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return builder;
    }

    private static final OkHttpClient client_delegate$lambda$14() {
        return builder.build();
    }

    public ApiClient() {
        this(null, null, 3, null);
    }

    @NotNull
    public static final OkHttpClient getClient() {
        return Companion.getClient();
    }

    @NotNull
    public static final OkHttpClient.Builder getBuilder() {
        return Companion.getBuilder();
    }

    static {
        socketFactories = new LinkedHashMap();
        client$delegate = LazyKt.lazy(ApiClient::client_delegate$lambda$14);
        builder = new OkHttpClient.Builder();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R)\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001a\u001a\u00020\u001b8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010!\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lde/gesellix/docker/remote/api/core/ApiClient$Companion;", "", "<init>", "()V", "ContentType", "", "Accept", "Authorization", "TextPlainMediaType", "JsonMediaType", "OctetStreamMediaType", "DockerRawStreamMediaType", "username", "getUsername", "()Ljava/lang/String;", "setUsername", "(Ljava/lang/String;)V", "password", "getPassword", "setPassword", "socketFactories", "", "Lkotlin/Function1;", "Lokhttp3/OkHttpClient$Builder;", "getSocketFactories", "()Ljava/util/Map;", "client", "Lokhttp3/OkHttpClient;", "getClient$annotations", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "builder", "getBuilder$annotations", "getBuilder", "()Lokhttp3/OkHttpClient$Builder;", "api-client"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @NotNull
        public final Map<String, Function1<OkHttpClient.Builder, OkHttpClient.Builder>> getSocketFactories() {
            return socketFactories;
        }

        @NotNull
        public final OkHttpClient getClient() {
            Lazy lazy = client$delegate;
            return (OkHttpClient)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getClient$annotations() {
        }

        @NotNull
        public final OkHttpClient.Builder getBuilder() {
            return builder;
        }

        @JvmStatic
        public static /* synthetic */ void getBuilder$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.OPTIONS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

