/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.core;

import de.gesellix.docker.remote.api.core.EnforceResponseContentTypeConfig;
import de.gesellix.docker.remote.api.core.LoggingExtensionsKt;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lde/gesellix/docker/remote/api/core/EnforceResponseContentTypeInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "api-client"})
public final class EnforceResponseContentTypeInterceptor
implements Interceptor {
    @NotNull
    private final Lazy log$delegate = LoggingExtensionsKt.logger(this);

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Response response = chain.proceed(chain.request());
        Object object = (EnforceResponseContentTypeConfig)chain.request().tag(EnforceResponseContentTypeConfig.class);
        boolean bl = object != null && (object = ((EnforceResponseContentTypeConfig)object).getFallbackContentType()) != null ? ((CharSequence)object).length() > 0 : false;
        if (bl && response.isSuccessful() && response.code() != 204 && response.headers("Content-Type").isEmpty()) {
            EnforceResponseContentTypeConfig enforceResponseContentTypeConfig = (EnforceResponseContentTypeConfig)chain.request().tag(EnforceResponseContentTypeConfig.class);
            String string = enforceResponseContentTypeConfig != null ? enforceResponseContentTypeConfig.getFallbackContentType() : null;
            Intrinsics.checkNotNull((Object)string);
            String enforcedContentType = string;
            this.getLog().debug("Overriding Content-Type response header with " + enforcedContentType);
            return response.newBuilder().header("Content-Type", enforcedContentType).build();
        }
        return response;
    }
}

