/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.core;

import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.response.Reader;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u00022\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0006H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/gesellix/docker/remote/api/core/FrameReader;", "Lde/gesellix/docker/response/Reader;", "Lde/gesellix/docker/remote/api/core/Frame;", "source", "Lokio/Source;", "expectMultiplexedResponse", "", "<init>", "(Lokio/Source;Z)V", "bufferedSource", "Lokio/BufferedSource;", "buffer", "Lokio/Buffer;", "readNext", "type", "Ljava/lang/Class;", "hasNext", "api-client"})
@SourceDebugExtension(value={"SMAP\nFrameReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameReader.kt\nde/gesellix/docker/remote/api/core/FrameReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class FrameReader
implements Reader<Frame> {
    private final boolean expectMultiplexedResponse;
    @NotNull
    private final BufferedSource bufferedSource;
    @NotNull
    private final Buffer buffer;

    public FrameReader(@NotNull Source source, boolean expectMultiplexedResponse) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.expectMultiplexedResponse = expectMultiplexedResponse;
        this.bufferedSource = Okio.buffer((Source)source);
        this.buffer = new Buffer();
    }

    public /* synthetic */ FrameReader(Source source, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(source, bl);
    }

    @NotNull
    public Frame readNext(@Nullable Class<Frame> type) {
        Frame frame;
        if (this.expectMultiplexedResponse) {
            Frame.StreamType streamType = Frame.StreamType.valueOf(this.bufferedSource.readByte());
            this.bufferedSource.skip(3L);
            int frameSize = this.bufferedSource.readInt();
            frame = new Frame(streamType, this.bufferedSource.readByteArray((long)frameSize));
        } else {
            long l;
            long byteCount = 0L;
            long it = l = this.bufferedSource.read(this.buffer, 8192L);
            boolean bl = false;
            byteCount = it;
            frame = byteCount < 0L ? new Frame(Frame.StreamType.RAW, null) : new Frame(Frame.StreamType.RAW, this.buffer.readByteArray(byteCount));
        }
        return frame;
    }

    public boolean hasNext() {
        boolean bl;
        try {
            bl = !Thread.currentThread().isInterrupted() && !this.bufferedSource.peek().exhausted();
        }
        catch (Exception e) {
            return false;
        }
        return bl;
    }
}

