package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.engine.EngineResponse;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

import javax.inject.Inject;

public class DockerWaitTask extends GenericDockerTask {

  private final Property<String> containerId;

  @Input
  public Property<String> getContainerId() {
    return containerId;
  }

  private EngineResponse result;

  @Internal
  public EngineResponse getResult() {
    return result;
  }

  @Inject
  public DockerWaitTask(ObjectFactory objectFactory) {
    super(objectFactory);
    setDescription("Block until a container stops, then print its exit code.");

    containerId = objectFactory.property(String.class);
  }

  @TaskAction
  public EngineResponse awaitStop() {
    getLogger().info("docker wait");
    result = getDockerClient().wait(getContainerId().get());
    return result;
  }
}
