/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import com.squareup.moshi.Moshi;
import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.remote.api.BuildInfo;
import de.gesellix.docker.remote.api.ImageID;
import de.gesellix.docker.remote.api.client.BuildInfoExtensionsKt;
import de.gesellix.docker.remote.api.core.Cancellable;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import de.gesellix.gradle.docker.worker.BuildcontextArchiver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;

public class DockerBuildTask
extends GenericDockerTask {
    private final Property<String> imageName;
    private final DirectoryProperty buildContextDirectory;
    private final Property<InputStream> buildContext;
    private final MapProperty<String, Object> buildParams;
    private final MapProperty<String, Object> buildOptions;
    private final MapProperty<String, AuthConfig> authConfigs;
    private final Property<Boolean> enableBuildLog;
    private String imageId;
    public Duration buildTimeout = Duration.of(10L, ChronoUnit.MINUTES);
    WorkerExecutor workerExecutor;
    File targetFile;

    @Input
    @Optional
    public Property<String> getImageName() {
        return this.imageName;
    }

    @InputDirectory
    @Optional
    public DirectoryProperty getBuildContextDirectory() {
        return this.buildContextDirectory;
    }

    @Input
    @Optional
    public Property<InputStream> getBuildContext() {
        return this.buildContext;
    }

    @Input
    @Optional
    public MapProperty<String, Object> getBuildParams() {
        return this.buildParams;
    }

    @Input
    @Optional
    public MapProperty<String, Object> getBuildOptions() {
        return this.buildOptions;
    }

    @Input
    @Optional
    public MapProperty<String, AuthConfig> getAuthConfigs() {
        return this.authConfigs;
    }

    @Input
    @Optional
    public Property<Boolean> getEnableBuildLog() {
        return this.enableBuildLog;
    }

    @Internal
    public String getImageId() {
        return this.imageId;
    }

    @Internal
    public Duration getBuildTimeout() {
        return this.buildTimeout;
    }

    @Inject
    public DockerBuildTask(ObjectFactory objectFactory, WorkerExecutor workerExecutor) {
        super(objectFactory);
        this.workerExecutor = workerExecutor;
        this.setDescription("Build an image from a Dockerfile");
        this.imageName = objectFactory.property(String.class);
        this.buildContextDirectory = objectFactory.directoryProperty();
        this.buildContext = objectFactory.property(InputStream.class);
        this.buildParams = objectFactory.mapProperty(String.class, Object.class);
        this.buildOptions = objectFactory.mapProperty(String.class, Object.class);
        this.authConfigs = objectFactory.mapProperty(String.class, AuthConfig.class);
        this.enableBuildLog = objectFactory.property(Boolean.class);
        this.enableBuildLog.convention((Object)false);
    }

    @TaskAction
    public String build() {
        String encodedRegistryConfig;
        InputStream actualBuildContext;
        this.getLogger().info("docker build");
        if (this.getBuildContextDirectory().isPresent()) {
            if (this.getBuildContext().isPresent()) {
                throw new IllegalArgumentException("only one of buildContext and buildContextDirectory are allowed");
            }
            actualBuildContext = this.createBuildContextFromDirectory();
        } else {
            actualBuildContext = (InputStream)this.getBuildContext().get();
        }
        if (actualBuildContext == null) {
            throw new IllegalStateException("neither buildContext nor buildContextDirectory found");
        }
        if (this.getAuthConfig().isPresent()) {
            this.getLogger().info("Docker Build requires a Map of AuthConfig by registry name. The configured 'authConfig' will be ignored. Please use the 'authConfigs' (plural form) task parameter if you need to override the DockerClient's default behaviour.");
        }
        if ((encodedRegistryConfig = (String)this.getBuildOptions().getting((Object)"EncodedRegistryConfig").getOrNull()) == null && !((Map)this.getAuthConfigs().get()).isEmpty()) {
            encodedRegistryConfig = this.getDockerClient().encodeAuthConfigs((Map)this.getAuthConfigs().get());
        }
        HashMap buildParams = new HashMap((Map)this.getBuildParams().getOrElse(new HashMap()));
        String tag = buildParams.getOrDefault("t", null);
        if (this.getImageName().isPresent()) {
            if (tag != null) {
                this.getLogger().warn("Overriding build parameter \"t\" with imageName, because both were given");
            }
            tag = (String)this.getImageName().get();
        }
        final ArrayList infos = new ArrayList();
        final CountDownLatch buildFinished = new CountDownLatch(1);
        StreamCallback<BuildInfo> callback = new StreamCallback<BuildInfo>(){
            Cancellable cancellable;

            public void onStarting(Cancellable cancellable) {
                this.cancellable = cancellable;
            }

            public void onNext(BuildInfo element) {
                if (element != null && ((Boolean)DockerBuildTask.this.getEnableBuildLog().getOrElse((Object)false)).booleanValue()) {
                    DockerBuildTask.this.getLogger().info(element.toString());
                }
                infos.add(element);
            }

            public void onFailed(Exception e) {
                DockerBuildTask.this.getLogger().error("Build failed", (Throwable)e);
                buildFinished.countDown();
                this.cancellable.cancel();
            }

            public void onFinished() {
                DockerBuildTask.this.getLogger().info("Build finished");
                buildFinished.countDown();
            }
        };
        String buildargs = buildParams.getOrDefault("buildargs", null);
        if (buildargs instanceof Map) {
            buildargs = new Moshi.Builder().build().adapter(Map.class).toJson((Object)((Map)((Object)buildargs)));
        }
        this.getDockerClient().build((StreamCallback)callback, this.buildTimeout, (String)buildParams.getOrDefault("dockerfile", null), tag, (Boolean)buildParams.getOrDefault("quiet", null), (Boolean)buildParams.getOrDefault("nocache", null), (String)buildParams.getOrDefault("pull", null), Boolean.valueOf(buildParams.getOrDefault("rm", true)), buildargs, null, encodedRegistryConfig, null, actualBuildContext);
        try {
            this.getLogger().debug("Waiting " + this.buildTimeout + " for the build to finish...");
            buildFinished.await(this.buildTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.getLogger().error("Build didn't finish before timeout of " + this.buildTimeout, (Throwable)e);
        }
        ImageID imageId = BuildInfoExtensionsKt.getImageId(infos);
        this.imageId = imageId == null ? null : imageId.getID();
        return this.imageId;
    }

    @Internal
    public String getNormalizedImageName() {
        if (!this.getImageName().isPresent()) {
            return UUID.randomUUID().toString();
        }
        return ((String)this.getImageName().get()).replaceAll("\\W", "_");
    }

    public InputStream createBuildContextFromDirectory() {
        this.targetFile = new File(this.getTemporaryDir(), "buildContext_" + this.getNormalizedImageName() + ".tar.gz");
        this.workerExecutor.noIsolation().submit(BuildcontextArchiver.class, parameters -> {
            parameters.getSourceDirectory().set((Provider)this.getBuildContextDirectory());
            parameters.getArchivedTargetFile().set(this.targetFile);
        });
        this.workerExecutor.await();
        this.getLogger().info("temporary buildContext: " + this.targetFile);
        try {
            return new FileInputStream(this.targetFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("targetFile not found", e);
        }
    }
}

