/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.util.HashMap;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerCommitTask
extends GenericDockerTask {
    private final Property<String> containerId;
    private final Property<String> repo;
    private final Property<String> tag;
    private final Property<String> author;
    private final Property<String> comment;
    private final Property<Boolean> pauseContainer;
    private final Property<String> changes;

    @Input
    public Property<String> getContainerId() {
        return this.containerId;
    }

    @Input
    public Property<String> getRepo() {
        return this.repo;
    }

    @Optional
    @Input
    public Property<String> getTag() {
        return this.tag;
    }

    @Optional
    @Input
    public Property<String> getAuthor() {
        return this.author;
    }

    @Optional
    @Input
    public Property<String> getComment() {
        return this.comment;
    }

    @Optional
    @Input
    public Property<Boolean> getPauseContainer() {
        return this.pauseContainer;
    }

    @Optional
    @Input
    public Property<String> getChanges() {
        return this.changes;
    }

    @Inject
    public DockerCommitTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Commit changes to a container");
        this.containerId = objectFactory.property(String.class);
        this.repo = objectFactory.property(String.class);
        this.tag = objectFactory.property(String.class);
        this.author = objectFactory.property(String.class);
        this.comment = objectFactory.property(String.class);
        this.changes = objectFactory.property(String.class);
        this.pauseContainer = objectFactory.property(Boolean.class);
        this.pauseContainer.convention((Object)true);
    }

    @TaskAction
    public EngineResponse commit() {
        this.getLogger().info("docker commit");
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("repo", this.getRepo().get());
        map.put("tag", this.getTag().getOrNull());
        map.put("comment", this.getComment().getOrNull());
        map.put("author", this.getAuthor().getOrNull());
        map.put("changes", this.getChanges().getOrNull());
        map.put("pause", this.getPauseContainer().getOrElse((Object)true));
        return this.getDockerClient().commit((String)this.getContainerId().get(), map);
    }
}

