/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.io.InputStream;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class DockerCopyFromContainerTask
extends GenericDockerTask {
    private final Property<String> container;
    private final Property<String> sourcePath;
    private EngineResponse<InputStream> content;

    @Input
    public Property<String> getContainer() {
        return this.container;
    }

    @Input
    public Property<String> getSourcePath() {
        return this.sourcePath;
    }

    @Internal
    public EngineResponse<InputStream> getContent() {
        return this.content;
    }

    @Inject
    public DockerCopyFromContainerTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Copy files/folders from a container to your host.");
        this.container = objectFactory.property(String.class);
        this.sourcePath = objectFactory.property(String.class);
    }

    @TaskAction
    public EngineResponse<InputStream> copyFromContainer() {
        this.getLogger().info("docker cp from container");
        this.content = this.getDockerClient().getArchive((String)this.getContainer().get(), (String)this.getSourcePath().get());
        return this.content;
    }
}

