/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.client.EnvFileParser;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.remote.api.ContainerCreateRequest;
import de.gesellix.docker.remote.api.HostConfig;
import de.gesellix.docker.remote.api.PortBinding;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerCreateTask
extends GenericDockerTask {
    private final Property<String> imageName;
    private final Property<String> imageTag;
    private final Property<String> containerName;
    private final ListProperty<String> ports;
    private final Property<ContainerCreateRequest> containerConfiguration;
    private final ListProperty<String> env;
    private final ListProperty<File> environmentFiles;
    private EngineResponse result;
    private final EnvFileParser envFileParser = new EnvFileParser();

    @Input
    public Property<String> getImageName() {
        return this.imageName;
    }

    @Input
    @Optional
    public Property<String> getImageTag() {
        return this.imageTag;
    }

    @Input
    @Optional
    public Property<String> getContainerName() {
        return this.containerName;
    }

    @Input
    @Optional
    public ListProperty<String> getPorts() {
        return this.ports;
    }

    @Input
    @Optional
    public Property<ContainerCreateRequest> getContainerConfiguration() {
        return this.containerConfiguration;
    }

    @Input
    @Optional
    public ListProperty<String> getEnv() {
        return this.env;
    }

    @Input
    @Optional
    public ListProperty<File> getEnvironmentFiles() {
        return this.environmentFiles;
    }

    @Internal
    public EngineResponse getResult() {
        return this.result;
    }

    @Inject
    public DockerCreateTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Create a new container");
        this.imageName = objectFactory.property(String.class);
        this.imageTag = objectFactory.property(String.class);
        this.imageTag.convention((Object)"");
        this.containerName = objectFactory.property(String.class);
        this.containerName.convention((Object)"");
        this.ports = objectFactory.listProperty(String.class);
        this.containerConfiguration = objectFactory.property(ContainerCreateRequest.class);
        this.containerConfiguration.convention((Object)new ContainerCreateRequest());
        this.env = objectFactory.listProperty(String.class);
        this.environmentFiles = objectFactory.listProperty(File.class);
    }

    @TaskAction
    public EngineResponse create() {
        this.getLogger().info("docker create");
        ContainerCreateRequest containerConfig = this.getActualContainerConfig();
        this.result = this.getDockerClient().createContainer(containerConfig, (String)this.getContainerName().getOrElse((Object)""), this.getEncodedAuthConfig());
        return this.result;
    }

    private String getImageNameWithTag() {
        if (this.getImageTag().isPresent() && !((String)this.getImageTag().get()).isEmpty()) {
            return (String)this.getImageName().get() + ":" + (String)this.getImageTag().get();
        }
        return (String)this.getImageName().get();
    }

    @Internal
    public ContainerCreateRequest getActualContainerConfig() {
        List env;
        ContainerCreateRequest containerCreateRequest = (ContainerCreateRequest)this.getContainerConfiguration().getOrElse((Object)new ContainerCreateRequest());
        if (containerCreateRequest.getHostConfig() == null) {
            containerCreateRequest.setHostConfig(new HostConfig());
        }
        containerCreateRequest.setImage(this.getImageNameWithTag());
        if (!((List)this.getEnvironmentFiles().get()).isEmpty()) {
            if (containerCreateRequest.getEnv() == null) {
                containerCreateRequest.setEnv(new ArrayList());
            }
            env = containerCreateRequest.getEnv();
            ((List)this.getEnvironmentFiles().get()).forEach(file -> {
                List parsedEnv = this.envFileParser.parse(file);
                env.addAll(parsedEnv);
            });
        }
        if (!((List)this.getEnv().get()).isEmpty()) {
            if (containerCreateRequest.getEnv() == null) {
                containerCreateRequest.setEnv(new ArrayList());
            }
            env = containerCreateRequest.getEnv();
            env.addAll((Collection)this.getEnv().get());
        }
        if (!((List)this.getPorts().get()).isEmpty()) {
            if (containerCreateRequest.getExposedPorts() == null) {
                containerCreateRequest.setExposedPorts(new HashMap());
            }
            Map exposedPorts = containerCreateRequest.getExposedPorts();
            if (containerCreateRequest.getHostConfig().getPortBindings() == null) {
                containerCreateRequest.getHostConfig().setPortBindings(new HashMap());
            }
            Map portBindings = containerCreateRequest.getHostConfig().getPortBindings();
            ((List)this.getPorts().get()).forEach(portMapping -> {
                String[] splittedPortMapping = portMapping.split(":");
                if (splittedPortMapping.length != 2) {
                    throw new UnsupportedOperationException("please use the plain `containerConfig.ExposedPorts and containerConfig.HostConfig.PortBindings` properties");
                }
                String hostPort = splittedPortMapping[0];
                String containerPort = splittedPortMapping[1] + "/tcp";
                exposedPorts.put(containerPort, new HashMap());
                PortBinding hostBinding = new PortBinding("0.0.0.0", hostPort);
                portBindings.put(containerPort, Collections.singletonList(hostBinding));
            });
        }
        this.getLogger().info("effective container config: " + containerCreateRequest);
        return containerCreateRequest;
    }
}

