/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.remote.api.ServiceSpec;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class DockerServiceCreateTask
extends GenericDockerTask {
    private final Property<ServiceSpec> serviceConfig;
    private EngineResponse response;

    @Input
    public Property<ServiceSpec> getServiceConfig() {
        return this.serviceConfig;
    }

    @Internal
    public EngineResponse getResponse() {
        return this.response;
    }

    @Inject
    public DockerServiceCreateTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Create a service");
        this.serviceConfig = objectFactory.property(ServiceSpec.class);
    }

    @TaskAction
    public void createService() {
        this.getLogger().info("docker service create");
        this.response = this.getDockerClient().createService((ServiceSpec)this.getServiceConfig().get());
    }
}

