/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.remote.api.ContainerWaitResponse;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerWaitTask
extends GenericDockerTask {
    private final Property<String> containerId;
    private final Property<Boolean> ignoreError;
    private EngineResponseContent<ContainerWaitResponse> result;

    @Input
    public Property<String> getContainerId() {
        return this.containerId;
    }

    @Input
    @Optional
    public Property<Boolean> getIgnoreError() {
        return this.ignoreError;
    }

    @Internal
    public EngineResponseContent<ContainerWaitResponse> getResult() {
        return this.result;
    }

    @Inject
    public DockerWaitTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Block until a container stops, then print its exit code.");
        this.containerId = objectFactory.property(String.class);
        this.ignoreError = objectFactory.property(Boolean.class);
        this.ignoreError.convention((Object)false);
    }

    @TaskAction
    public EngineResponseContent<ContainerWaitResponse> awaitStop() {
        this.getLogger().info("docker wait");
        try {
            this.result = this.getDockerClient().wait((String)this.getContainerId().get());
        }
        catch (Exception e) {
            if (!((Boolean)this.ignoreError.get()).booleanValue()) {
                throw new RuntimeException(e);
            }
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().warn("docker container wait " + (String)this.getContainerId().get() + " failed", (Throwable)e);
            }
            this.getLogger().warn("docker container wait " + (String)this.getContainerId().get() + " failed");
        }
        return this.result;
    }
}

