/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.remote.api.ContainerInspectResponse;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.util.HashMap;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerDisposeContainerTask
extends GenericDockerTask {
    private final Property<String> containerId;
    private final Property<Boolean> rmiParentImage;
    private final Property<Boolean> rmiParentImageIgnoreError;
    private final Property<Boolean> removeVolumes;

    @Input
    public Property<String> getContainerId() {
        return this.containerId;
    }

    @Input
    @Optional
    public Property<Boolean> getRmiParentImage() {
        return this.rmiParentImage;
    }

    @Input
    @Optional
    public Property<Boolean> getRmiParentImageIgnoreError() {
        return this.rmiParentImageIgnoreError;
    }

    @Input
    @Optional
    public Property<Boolean> getRemoveVolumes() {
        return this.removeVolumes;
    }

    @Inject
    public DockerDisposeContainerTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Stops and removes a container and optionally its parent image");
        this.containerId = objectFactory.property(String.class);
        this.rmiParentImage = objectFactory.property(Boolean.class);
        this.rmiParentImage.convention((Object)false);
        this.rmiParentImageIgnoreError = objectFactory.property(Boolean.class);
        this.rmiParentImageIgnoreError.convention((Object)false);
        this.removeVolumes = objectFactory.property(Boolean.class);
        this.removeVolumes.convention((Object)false);
    }

    @TaskAction
    public void dispose() {
        ContainerInspectResponse containerDetails;
        this.getLogger().info("docker dispose");
        String containerId = (String)this.getContainerId().get();
        try {
            containerDetails = (ContainerInspectResponse)this.getDockerClient().inspectContainer(containerId).getContent();
        }
        catch (ClientException e) {
            if (e.getStatusCode() == 404) {
                this.getLogger().info("couldn't dispose container because it doesn't exist");
                return;
            }
            throw e;
        }
        this.getDockerClient().stop(containerId);
        this.getDockerClient().wait(containerId);
        HashMap<String, Integer> query = new HashMap<String, Integer>(1);
        query.put("v", (Boolean)this.getRemoveVolumes().getOrElse((Object)false) != false ? 1 : 0);
        this.getDockerClient().rm(containerId, query);
        if (((Boolean)this.getRmiParentImage().getOrElse((Object)false)).booleanValue()) {
            try {
                this.getDockerClient().rmi(containerDetails.getImage());
            }
            catch (Exception e) {
                if (!((Boolean)this.rmiParentImageIgnoreError.get()).booleanValue()) {
                    throw new RuntimeException(e);
                }
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().warn("docker image rm " + containerDetails.getImage() + " failed", (Throwable)e);
                }
                this.getLogger().warn("docker image rm " + containerDetails.getImage() + " failed");
            }
        }
    }
}

