/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.remote.api.ImageInspect;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class DockerInspectImageTask
extends GenericDockerTask {
    private final Property<String> imageId;
    private EngineResponseContent<ImageInspect> imageInfo;

    @Input
    public Property<String> getImageId() {
        return this.imageId;
    }

    @Internal
    public EngineResponseContent<ImageInspect> getImageInfo() {
        return this.imageInfo;
    }

    @Inject
    public DockerInspectImageTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Return low-level information on image");
        this.imageId = objectFactory.property(String.class);
    }

    @TaskAction
    public void inspect() {
        this.getLogger().info("docker inspect");
        this.imageInfo = this.getDockerClient().inspectImage((String)this.getImageId().get());
    }
}

