/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketException;
import org.newsclub.net.unix.AFUNIXSocketImpl;

final class NativeUnixSocket {
    private static boolean loaded = false;

    NativeUnixSocket() {
    }

    static void load() {
        if (!NativeUnixSocket.isLoaded()) {
            File tmpLib;
            String[] stringArray;
            String osName = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            String javaSpec = System.getProperty("java.specification.version");
            String prefix = "lib";
            String suffix = ".so";
            String os = osName.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            if ("macosx".equals(os)) {
                suffix = ".dylib";
            } else if ("linux".equals(os) || "freebsd".equals(os) || "sunos".equals(os)) {
                suffix = ".so";
            } else {
                Logger.getLogger(NativeUnixSocket.class.getName()).log(Level.WARNING, "Operating System not officially supported by junixsocket: " + osName);
            }
            if ("1.5".equals(javaSpec)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = javaSpec;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = javaSpec;
                stringArray = stringArray3;
                stringArray3[1] = "1.5";
            }
            String[] javaSpecs = stringArray;
            InputStream in = null;
            ArrayList<String> paths = new ArrayList<String>();
            String libId = null;
            for (String js : javaSpecs) {
                libId = "libjunixsocket-" + os + "-" + js + "-" + arch;
                paths.add(libId + suffix);
                in = NativeUnixSocket.class.getResourceAsStream(libId + suffix);
                if (in != null) break;
            }
            if (in == null) {
                throw new UnsatisfiedLinkError("Could not find library in classpath, tried: " + paths);
            }
            try {
                int r;
                tmpLib = File.createTempFile(libId, suffix);
                tmpLib.deleteOnExit();
                byte[] buf = new byte[4096];
                FileOutputStream fos = new FileOutputStream(tmpLib);
                while ((r = in.read(buf)) != -1) {
                    fos.write(buf, 0, r);
                }
                fos.close();
                in.close();
            }
            catch (IOException e) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not create temporary file for library").initCause(e);
            }
            System.load(tmpLib.getAbsolutePath());
            loaded = true;
        }
    }

    static boolean isLoaded() {
        return loaded;
    }

    static void checkSupported() {
        NativeUnixSocket.load();
    }

    static native void bind(String var0, FileDescriptor var1, int var2) throws IOException;

    static native void listen(FileDescriptor var0, int var1) throws IOException;

    static native void accept(String var0, FileDescriptor var1, FileDescriptor var2) throws IOException;

    static native void connect(String var0, FileDescriptor var1) throws IOException;

    static native int read(FileDescriptor var0, byte[] var1, int var2, int var3) throws IOException;

    static native int write(FileDescriptor var0, byte[] var1, int var2, int var3) throws IOException;

    static native void close(FileDescriptor var0) throws IOException;

    static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    static native int getSocketOptionInt(FileDescriptor var0, int var1) throws IOException;

    static native void setSocketOptionInt(FileDescriptor var0, int var1, int var2) throws IOException;

    static native void unlink(String var0) throws IOException;

    static native int available(FileDescriptor var0) throws IOException;

    static native void initServerImpl(AFUNIXServerSocket var0, AFUNIXSocketImpl var1);

    static native void setCreated(AFUNIXSocket var0);

    static native void setConnected(AFUNIXSocket var0);

    static native void setBound(AFUNIXSocket var0);

    static native void setCreatedServer(AFUNIXServerSocket var0);

    static native void setBoundServer(AFUNIXServerSocket var0);

    static native void setPort(AFUNIXSocketAddress var0, int var1);

    static void setPort1(AFUNIXSocketAddress addr, int port) throws AFUNIXSocketException {
        if (port < 0) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        boolean setOk = false;
        try {
            Field holderField = InetSocketAddress.class.getDeclaredField("holder");
            if (holderField != null) {
                Field portField;
                holderField.setAccessible(true);
                Object holder = holderField.get(addr);
                if (holder != null && (portField = holder.getClass().getDeclaredField("port")) != null) {
                    portField.setAccessible(true);
                    portField.set(holder, port);
                    setOk = true;
                }
            } else {
                NativeUnixSocket.setPort(addr, port);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AFUNIXSocketException) {
                throw (AFUNIXSocketException)e;
            }
            throw new AFUNIXSocketException("Could not set port", e);
        }
        if (!setOk) {
            throw new AFUNIXSocketException("Could not set port");
        }
    }

    static {
        NativeUnixSocket.load();
    }
}

