/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.http;

import de.gmuth.http.SSLHelper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\bf\u0018\u0000 \u00042\u00020\u0001:\u0006\u0002\u0003\u0004\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lde/gmuth/http/Http;", "", "BasicAuth", "Client", "Companion", "Config", "Implementation", "Response", "ipp-client"})
public interface Http {
    @NotNull
    public static final Companion Companion = de.gmuth.http.Http$Companion.$$INSTANCE;

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010*\u001a\u00020+R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0011\"\u0004\b'\u0010\u0013R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001d\u00a8\u0006,"}, d2={"Lde/gmuth/http/Http$Config;", "", "timeout", "", "userAgent", "", "basicAuth", "Lde/gmuth/http/Http$BasicAuth;", "sslContext", "Ljavax/net/ssl/SSLContext;", "verifySSLHostname", "", "accept", "acceptEncoding", "debugLogging", "(ILjava/lang/String;Lde/gmuth/http/Http$BasicAuth;Ljavax/net/ssl/SSLContext;ZLjava/lang/String;Ljava/lang/String;Z)V", "getAccept", "()Ljava/lang/String;", "setAccept", "(Ljava/lang/String;)V", "getAcceptEncoding", "setAcceptEncoding", "getBasicAuth", "()Lde/gmuth/http/Http$BasicAuth;", "setBasicAuth", "(Lde/gmuth/http/Http$BasicAuth;)V", "getDebugLogging", "()Z", "setDebugLogging", "(Z)V", "getSslContext", "()Ljavax/net/ssl/SSLContext;", "setSslContext", "(Ljavax/net/ssl/SSLContext;)V", "getTimeout", "()I", "setTimeout", "(I)V", "getUserAgent", "setUserAgent", "getVerifySSLHostname", "setVerifySSLHostname", "trustAnyCertificate", "", "ipp-client"})
    public static final class Config {
        private int timeout;
        @Nullable
        private String userAgent;
        @Nullable
        private BasicAuth basicAuth;
        @Nullable
        private SSLContext sslContext;
        private boolean verifySSLHostname;
        @Nullable
        private String accept;
        @Nullable
        private String acceptEncoding;
        private boolean debugLogging;

        public Config(int timeout, @Nullable String userAgent, @Nullable BasicAuth basicAuth, @Nullable SSLContext sslContext, boolean verifySSLHostname, @Nullable String accept, @Nullable String acceptEncoding, boolean debugLogging) {
            this.timeout = timeout;
            this.userAgent = userAgent;
            this.basicAuth = basicAuth;
            this.sslContext = sslContext;
            this.verifySSLHostname = verifySSLHostname;
            this.accept = accept;
            this.acceptEncoding = acceptEncoding;
            this.debugLogging = debugLogging;
        }

        public /* synthetic */ Config(int n, String string, BasicAuth basicAuth, SSLContext sSLContext, boolean bl, String string2, String string3, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 30000;
            }
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                basicAuth = null;
            }
            if ((n2 & 8) != 0) {
                sSLContext = null;
            }
            if ((n2 & 0x10) != 0) {
                bl = true;
            }
            if ((n2 & 0x20) != 0) {
                string2 = null;
            }
            if ((n2 & 0x40) != 0) {
                string3 = null;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = false;
            }
            this(n, string, basicAuth, sSLContext, bl, string2, string3, bl2);
        }

        public final int getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(int n) {
            this.timeout = n;
        }

        @Nullable
        public final String getUserAgent() {
            return this.userAgent;
        }

        public final void setUserAgent(@Nullable String string) {
            this.userAgent = string;
        }

        @Nullable
        public final BasicAuth getBasicAuth() {
            return this.basicAuth;
        }

        public final void setBasicAuth(@Nullable BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
        }

        @Nullable
        public final SSLContext getSslContext() {
            return this.sslContext;
        }

        public final void setSslContext(@Nullable SSLContext sSLContext) {
            this.sslContext = sSLContext;
        }

        public final boolean getVerifySSLHostname() {
            return this.verifySSLHostname;
        }

        public final void setVerifySSLHostname(boolean bl) {
            this.verifySSLHostname = bl;
        }

        @Nullable
        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(@Nullable String string) {
            this.accept = string;
        }

        @Nullable
        public final String getAcceptEncoding() {
            return this.acceptEncoding;
        }

        public final void setAcceptEncoding(@Nullable String string) {
            this.acceptEncoding = string;
        }

        public final boolean getDebugLogging() {
            return this.debugLogging;
        }

        public final void setDebugLogging(boolean bl) {
            this.debugLogging = bl;
        }

        public final void trustAnyCertificate() {
            this.sslContext = SSLHelper.INSTANCE.sslContextForAnyCertificate();
        }

        public Config() {
            this(0, null, null, null, false, null, null, false, 255, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lde/gmuth/http/Http$BasicAuth;", "", "user", "", "password", "(Ljava/lang/String;Ljava/lang/String;)V", "getPassword", "()Ljava/lang/String;", "getUser", "encodeBase64", "ipp-client"})
    public static final class BasicAuth {
        @NotNull
        private final String user;
        @NotNull
        private final String password;

        public BasicAuth(@NotNull String user, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.user = user;
            this.password = password;
        }

        @NotNull
        public final String getUser() {
            return this.user;
        }

        @NotNull
        public final String getPassword() {
            return this.password;
        }

        @NotNull
        public final String encodeBase64() {
            Base64.Encoder encoder = Base64.getEncoder();
            String string = this.user + ':' + this.password;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String string3 = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getEncoder().encodeToStr\u2026$password\".toByteArray())");
            return string3;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0005R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lde/gmuth/http/Http$Response;", "", "status", "", "server", "", "contentType", "contentStream", "Ljava/io/InputStream;", "(ILjava/lang/String;Ljava/lang/String;Ljava/io/InputStream;)V", "getContentStream", "()Ljava/io/InputStream;", "getContentType", "()Ljava/lang/String;", "getServer", "getStatus", "()I", "contentTypeIsText", "", "hasContent", "hasContentType", "isOK", "readTextContent", "textContent", "ipp-client"})
    public static final class Response {
        private final int status;
        @Nullable
        private final String server;
        @Nullable
        private final String contentType;
        @Nullable
        private final InputStream contentStream;

        public Response(int status, @Nullable String server, @Nullable String contentType, @Nullable InputStream contentStream) {
            this.status = status;
            this.server = server;
            this.contentType = contentType;
            this.contentStream = contentStream;
        }

        public final int getStatus() {
            return this.status;
        }

        @Nullable
        public final String getServer() {
            return this.server;
        }

        @Nullable
        public final String getContentType() {
            return this.contentType;
        }

        @Nullable
        public final InputStream getContentStream() {
            return this.contentStream;
        }

        public final boolean isOK() {
            return this.status == 200;
        }

        public final boolean hasContent() {
            return this.contentStream != null;
        }

        public final boolean hasContentType() {
            return this.contentType != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String readTextContent() {
            InputStream inputStream = this.contentStream;
            Intrinsics.checkNotNull((Object)inputStream);
            Closeable closeable = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object = closeable;
            int n = 0;
            object = new InputStreamReader((InputStream)object, charset);
            n = 8192;
            boolean bl2 = false;
            closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            boolean bl3 = false;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl4 = false;
                object = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean contentTypeIsText() {
            if (!this.hasContentType()) return false;
            String string = this.contentType;
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.startsWith$default((String)string, (String)"text", (boolean)false, (int)2, null)) return false;
            return true;
        }

        @NotNull
        public final String textContent() {
            return this.hasContent() && this.contentTypeIsText() ? Intrinsics.stringPlus((String)"\n", (Object)this.readTextContent()) : "";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lde/gmuth/http/Http$Client;", "", "config", "Lde/gmuth/http/Http$Config;", "(Lde/gmuth/http/Http$Config;)V", "getConfig", "()Lde/gmuth/http/Http$Config;", "post", "Lde/gmuth/http/Http$Response;", "uri", "Ljava/net/URI;", "contentType", "", "writeContent", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "", "chunked", "", "ipp-client"})
    public static abstract class Client {
        @NotNull
        private final Config config;

        public Client(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        @NotNull
        public abstract Response post(@NotNull URI var1, @NotNull String var2, @NotNull Function1<? super OutputStream, Unit> var3, boolean var4);

        public static /* synthetic */ Response post$default(Client client, URI uRI, String string, Function1 function1, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: post");
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            return client.post(uRI, string, (Function1<? super OutputStream, Unit>)function1, bl);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B*\b\u0002\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tR,\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lde/gmuth/http/Http$Implementation;", "", "createClient", "Lkotlin/Function1;", "Lde/gmuth/http/Http$Config;", "Lkotlin/ParameterName;", "name", "config", "Lde/gmuth/http/Http$Client;", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "getCreateClient", "()Lkotlin/jvm/functions/Function1;", "JavaHttpURLConnection", "Java11HttpClient", "ipp-client"})
    public static final class Implementation
    extends Enum<Implementation> {
        @NotNull
        private final Function1<Config, Client> createClient;
        public static final /* enum */ Implementation JavaHttpURLConnection = new Implementation((Function1<? super Config, ? extends Client>)((Function1)1.INSTANCE));
        public static final /* enum */ Implementation Java11HttpClient = new Implementation((Function1<? super Config, ? extends Client>)((Function1)2.INSTANCE));
        private static final /* synthetic */ Implementation[] $VALUES;

        private Implementation(Function1<? super Config, ? extends Client> createClient) {
            this.createClient = createClient;
        }

        @NotNull
        public final Function1<Config, Client> getCreateClient() {
            return this.createClient;
        }

        public static Implementation[] values() {
            return (Implementation[])$VALUES.clone();
        }

        public static Implementation valueOf(String value2) {
            return Enum.valueOf(Implementation.class, value2);
        }

        static {
            $VALUES = implementationArray = new Implementation[]{Implementation.JavaHttpURLConnection, Implementation.Java11HttpClient};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lde/gmuth/http/Http$Companion;", "", "()V", "defaultImplementation", "Lde/gmuth/http/Http$Implementation;", "getDefaultImplementation", "()Lde/gmuth/http/Http$Implementation;", "setDefaultImplementation", "(Lde/gmuth/http/Http$Implementation;)V", "ipp-client"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static Implementation defaultImplementation;

        private Companion() {
        }

        @NotNull
        public final Implementation getDefaultImplementation() {
            return defaultImplementation;
        }

        public final void setDefaultImplementation(@NotNull Implementation implementation) {
            Intrinsics.checkNotNullParameter((Object)((Object)implementation), (String)"<set-?>");
            defaultImplementation = implementation;
        }

        static {
            $$INSTANCE = new Companion();
            defaultImplementation = Implementation.JavaHttpURLConnection;
        }
    }
}

