/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.http;

import de.gmuth.http.Http;
import de.gmuth.http.HttpURLConnectionClient;
import de.gmuth.log.Logging;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lde/gmuth/http/HttpURLConnectionClient;", "Lde/gmuth/http/Http$Client;", "config", "Lde/gmuth/http/Http$Config;", "(Lde/gmuth/http/Http$Config;)V", "post", "Lde/gmuth/http/Http$Response;", "uri", "Ljava/net/URI;", "contentType", "", "writeContent", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "", "chunked", "", "Companion", "ipp-client"})
public final class HttpURLConnectionClient
extends Http.Client {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);
    @NotNull
    private static final Handler julHandler = new Handler(){

        public void publish(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            LogRecord logRecord = record;
            boolean bl = false;
            boolean bl2 = false;
            LogRecord $this$publish_u24lambda_u2d0 = logRecord;
            boolean bl3 = false;
            String string = $this$publish_u24lambda_u2d0.getLoggerName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loggerName");
            Logging.Logger.log$default(Logging.INSTANCE.getLogger(string, Logging.LogLevel.DEBUG), Logging.LogLevel.DEBUG, null, (Function0)new Function0<Object>($this$publish_u24lambda_u2d0){
                final /* synthetic */ LogRecord $this_run;
                {
                    this.$this_run = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$this_run.getMessage();
                }
            }, 2, null);
        }

        public void flush() {
        }

        public void close() {
        }
    };

    public HttpURLConnectionClient(@NotNull Http.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
        Logging.Logger.debug$default(log, null, 1.INSTANCE, 1, null);
        if (config.getDebugLogging()) {
            Logger logger = Logger.getLogger("sun.net.www.protocol.http.HttpURLConnection");
            boolean bl = false;
            boolean bl2 = false;
            Logger $this$_init__u24lambda_u2d0 = logger;
            boolean bl3 = false;
            Handler[] handlerArray = $this$_init__u24lambda_u2d0.getHandlers();
            Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"handlers");
            if (!ArraysKt.contains((Object[])handlerArray, (Object)julHandler)) {
                $this$_init__u24lambda_u2d0.addHandler(julHandler);
            }
            $this$_init__u24lambda_u2d0.setLevel(Level.ALL);
        }
    }

    public /* synthetic */ HttpURLConnectionClient(Http.Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = new Http.Config(0, null, null, null, false, null, null, false, 255, null);
        }
        this(config);
    }

    @Override
    @NotNull
    public Http.Response post(@NotNull URI uri, @NotNull String contentType, @NotNull Function1<? super OutputStream, Unit> writeContent, boolean chunked) {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter(writeContent, (String)"writeContent");
        URLConnection uRLConnection = uri.toURL().openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        uRLConnection = (HttpURLConnection)uRLConnection;
        boolean bl3 = false;
        boolean bl4 = false;
        URLConnection $this$post_u24lambda_u2d6 = uRLConnection;
        boolean bl5 = false;
        if ($this$post_u24lambda_u2d6 instanceof HttpsURLConnection && this.getConfig().getSslContext() != null) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)$this$post_u24lambda_u2d6;
            SSLContext sSLContext = this.getConfig().getSslContext();
            Intrinsics.checkNotNull((Object)sSLContext);
            httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
            if (!this.getConfig().getVerifySSLHostname()) {
                ((HttpsURLConnection)$this$post_u24lambda_u2d6).setHostnameVerifier(post.1.1.INSTANCE);
            }
        }
        $this$post_u24lambda_u2d6.setDoOutput(true);
        Iterator<Map.Entry<String, List<String>>> iterator = this.getConfig();
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$post_u24lambda_u2d6_u24lambda_u2d5 = iterator;
        boolean bl8 = false;
        $this$post_u24lambda_u2d6.setConnectTimeout(((Http.Config)$this$post_u24lambda_u2d6_u24lambda_u2d5).getTimeout());
        $this$post_u24lambda_u2d6.setReadTimeout(((Http.Config)$this$post_u24lambda_u2d6_u24lambda_u2d5).getTimeout());
        Object object2 = ((Http.Config)$this$post_u24lambda_u2d6_u24lambda_u2d5).getAccept();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl9 = false;
            $this$post_u24lambda_u2d6.setRequestProperty("Accept", (String)it);
        }
        object2 = ((Http.Config)$this$post_u24lambda_u2d6_u24lambda_u2d5).getAcceptEncoding();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl10 = false;
            $this$post_u24lambda_u2d6.setRequestProperty("Accept-Encoding", (String)it);
        }
        object2 = ((Http.Config)$this$post_u24lambda_u2d6_u24lambda_u2d5).getBasicAuth();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl11 = false;
            $this$post_u24lambda_u2d6.setRequestProperty("Authorization", Intrinsics.stringPlus((String)"Basic ", (Object)((Http.BasicAuth)it).encodeBase64()));
        }
        object2 = ((Http.Config)$this$post_u24lambda_u2d6_u24lambda_u2d5).getUserAgent();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl12 = false;
            $this$post_u24lambda_u2d6.setRequestProperty("User-Agent", (String)it);
        }
        $this$post_u24lambda_u2d6.setRequestProperty("Content-Type", contentType);
        if (chunked) {
            ((HttpURLConnection)$this$post_u24lambda_u2d6).setChunkedStreamingMode(0);
        }
        iterator = $this$post_u24lambda_u2d6.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"outputStream");
        writeContent.invoke((Object)iterator);
        Object object3 = $this$post_u24lambda_u2d6.getHeaderFields();
        Intrinsics.checkNotNullExpressionValue(object3, (String)"headerFields");
        bl7 = false;
        iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            $this$post_u24lambda_u2d6_u24lambda_u2d5 = object3 = iterator.next();
            boolean bl13 = false;
            String key = (String)$this$post_u24lambda_u2d6_u24lambda_u2d5.getKey();
            Object object4 = object3;
            boolean bl14 = false;
            List values = (List)object4.getValue();
            Logging.Logger.log$default(log, ((HttpURLConnection)$this$post_u24lambda_u2d6).getResponseCode() < 300 ? Logging.LogLevel.TRACE : Logging.LogLevel.ERROR, null, (Function0)new Function0<Object>(key, (List<String>)values){
                final /* synthetic */ String $key;
                final /* synthetic */ List<String> $values;
                {
                    this.$key = $key;
                    this.$values = $values;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$key + " = " + this.$values;
                }
            }, 2, null);
        }
        try {
            object3 = $this$post_u24lambda_u2d6.getInputStream();
        }
        catch (Exception exception) {
            Logging.Logger.error$default(log, null, (Function0)new Function0<Object>((HttpURLConnection)$this$post_u24lambda_u2d6){
                final /* synthetic */ HttpURLConnection $this_with;
                {
                    this.$this_with = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "http exception: " + this.$this_with.getResponseCode() + ' ' + this.$this_with.getResponseMessage();
                }
            }, 1, null);
            object3 = ((HttpURLConnection)$this$post_u24lambda_u2d6).getErrorStream();
        }
        Object responseStream2 = object3;
        return new Http.Response(((HttpURLConnection)$this$post_u24lambda_u2d6).getResponseCode(), $this$post_u24lambda_u2d6.getHeaderField("Server"), $this$post_u24lambda_u2d6.getHeaderField("Content-Type"), (InputStream)responseStream2);
    }

    public HttpURLConnectionClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lde/gmuth/http/HttpURLConnectionClient$Companion;", "", "()V", "julHandler", "Ljava/util/logging/Handler;", "getJulHandler", "()Ljava/util/logging/Handler;", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        @NotNull
        public final Handler getJulHandler() {
            return julHandler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

