/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.http.Http;
import de.gmuth.ipp.client.CupsClient;
import de.gmuth.ipp.client.IppClient;
import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.log.Logging;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lde/gmuth/ipp/client/CupsClient;", "Lde/gmuth/ipp/client/IppClient;", "host", "", "(Ljava/lang/String;)V", "cupsUri", "Ljava/net/URI;", "config", "Lde/gmuth/ipp/client/IppConfig;", "httpClient", "Lde/gmuth/http/Http$Client;", "(Ljava/net/URI;Lde/gmuth/ipp/client/IppConfig;Lde/gmuth/http/Http$Client;)V", "getCupsUri", "()Ljava/net/URI;", "printerMap", "", "Lde/gmuth/ipp/client/IppPrinter;", "getPrinterMap", "()Ljava/util/Map;", "printerMap$delegate", "Lkotlin/Lazy;", "getDefault", "getPrinter", "name", "getPrinters", "", "ippRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "Lde/gmuth/ipp/core/IppOperation;", "setDefault", "Lde/gmuth/ipp/core/IppResponse;", "defaultPrinterUri", "Companion", "ipp-client"})
public class CupsClient
extends IppClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI cupsUri;
    @NotNull
    private final Lazy printerMap$delegate;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);

    public CupsClient(@NotNull URI cupsUri, @NotNull IppConfig config, @NotNull Http.Client httpClient2) {
        Intrinsics.checkNotNullParameter((Object)cupsUri, (String)"cupsUri");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        super(config, httpClient2);
        this.cupsUri = cupsUri;
        if (Intrinsics.areEqual((Object)this.cupsUri.getScheme(), (Object)"ipps")) {
            Http.Config config2 = httpClient2.getConfig();
            boolean bl = false;
            boolean bl2 = false;
            Http.Config $this$_init__u24lambda_u2d0 = config2;
            boolean bl3 = false;
            $this$_init__u24lambda_u2d0.setVerifySSLHostname(false);
            $this$_init__u24lambda_u2d0.trustAnyCertificate();
        }
        this.printerMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends IppPrinter>>(this){
            final /* synthetic */ CupsClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, IppPrinter> invoke() {
                void $this$associateByTo$iv$iv;
                Object object;
                IppPrinter it;
                Object object2;
                Iterable $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = IppClient.exchange$default(this.this$0, this.this$0.ippRequest(IppOperation.CupsGetPrinters), false, 2, null).getAttributesGroups(IppTag.Printer);
                CupsClient cupsClient = this.this$0;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl = false;
                    object = new IppPrinter((IppAttributesGroup)((Object)it), cupsClient);
                    object2.add(object);
                }
                Iterable $this$associateBy$iv = (List)destination$iv$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                $this$mapTo$iv$iv = $this$associateBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    it = (IppPrinter)element$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl = false;
                    object = it.getName().getText();
                    object2.put(object, element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
    }

    public /* synthetic */ CupsClient(URI uRI, IppConfig ippConfig, Http.Client client, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = URI.create("ipp://localhost");
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"create(\"ipp://localhost\")");
            uRI = uRI2;
        }
        if ((n & 2) != 0) {
            ippConfig = new IppConfig(null, null, null, null, false, null, 63, null);
        }
        if ((n & 4) != 0) {
            client = (Http.Client)Http.Companion.getDefaultImplementation().getCreateClient().invoke((Object)new Http.Config(0, null, null, null, false, null, null, false, 255, null));
        }
        this(uRI, ippConfig, client);
    }

    @NotNull
    public final URI getCupsUri() {
        return this.cupsUri;
    }

    public CupsClient(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        URI uRI = URI.create(Intrinsics.stringPlus((String)"ipp://", (Object)host));
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"ipp://$host\")");
        this(uRI, null, null, 6, null);
    }

    public /* synthetic */ CupsClient(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "localhost";
        }
        this(string);
    }

    @NotNull
    public final Map<String, IppPrinter> getPrinterMap() {
        Lazy lazy = this.printerMap$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Collection<IppPrinter> getPrinters() {
        return this.getPrinterMap().values();
    }

    @NotNull
    public final IppPrinter getPrinter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IppPrinter ippPrinter = this.getPrinterMap().get(name);
        if (ippPrinter == null) {
            IppException ippException = new IppException(Intrinsics.stringPlus((String)"no such cups printer: ", (Object)name), null, 2, null);
            boolean bl = false;
            boolean bl2 = false;
            IppException it = ippException;
            boolean bl3 = false;
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ CupsClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"available printers: ", (Object)CollectionsKt.joinToString$default((Iterable)this.this$0.getPrinterMap().keySet(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                }
            }, 1, null);
            throw (Throwable)ippException;
        }
        return ippPrinter;
    }

    @NotNull
    protected final IppRequest ippRequest(@NotNull IppOperation operation) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return IppClient.ippRequest$default(this, operation, this.cupsUri, null, null, 12, null);
    }

    @NotNull
    public final IppPrinter getDefault() {
        return new IppPrinter(IppClient.exchange$default(this, this.ippRequest(IppOperation.CupsGetDefault), false, 2, null).getPrinterGroup(), this);
    }

    @NotNull
    public final IppResponse setDefault(@NotNull URI defaultPrinterUri) {
        Intrinsics.checkNotNullParameter((Object)defaultPrinterUri, (String)"defaultPrinterUri");
        return IppClient.exchange$default(this, IppClient.ippRequest$default(this, IppOperation.CupsSetDefault, defaultPrinterUri, null, null, 12, null), false, 2, null);
    }

    public CupsClient() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/client/CupsClient$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

