/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lde/gmuth/ipp/client/CupsMarker;", "", "type", "", "name", "level", "", "lowLevel", "highLevel", "colorCode", "(Ljava/lang/String;Ljava/lang/String;IIILjava/lang/String;)V", "color", "Lde/gmuth/ipp/client/CupsMarker$Color;", "getColor", "()Lde/gmuth/ipp/client/CupsMarker$Color;", "getColorCode", "()Ljava/lang/String;", "getHighLevel", "()I", "getLevel", "getLowLevel", "getName", "getType", "levelIsLow", "", "levelPercent", "toString", "Color", "ipp-client"})
public final class CupsMarker {
    @NotNull
    private final String type;
    @NotNull
    private final String name;
    private final int level;
    private final int lowLevel;
    private final int highLevel;
    @NotNull
    private final String colorCode;
    @NotNull
    private final Color color;

    public CupsMarker(@NotNull String type, @NotNull String name, int level, int lowLevel, int highLevel, @NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        this.type = type;
        this.name = name;
        this.level = level;
        this.lowLevel = lowLevel;
        this.highLevel = highLevel;
        this.colorCode = colorCode;
        this.color = Color.Companion.fromString(this.colorCode);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getLevel() {
        return this.level;
    }

    public final int getLowLevel() {
        return this.lowLevel;
    }

    public final int getHighLevel() {
        return this.highLevel;
    }

    @NotNull
    public final String getColorCode() {
        return this.colorCode;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final int levelPercent() {
        return 100 * this.level / this.highLevel;
    }

    public final boolean levelIsLow() {
        return this.level <= this.lowLevel;
    }

    @NotNull
    public String toString() {
        String string = "%-10s %3d %% %5s %-6s %-7s %s";
        Object[] objectArray = new Object[]{this.color, this.levelPercent(), this.levelIsLow() ? "(low)" : "", this.type, this.colorCode, this.name};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lde/gmuth/ipp/client/CupsMarker$Color;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "NONE", "CYAN", "BLACK", "YELLOW", "MAGENTA", "Companion", "ipp-client"})
    public static final class Color
    extends Enum<Color> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ Color NONE;
        public static final /* enum */ Color CYAN;
        public static final /* enum */ Color BLACK;
        public static final /* enum */ Color YELLOW;
        public static final /* enum */ Color MAGENTA;
        private static final /* synthetic */ Color[] $VALUES;

        private Color(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public static Color[] values() {
            return (Color[])$VALUES.clone();
        }

        public static Color valueOf(String value2) {
            return Enum.valueOf(Color.class, value2);
        }

        static {
            NONE = new Color("none");
            CYAN = new Color("#00FFFF");
            BLACK = new Color("#000000");
            YELLOW = new Color("#FFFF00");
            MAGENTA = new Color("#FF00FF");
            $VALUES = colorArray = new Color[]{Color.NONE, Color.CYAN, Color.BLACK, Color.YELLOW, Color.MAGENTA};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/client/CupsMarker$Color$Companion;", "", "()V", "fromString", "Lde/gmuth/ipp/client/CupsMarker$Color;", "code", "", "ipp-client"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Color fromString(@NotNull String code) {
                Color color;
                boolean bl;
                Object[] objectArray;
                Object[] objectArray2;
                block2: {
                    Color color2;
                    Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                    objectArray2 = Color.values();
                    boolean bl2 = false;
                    objectArray = objectArray2;
                    bl = false;
                    Object[] objectArray3 = objectArray;
                    int n = objectArray3.length;
                    for (int i = 0; i < n; ++i) {
                        Color color3;
                        Color it = color3 = objectArray3[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getCode(), (Object)code)) continue;
                        color2 = color3;
                        break block2;
                    }
                    color2 = color = null;
                }
                if (color == null) {
                    objectArray2 = StringCompanionObject.INSTANCE;
                    String string = "color code %s";
                    objectArray = new Object[]{code};
                    bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    throw new IllegalArgumentException(string2);
                }
                return color;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

