/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.http.Http;
import de.gmuth.ipp.client.IppClient;
import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppStatus;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import de.gmuth.log.Logging;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0016\u0018\u0000 C2\u00020\u0001:\u0001CB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u0016\u0010/\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u00100\u001a\u000201J\u001a\u00102\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00132\b\b\u0002\u00103\u001a\u00020 H\u0016J\u0016\u00104\u001a\u0002012\u0006\u00105\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u0013J9\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002062\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\u0010\b\u0002\u0010=\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010>\u00a2\u0006\u0002\u0010?J\u0016\u0010@\u001a\n A*\u0004\u0018\u000106062\u0006\u0010B\u001a\u000206R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010\u0011\u001a:\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0012j\u0004\u0018\u0001`\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006D"}, d2={"Lde/gmuth/ipp/client/IppClient;", "", "config", "Lde/gmuth/ipp/client/IppConfig;", "httpClient", "Lde/gmuth/http/Http$Client;", "(Lde/gmuth/ipp/client/IppConfig;Lde/gmuth/http/Http$Client;)V", "getConfig", "()Lde/gmuth/ipp/client/IppConfig;", "getHttpClient", "()Lde/gmuth/http/Http$Client;", "httpConfig", "Lde/gmuth/http/Http$Config;", "getHttpConfig", "()Lde/gmuth/http/Http$Config;", "requestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "responseInterceptor", "Lkotlin/Function2;", "Lde/gmuth/ipp/core/IppRequest;", "Lkotlin/ParameterName;", "name", "request", "Lde/gmuth/ipp/core/IppResponse;", "response", "", "Lde/gmuth/ipp/client/IppResponseInterceptor;", "getResponseInterceptor", "()Lkotlin/jvm/functions/Function2;", "setResponseInterceptor", "(Lkotlin/jvm/functions/Function2;)V", "saveMessages", "", "getSaveMessages", "()Z", "setSaveMessages", "(Z)V", "saveMessagesDirectory", "Ljava/io/File;", "getSaveMessagesDirectory", "()Ljava/io/File;", "setSaveMessagesDirectory", "(Ljava/io/File;)V", "basicAuth", "user", "", "password", "decodeIppResponse", "httpResponse", "Lde/gmuth/http/Http$Response;", "exchange", "throwWhenNotSuccessful", "httpPostRequest", "httpUri", "Ljava/net/URI;", "ippRequest", "operation", "Lde/gmuth/ipp/core/IppOperation;", "printerUri", "jobId", "", "requestedAttributes", "", "(Lde/gmuth/ipp/core/IppOperation;Ljava/net/URI;Ljava/lang/Integer;Ljava/util/List;)Lde/gmuth/ipp/core/IppRequest;", "toHttpUri", "kotlin.jvm.PlatformType", "ippUri", "Companion", "ipp-client"})
public class IppClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppConfig config;
    @NotNull
    private final Http.Client httpClient;
    private boolean saveMessages;
    @NotNull
    private File saveMessagesDirectory;
    @Nullable
    private Function2<? super IppRequest, ? super IppResponse, Unit> responseInterceptor;
    @NotNull
    private final AtomicInteger requestCounter;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);
    @NotNull
    public static final String APPLICATION_IPP = "application/ipp";
    @NotNull
    public static final String version = "2.3";
    @NotNull
    public static final String build = "20220627";

    public IppClient(@NotNull IppConfig config, @NotNull Http.Client httpClient2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        this.config = config;
        this.httpClient = httpClient2;
        this.saveMessagesDirectory = new File("ipp-messages");
        Http.Config config2 = this.getHttpConfig();
        boolean bl = false;
        boolean bl2 = false;
        Http.Config $this$_init__u24lambda_u2d0 = config2;
        boolean bl3 = false;
        $this$_init__u24lambda_u2d0.setUserAgent("ipp-client/2.3");
        $this$_init__u24lambda_u2d0.setAcceptEncoding("identity");
        $this$_init__u24lambda_u2d0.setAccept(APPLICATION_IPP);
        this.requestCounter = new AtomicInteger(1);
    }

    public /* synthetic */ IppClient(IppConfig ippConfig, Http.Client client, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ippConfig = new IppConfig(null, null, null, null, false, null, 63, null);
        }
        if ((n & 2) != 0) {
            client = (Http.Client)Http.Companion.getDefaultImplementation().getCreateClient().invoke((Object)new Http.Config(0, null, null, null, false, null, null, false, 255, null));
        }
        this(ippConfig, client);
    }

    @NotNull
    public final IppConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Http.Client getHttpClient() {
        return this.httpClient;
    }

    public final boolean getSaveMessages() {
        return this.saveMessages;
    }

    public final void setSaveMessages(boolean bl) {
        this.saveMessages = bl;
    }

    @NotNull
    public final File getSaveMessagesDirectory() {
        return this.saveMessagesDirectory;
    }

    public final void setSaveMessagesDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.saveMessagesDirectory = file;
    }

    @Nullable
    public final Function2<IppRequest, IppResponse, Unit> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public final void setResponseInterceptor(@Nullable Function2<? super IppRequest, ? super IppResponse, Unit> function2) {
        this.responseInterceptor = function2;
    }

    @NotNull
    public final Http.Config getHttpConfig() {
        return this.httpClient.getConfig();
    }

    public final void basicAuth(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.getHttpConfig().setBasicAuth(new Http.BasicAuth(user, password));
    }

    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @NotNull URI printerUri, @Nullable Integer jobId, @Nullable List<String> requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        return new IppRequest(operation, printerUri, jobId, requestedAttributes, this.config.getUserName(), this.config.getIppVersion(), this.requestCounter.getAndIncrement(), this.config.getCharset(), this.config.getNaturalLanguage());
    }

    public static /* synthetic */ IppRequest ippRequest$default(IppClient ippClient, IppOperation ippOperation, URI uRI, Integer n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ippRequest");
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            list = null;
        }
        return ippClient.ippRequest(ippOperation, uRI, n, list);
    }

    @NotNull
    public IppResponse exchange(@NotNull IppRequest request2, boolean throwWhenNotSuccessful) {
        Function2<? super IppRequest, ? super IppResponse, Unit> function2;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        URI ippUri = request2.getPrinterUri();
        URI httpUri = this.toHttpUri(ippUri);
        Logging.Logger.trace$default(log, null, (Function0)new Function0<Object>(request2, ippUri){
            final /* synthetic */ IppRequest $request;
            final /* synthetic */ URI $ippUri;
            {
                this.$request = $request;
                this.$ippUri = $ippUri;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "send '" + (Object)((Object)this.$request.getOperation()) + "' request to " + this.$ippUri;
            }
        }, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)httpUri, (String)"httpUri");
        Http.Response httpResponse = this.httpPostRequest(httpUri, request2);
        IppResponse response = this.decodeIppResponse(request2, httpResponse);
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(ippUri, request2, response){
            final /* synthetic */ URI $ippUri;
            final /* synthetic */ IppRequest $request;
            final /* synthetic */ IppResponse $response;
            {
                this.$ippUri = $ippUri;
                this.$request = $request;
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$ippUri + ": " + this.$request + " => " + this.$response;
            }
        }, 1, null);
        if (this.saveMessages) {
            File file = new File(this.saveMessagesDirectory, ippUri.getHost());
            boolean bl = false;
            boolean bl2 = false;
            File $this$exchange_u24lambda_u2d1 = file;
            boolean bl3 = false;
            if (!$this$exchange_u24lambda_u2d1.mkdirs() && !$this$exchange_u24lambda_u2d1.isDirectory()) {
                throw new IppException(Intrinsics.stringPlus((String)"failed to create directory: ", (Object)$this$exchange_u24lambda_u2d1.getPath()), null, 2, null);
            }
            File messageSubDirectory = file;
            request2.saveRawBytes(IppClient.exchange$file(messageSubDirectory, request2, "request"));
            response.saveRawBytes(IppClient.exchange$file(messageSubDirectory, request2, "response"));
        }
        if ((function2 = this.responseInterceptor) != null) {
            function2.invoke((Object)request2, (Object)response);
        }
        if (!response.isSuccessful()) {
            IppRegistrationsSection2.INSTANCE.validate(request2);
            if (throwWhenNotSuccessful) {
                throw new IppExchangeException(request2, response, null, null, null, 28, null);
            }
        }
        return response;
    }

    public static /* synthetic */ IppResponse exchange$default(IppClient ippClient, IppRequest ippRequest, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exchange");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return ippClient.exchange(ippRequest, bl);
    }

    public final URI toHttpUri(@NotNull URI ippUri) {
        Intrinsics.checkNotNullParameter((Object)ippUri, (String)"ippUri");
        boolean bl = false;
        boolean bl2 = false;
        URI $this$toHttpUri_u24lambda_u2d2 = ippUri;
        boolean bl3 = false;
        String string = $this$toHttpUri_u24lambda_u2d2.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scheme");
        String scheme = StringsKt.replace$default((String)string, (String)"ipp", (String)"http", (boolean)false, (int)4, null);
        int port = $this$toHttpUri_u24lambda_u2d2.getPort() == -1 ? 631 : $this$toHttpUri_u24lambda_u2d2.getPort();
        return URI.create(scheme + "://" + $this$toHttpUri_u24lambda_u2d2.getHost() + ':' + port + $this$toHttpUri_u24lambda_u2d2.getPath());
    }

    @NotNull
    public final Http.Response httpPostRequest(@NotNull URI httpUri, @NotNull IppRequest request2) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)httpUri, (String)"httpUri");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Http.Response response = this.httpClient.post(httpUri, APPLICATION_IPP, (Function1<? super OutputStream, Unit>)((Function1)new Function1<OutputStream, Unit>(request2){
            final /* synthetic */ IppRequest $request;
            {
                this.$request = $request;
                super(1);
            }

            public final void invoke(@NotNull OutputStream httpPostStream) {
                Intrinsics.checkNotNullParameter((Object)httpPostStream, (String)"httpPostStream");
                this.$request.write(httpPostStream);
            }
        }), request2.hasDocument());
        boolean bl = false;
        boolean bl2 = false;
        Http.Response $this$httpPostRequest_u24lambda_u2d5 = response;
        boolean bl3 = false;
        if (!$this$httpPostRequest_u24lambda_u2d5.isOK()) {
            string2 = "http request to " + httpUri + " failed: status=" + $this$httpPostRequest_u24lambda_u2d5.getStatus() + ", content-type=" + $this$httpPostRequest_u24lambda_u2d5.getContentType() + $this$httpPostRequest_u24lambda_u2d5.textContent();
        } else if (!$this$httpPostRequest_u24lambda_u2d5.hasContentType()) {
            string2 = "missing content-type in http response (application/ipp required)";
        } else {
            String string3 = $this$httpPostRequest_u24lambda_u2d5.getContentType();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string = !StringsKt.startsWith$default((String)string3, (String)APPLICATION_IPP, (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)"invalid content-type: ", (Object)$this$httpPostRequest_u24lambda_u2d5.getContentType()) : null;
        }
        if (string != null) {
            String string4 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string4;
            boolean bl6 = false;
            String string5 = $this$httpPostRequest_u24lambda_u2d5.getServer();
            if (string5 != null) {
                String string6 = string5;
                boolean bl7 = false;
                boolean bl8 = false;
                String $this$httpPostRequest_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3 = string6;
                boolean bl9 = false;
                Logging.Logger.info$default(log, null, (Function0)new Function0<Object>($this$httpPostRequest_u24lambda_u2d5){
                    final /* synthetic */ Http.Response $this_apply;
                    {
                        this.$this_apply = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)"ipp-server: ", (Object)this.$this_apply.getServer());
                    }
                }, 1, null);
            }
            this.getConfig().logDetails();
            IppMessage.logDetails$default(request2, null, 1, null);
            throw new IppExchangeException(request2, null, $this$httpPostRequest_u24lambda_u2d5.getStatus(), it, null, 16, null);
        }
        return response;
    }

    @NotNull
    public final IppResponse decodeIppResponse(@NotNull IppRequest request2, @NotNull Http.Response httpResponse) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        IppResponse ippResponse = new IppResponse();
        boolean bl = false;
        boolean bl2 = false;
        IppResponse $this$decodeIppResponse_u24lambda_u2d8 = ippResponse;
        boolean bl3 = false;
        try {
            InputStream inputStream = httpResponse.getContentStream();
            Intrinsics.checkNotNull((Object)inputStream);
            $this$decodeIppResponse_u24lambda_u2d8.read(inputStream);
        }
        catch (Exception exception) {
            IppExchangeException ippExchangeException = new IppExchangeException(request2, $this$decodeIppResponse_u24lambda_u2d8, httpResponse.getStatus(), "failed to decode ipp response", exception);
            boolean bl4 = false;
            boolean bl5 = false;
            IppExchangeException $this$decodeIppResponse_u24lambda_u2d8_u24lambda_u2d6 = ippExchangeException;
            boolean bl6 = false;
            $this$decodeIppResponse_u24lambda_u2d8_u24lambda_u2d6.saveMessages("decoding_ipp_response_" + request2.getRequestId() + "_failed");
            throw (Throwable)ippExchangeException;
        }
        if ($this$decodeIppResponse_u24lambda_u2d8.getStatus() == IppStatus.ClientErrorBadRequest) {
            request2.logDetails("BAD-REQUEST: ");
        }
        if ($this$decodeIppResponse_u24lambda_u2d8.getStatus() != IppStatus.SuccessfulOk) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>($this$decodeIppResponse_u24lambda_u2d8){
                final /* synthetic */ IppResponse $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"status: ", (Object)((Object)this.$this_apply.getStatus()));
                }
            }, 1, null);
        }
        if ($this$decodeIppResponse_u24lambda_u2d8.hasStatusMessage()) {
            Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$decodeIppResponse_u24lambda_u2d8){
                final /* synthetic */ IppResponse $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"status-message: ", (Object)this.$this_apply.getStatusMessage());
                }
            }, 1, null);
        }
        if ($this$decodeIppResponse_u24lambda_u2d8.containsGroup(IppTag.Unsupported)) {
            Collection<IppAttribute<?>> exception = $this$decodeIppResponse_u24lambda_u2d8.getUnsupportedGroup().values();
            Intrinsics.checkNotNullExpressionValue(exception, (String)"unsupportedGroup.values");
            Iterable $this$forEach$iv = exception;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IppAttribute it = (IppAttribute)element$iv;
                boolean bl7 = false;
                Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(it){
                    final /* synthetic */ IppAttribute<?> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)"unsupported: ", this.$it);
                    }
                }, 1, null);
            }
        }
        return ippResponse;
    }

    private static final File exchange$file(File messageSubDirectory, IppRequest $request, String suffix) {
        return new File(messageSubDirectory, "" + $request.getRequestId() + '-' + (Object)((Object)$request.getOperation()) + '.' + suffix);
    }

    public IppClient() {
        this(null, null, 3, null);
    }

    static {
        String string = "IPP-Client: Version: 2.3, Build: 20220627, MIT License, (c) 2020-2022 Gerhard Muth";
        boolean bl = false;
        System.out.println((Object)string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/gmuth/ipp/client/IppClient$Companion;", "", "()V", "APPLICATION_IPP", "", "build", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "version", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

