/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppDocument;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppString;
import de.gmuth.log.Logging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001d\u001a\u00020\fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020#J\b\u0010%\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lde/gmuth/ipp/client/IppDocument;", "", "job", "Lde/gmuth/ipp/client/IppJob;", "cupsGetDocumentResponse", "Lde/gmuth/ipp/core/IppResponse;", "(Lde/gmuth/ipp/client/IppJob;Lde/gmuth/ipp/core/IppResponse;)V", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "format", "", "getFormat", "()Ljava/lang/String;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "getJob", "()Lde/gmuth/ipp/client/IppJob;", "name", "Lde/gmuth/ipp/core/IppString;", "getName", "()Lde/gmuth/ipp/core/IppString;", "number", "", "getNumber", "()I", "filename", "hasName", "", "readBytes", "", "save", "Ljava/io/File;", "file", "toString", "Companion", "ipp-client"})
public final class IppDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppJob job;
    @NotNull
    private final IppAttributesGroup attributes;
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);

    public IppDocument(@NotNull IppJob job, @NotNull IppResponse cupsGetDocumentResponse) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)cupsGetDocumentResponse, (String)"cupsGetDocumentResponse");
        this.job = job;
        this.attributes = cupsGetDocumentResponse.getJobGroup();
        InputStream inputStream = cupsGetDocumentResponse.getDocumentInputStream();
        Intrinsics.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
    }

    @NotNull
    public final IppJob getJob() {
        return this.job;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    public final int getNumber() {
        return ((Number)this.attributes.getValue("document-number")).intValue();
    }

    @NotNull
    public final String getFormat() {
        return (String)this.attributes.getValue("document-format");
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("document-name");
    }

    public final boolean hasName() {
        Map map = this.attributes;
        String string = "document-name";
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        return map2.containsKey(string);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("document #" + this.getNumber() + " (" + this.getFormat() + ')');
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder;
        boolean bl3 = false;
        if (this.hasName()) {
            $this$toString_u24lambda_u2d0.append(" '" + this.getName() + '\'');
        }
        String string = $this$toString_u24lambda_u2d0.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"document \u2026\n        toString()\n    }");
        return string;
    }

    @NotNull
    public final byte[] readBytes() {
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)this.inputStream);
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(it, this){
            final /* synthetic */ byte[] $it;
            final /* synthetic */ IppDocument this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "read " + this.$it.length + " bytes of " + this.this$0;
            }
        }, 1, null);
        return byArray;
    }

    @NotNull
    public final String filename() {
        String suffix = Companion.getMimeTypeSuffix(this.getFormat());
        return this.hasName() ? this.getName().getText() + '.' + suffix : (this.job.getAttributes().containsKey((Object)"document-name-supplied") ? this.job.getDocumentNameSupplied().getText() : "job-" + this.job.getId() + "-doc-" + this.getNumber() + '.' + suffix);
    }

    @NotNull
    public final File save(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file;
        boolean bl = false;
        ByteStreamsKt.copyTo$default((InputStream)this.inputStream, (OutputStream)new FileOutputStream(file2), (int)0, (int)2, null);
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(file, this){
            final /* synthetic */ File $file;
            final /* synthetic */ IppDocument this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "saved " + this.$file.length() + " bytes of " + this.this$0 + " to file " + this.$file.getPath();
            }
        }, 1, null);
        return file;
    }

    public static /* synthetic */ File save$default(IppDocument ippDocument, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File(ippDocument.filename());
        }
        return ippDocument.save(file);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lde/gmuth/ipp/client/IppDocument$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "getMimeTypeSuffix", "", "mimeType", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        @NotNull
        public final String getMimeTypeSuffix(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            String string = mimeType;
            return Intrinsics.areEqual((Object)string, (Object)"application/postscript") ? "ps" : (Intrinsics.areEqual((Object)string, (Object)"application/pdf") ? "pdf" : "bin");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

