/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppDocument;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppJobState;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppStringKt;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.log.Logging;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 e2\u00020\u0001:\u0001eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u00105\u001a\u0002062\n\b\u0002\u00107\u001a\u0004\u0018\u00010(J\u0018\u00108\u001a\u00020,2\u0010\b\u0002\u00109\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'J\u0010\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\u0011J,\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010(2\b\u0010D\u001a\u0004\u0018\u00010(H\u0004J\u000e\u0010E\u001a\u0002062\u0006\u0010F\u001a\u00020>J\u001f\u0010G\u001a\u0002062\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0I\"\u00020(\u00a2\u0006\u0002\u0010JJ\u001a\u0010G\u001a\u0002062\u0010\b\u0002\u0010K\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0007J\u0006\u0010L\u001a\u00020BJ\u0006\u0010M\u001a\u000206J \u0010N\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0010\b\u0002\u0010K\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'J\u0006\u0010O\u001a\u00020BJ\u0006\u0010P\u001a\u00020BJ\u0006\u0010Q\u001a\u00020BJ\u0006\u0010R\u001a\u00020BJ\u0006\u0010S\u001a\u00020BJ\u0006\u0010T\u001a\u00020BJ\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u000206J\u0006\u0010X\u001a\u00020BJ\u0006\u0010Y\u001a\u000206J2\u0010Z\u001a\u00020V2\u0006\u0010[\u001a\u00020\\2\b\b\u0002\u0010A\u001a\u00020B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010(H\u0007J2\u0010]\u001a\u00020V2\u0006\u0010^\u001a\u0002022\b\b\u0002\u0010A\u001a\u00020B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010(H\u0007J\b\u0010_\u001a\u00020(H\u0016J\u0010\u0010`\u001a\u00020V2\b\b\u0002\u0010a\u001a\u00020(J\u0012\u0010b\u001a\u00020V2\b\b\u0002\u0010c\u001a\u00020dH\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\u001e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006f"}, d2={"Lde/gmuth/ipp/client/IppJob;", "", "printer", "Lde/gmuth/ipp/client/IppPrinter;", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "subscriptionAttributes", "(Lde/gmuth/ipp/client/IppPrinter;Lde/gmuth/ipp/core/IppAttributesGroup;Lde/gmuth/ipp/core/IppAttributesGroup;)V", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "setAttributes", "(Lde/gmuth/ipp/core/IppAttributesGroup;)V", "documentNameSupplied", "Lde/gmuth/ipp/core/IppString;", "getDocumentNameSupplied", "()Lde/gmuth/ipp/core/IppString;", "id", "", "getId", "()I", "impressionsCompleted", "getImpressionsCompleted", "kOctets", "getKOctets", "mediaSheetsCompleted", "getMediaSheetsCompleted", "name", "getName", "numberOfDocuments", "getNumberOfDocuments", "originatingUserName", "getOriginatingUserName", "getPrinter", "()Lde/gmuth/ipp/client/IppPrinter;", "state", "Lde/gmuth/ipp/client/IppJobState;", "getState", "()Lde/gmuth/ipp/client/IppJobState;", "stateReasons", "", "", "getStateReasons", "()Ljava/util/List;", "subscription", "Lde/gmuth/ipp/client/IppSubscription;", "getSubscription", "()Lde/gmuth/ipp/client/IppSubscription;", "setSubscription", "(Lde/gmuth/ipp/client/IppSubscription;)V", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "cancel", "Lde/gmuth/ipp/core/IppResponse;", "messageForOperator", "createJobSubscription", "notifyEvents", "cupsGetDocument", "Lde/gmuth/ipp/client/IppDocument;", "documentNumber", "documentRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "Lde/gmuth/ipp/core/IppOperation;", "lastDocument", "", "documentName", "documentNaturalLanguage", "exchange", "request", "getJobAttributes", "requestedAttribute", "", "([Ljava/lang/String;)Lde/gmuth/ipp/core/IppResponse;", "requestedAttributes", "hasStateReasons", "hold", "ippRequest", "isCanceled", "isPending", "isProcessing", "isProcessingStopped", "isProcessingToStopPoint", "isTerminated", "logDetails", "", "release", "resourcesAreNotReady", "restart", "sendDocument", "inputStream", "Ljava/io/InputStream;", "sendUri", "documentUri", "toString", "updateAttributes", "jobAttributeGroupName", "waitForTermination", "delayMillis", "", "Companion", "ipp-client"})
public final class IppJob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppPrinter printer;
    @NotNull
    private IppAttributesGroup attributes;
    @Nullable
    private IppSubscription subscription;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);
    private static long defaultDelayMillis = 3000L;

    /*
     * WARNING - void declaration
     */
    public IppJob(@NotNull IppPrinter printer, @NotNull IppAttributesGroup attributes, @Nullable IppAttributesGroup subscriptionAttributes) {
        IppSubscription ippSubscription;
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.printer = printer;
        this.attributes = attributes;
        IppJob ippJob = this;
        IppAttributesGroup ippAttributesGroup = subscriptionAttributes;
        if (ippAttributesGroup == null) {
            ippSubscription = null;
        } else {
            void it;
            IppAttributesGroup ippAttributesGroup2 = ippAttributesGroup;
            boolean bl = false;
            boolean bl2 = false;
            IppAttributesGroup ippAttributesGroup3 = ippAttributesGroup2;
            IppJob ippJob2 = ippJob;
            boolean bl3 = false;
            IppSubscription ippSubscription2 = new IppSubscription(this.getPrinter(), (IppAttributesGroup)it, false, 4, null);
            ippJob = ippJob2;
            ippSubscription = ippSubscription2;
        }
        ippJob.subscription = ippSubscription;
    }

    public /* synthetic */ IppJob(IppPrinter ippPrinter, IppAttributesGroup ippAttributesGroup, IppAttributesGroup ippAttributesGroup2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ippAttributesGroup2 = null;
        }
        this(ippPrinter, ippAttributesGroup, ippAttributesGroup2);
    }

    @NotNull
    public final IppPrinter getPrinter() {
        return this.printer;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@NotNull IppAttributesGroup ippAttributesGroup) {
        Intrinsics.checkNotNullParameter((Object)ippAttributesGroup, (String)"<set-?>");
        this.attributes = ippAttributesGroup;
    }

    @Nullable
    public final IppSubscription getSubscription() {
        return this.subscription;
    }

    public final void setSubscription(@Nullable IppSubscription ippSubscription) {
        this.subscription = ippSubscription;
    }

    public final int getId() {
        return ((Number)this.attributes.getValue("job-id")).intValue();
    }

    @NotNull
    public final URI getUri() {
        return (URI)this.attributes.getValue("job-uri");
    }

    @NotNull
    public final IppJobState getState() {
        return IppJobState.Companion.fromInt(((Number)this.attributes.getValue("job-state")).intValue());
    }

    @NotNull
    public final List<String> getStateReasons() {
        return (List)this.attributes.getValues("job-state-reasons");
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("job-name");
    }

    @NotNull
    public final IppString getOriginatingUserName() {
        return (IppString)this.attributes.getValue("job-originating-user-name");
    }

    public final int getImpressionsCompleted() {
        return ((Number)this.attributes.getValue("job-impressions-completed")).intValue();
    }

    public final int getMediaSheetsCompleted() {
        return ((Number)this.attributes.getValue("job-media-sheets-completed")).intValue();
    }

    public final int getKOctets() {
        return ((Number)this.attributes.getValue("job-k-octets")).intValue();
    }

    public final int getNumberOfDocuments() {
        return ((Number)this.attributes.getValue("number-of-documents")).intValue();
    }

    @NotNull
    public final IppString getDocumentNameSupplied() {
        return (IppString)this.attributes.getValue("document-name-supplied");
    }

    public final boolean hasStateReasons() {
        return this.attributes.containsKey((Object)"job-state-reasons");
    }

    public final boolean isPending() {
        return this.getState() == IppJobState.Pending;
    }

    public final boolean isCanceled() {
        return this.getState() == IppJobState.Canceled;
    }

    public final boolean isProcessing() {
        return this.getState() == IppJobState.Processing;
    }

    public final boolean isProcessingStopped() {
        return this.getState() == IppJobState.ProcessingStopped;
    }

    public final boolean isTerminated() {
        IppJobState[] ippJobStateArray = new IppJobState[]{IppJobState.Canceled, IppJobState.Aborted, IppJobState.Completed};
        return CollectionsKt.listOf((Object[])ippJobStateArray).contains((Object)this.getState());
    }

    public final boolean isProcessingToStopPoint() {
        return this.hasStateReasons() && this.getStateReasons().contains("processing-to-stop-point");
    }

    public final boolean resourcesAreNotReady() {
        return this.hasStateReasons() && this.getStateReasons().contains("resources-are-not-ready");
    }

    @JvmOverloads
    @NotNull
    public final IppResponse getJobAttributes(@Nullable List<String> requestedAttributes) {
        return this.exchange(this.ippRequest(IppOperation.GetJobAttributes, requestedAttributes));
    }

    public static /* synthetic */ IppResponse getJobAttributes$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return ippJob.getJobAttributes(list);
    }

    @NotNull
    public final IppResponse getJobAttributes(String ... requestedAttribute) {
        Intrinsics.checkNotNullParameter((Object)requestedAttribute, (String)"requestedAttribute");
        return this.getJobAttributes(ArraysKt.toList((Object[])requestedAttribute));
    }

    public final void updateAttributes(@NotNull String jobAttributeGroupName) {
        Intrinsics.checkNotNullParameter((Object)jobAttributeGroupName, (String)"jobAttributeGroupName");
        String[] stringArray = new String[]{jobAttributeGroupName};
        this.attributes = this.getJobAttributes(stringArray).getJobGroup();
    }

    public static /* synthetic */ void updateAttributes$default(IppJob ippJob, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "all";
        }
        ippJob.updateAttributes(string);
    }

    @JvmOverloads
    public final void waitForTermination(long delayMillis) {
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(this){
            final /* synthetic */ IppJob this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"wait for termination of job #", (Object)this.this$0.getId());
            }
        }, 1, null);
        Ref.ObjectRef lastPrinterString = new Ref.ObjectRef();
        lastPrinterString.element = "";
        Ref.ObjectRef lastJobString = new Ref.ObjectRef();
        lastJobString.element = this.toString();
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>((Ref.ObjectRef<String>)lastJobString){
            final /* synthetic */ Ref.ObjectRef<String> $lastJobString;
            {
                this.$lastJobString = $lastJobString;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$lastJobString.element;
            }
        }, 1, null);
        while (!this.isTerminated()) {
            boolean bl;
            CharSequence charSequence;
            block7: {
                block6: {
                    Thread.sleep(delayMillis);
                    IppJob.updateAttributes$default(this, null, 1, null);
                    if (!Intrinsics.areEqual((Object)this.toString(), (Object)lastJobString.element)) {
                        lastJobString.element = this.toString();
                        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>((Ref.ObjectRef<String>)lastJobString){
                            final /* synthetic */ Ref.ObjectRef<String> $lastJobString;
                            {
                                this.$lastJobString = $lastJobString;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return this.$lastJobString.element;
                            }
                        }, 1, null);
                    }
                    if (this.isProcessingStopped()) break block6;
                    charSequence = (CharSequence)lastPrinterString.element;
                    bl = false;
                    if (!(charSequence.length() > 0)) break block7;
                }
                this.printer.updatePrinterStateAttributes();
                if (!Intrinsics.areEqual((Object)this.printer.toString(), (Object)lastPrinterString.element)) {
                    lastPrinterString.element = this.printer.toString();
                    Logging.Logger.info$default(log, null, (Function0)new Function0<Object>((Ref.ObjectRef<String>)lastPrinterString){
                        final /* synthetic */ Ref.ObjectRef<String> $lastPrinterString;
                        {
                            this.$lastPrinterString = $lastPrinterString;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$lastPrinterString.element;
                        }
                    }, 1, null);
                }
            }
            if (!this.isProcessing()) continue;
            charSequence = (CharSequence)lastPrinterString.element;
            bl = false;
            if (!(charSequence.length() > 0)) continue;
            lastPrinterString.element = "";
        }
    }

    public static /* synthetic */ void waitForTermination$default(IppJob ippJob, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = defaultDelayMillis;
        }
        ippJob.waitForTermination(l);
    }

    @NotNull
    public final IppResponse hold() {
        IppResponse ippResponse = this.exchange(IppJob.ippRequest$default(this, IppOperation.HoldJob, null, 2, null));
        boolean bl = false;
        boolean bl2 = false;
        IppResponse it = ippResponse;
        boolean bl3 = false;
        IppJob.updateAttributes$default(this, null, 1, null);
        return ippResponse;
    }

    @NotNull
    public final IppResponse release() {
        IppResponse ippResponse = this.exchange(IppJob.ippRequest$default(this, IppOperation.ReleaseJob, null, 2, null));
        boolean bl = false;
        boolean bl2 = false;
        IppResponse it = ippResponse;
        boolean bl3 = false;
        IppJob.updateAttributes$default(this, null, 1, null);
        return ippResponse;
    }

    @NotNull
    public final IppResponse restart() {
        IppResponse ippResponse = this.exchange(IppJob.ippRequest$default(this, IppOperation.RestartJob, null, 2, null));
        boolean bl = false;
        boolean bl2 = false;
        IppResponse it = ippResponse;
        boolean bl3 = false;
        IppJob.updateAttributes$default(this, null, 1, null);
        return ippResponse;
    }

    @NotNull
    public final IppResponse cancel(@Nullable String messageForOperator) {
        if (this.isCanceled()) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ IppJob this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "job #" + this.this$0.getId() + " is already 'canceled'";
                }
            }, 1, null);
        }
        if (this.isProcessingToStopPoint()) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ IppJob this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "job #" + this.this$0.getId() + " is already 'processing-to-stop-point'";
                }
            }, 1, null);
        }
        IppMessage ippMessage = IppJob.ippRequest$default(this, IppOperation.CancelJob, null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$cancel_u24lambda_u2d5 = ippMessage;
        boolean bl3 = false;
        String string = messageForOperator;
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            Object[] objectArray = new Object[]{IppStringKt.toIppString$default(it, null, 1, null)};
            $this$cancel_u24lambda_u2d5.getOperationGroup().attribute("message", IppTag.TextWithoutLanguage, objectArray);
        }
        IppRequest request2 = ippMessage;
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(this){
            final /* synthetic */ IppJob this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"cancel job#", (Object)this.this$0.getId());
            }
        }, 1, null);
        ippMessage = this.exchange(request2);
        bl = false;
        bl2 = false;
        IppMessage it = ippMessage;
        boolean bl7 = false;
        IppJob.updateAttributes$default(this, null, 1, null);
        return ippMessage;
    }

    public static /* synthetic */ IppResponse cancel$default(IppJob ippJob, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ippJob.cancel(string);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppRequest ippRequest = this.documentRequest(IppOperation.SendDocument, lastDocument, documentName, documentNaturalLanguage);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$sendDocument_u24lambda_u2d7 = ippRequest;
        boolean bl3 = false;
        $this$sendDocument_u24lambda_u2d7.setDocumentInputStream(inputStream);
        IppRequest request2 = ippRequest;
        this.attributes = this.exchange(request2).getJobGroup();
    }

    public static /* synthetic */ void sendDocument$default(IppJob ippJob, InputStream inputStream, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        ippJob.sendDocument(inputStream, bl, string, string2);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppRequest ippRequest = this.documentRequest(IppOperation.SendURI, lastDocument, documentName, documentNaturalLanguage);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$sendUri_u24lambda_u2d8 = ippRequest;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{documentUri};
        $this$sendUri_u24lambda_u2d8.getOperationGroup().attribute("document-uri", IppTag.Uri, objectArray);
        IppRequest request2 = ippRequest;
        this.attributes = this.exchange(request2).getJobGroup();
    }

    public static /* synthetic */ void sendUri$default(IppJob ippJob, URI uRI, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        ippJob.sendUri(uRI, bl, string, string2);
    }

    @NotNull
    protected final IppRequest documentRequest(@NotNull IppOperation operation, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Object[] objectArray;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        IppRequest ippRequest = IppJob.ippRequest$default(this, operation, null, 2, null);
        boolean bl3 = false;
        boolean bl4 = false;
        IppRequest $this$documentRequest_u24lambda_u2d12 = ippRequest;
        boolean bl5 = false;
        IppAttributesGroup ippAttributesGroup = $this$documentRequest_u24lambda_u2d12.getOperationGroup();
        boolean bl6 = false;
        boolean bl7 = false;
        IppAttributesGroup $this$documentRequest_u24lambda_u2d12_u24lambda_u2d11 = ippAttributesGroup;
        boolean bl8 = false;
        Object object2 = new Object[]{lastDocument};
        $this$documentRequest_u24lambda_u2d12_u24lambda_u2d11.attribute("last-document", IppTag.Boolean, object2);
        object2 = documentName;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl9 = false;
            objectArray = new Object[]{IppStringKt.toIppString$default((String)it, null, 1, null)};
            $this$documentRequest_u24lambda_u2d12_u24lambda_u2d11.attribute("document-name", IppTag.NameWithoutLanguage, objectArray);
        }
        object2 = documentNaturalLanguage;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl10 = false;
            objectArray = new Object[]{it};
            $this$documentRequest_u24lambda_u2d12_u24lambda_u2d11.attribute("document-natural-language", IppTag.NaturalLanguage, objectArray);
        }
        return ippRequest;
    }

    @NotNull
    public final IppSubscription createJobSubscription(@Nullable List<String> notifyEvents) {
        IppRequest ippRequest = IppJob.ippRequest$default(this, IppOperation.CreateJobSubscriptions, null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$createJobSubscription_u24lambda_u2d13 = ippRequest;
        boolean bl3 = false;
        IppPrinter.createSubscriptionGroup$default(this.getPrinter(), $this$createJobSubscription_u24lambda_u2d13, notifyEvents, null, this.getId(), 4, null);
        IppRequest request2 = ippRequest;
        IppAttributesGroup subscriptionAttributes = this.exchange(request2).getSingleAttributesGroup(IppTag.Subscription);
        IppSubscription ippSubscription = new IppSubscription(this.printer, subscriptionAttributes, false, 4, null);
        bl2 = false;
        boolean bl4 = false;
        IppSubscription $this$createJobSubscription_u24lambda_u2d14 = ippSubscription;
        boolean bl5 = false;
        this.setSubscription($this$createJobSubscription_u24lambda_u2d14);
        if (notifyEvents != null && !$this$createJobSubscription_u24lambda_u2d14.getEvents().containsAll((Collection)notifyEvents)) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(notifyEvents, $this$createJobSubscription_u24lambda_u2d14){
                final /* synthetic */ List<String> $notifyEvents;
                final /* synthetic */ IppSubscription $this_apply;
                {
                    this.$notifyEvents = $notifyEvents;
                    this.$this_apply = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "server ignored some notifyEvents " + this.$notifyEvents + ", subscribed events: " + this.$this_apply.getEvents();
                }
            }, 1, null);
        }
        return ippSubscription;
    }

    public static /* synthetic */ IppSubscription createJobSubscription$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return ippJob.createJobSubscription(list);
    }

    @NotNull
    public final IppDocument cupsGetDocument(int documentNumber) {
        if (!this.printer.isCups()) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ IppJob this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"printer is not CUPS: ", (Object)this.this$0.getPrinter().getPrinterUri());
                }
            }, 1, null);
        }
        if (this.attributes.containsKey((Object)"number-of-documents") && documentNumber > this.getNumberOfDocuments()) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ IppJob this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "job has only " + this.this$0.getNumberOfDocuments() + " document(s)";
                }
            }, 1, null);
        }
        IppRequest ippRequest = IppJob.ippRequest$default(this, IppOperation.CupsGetDocument, null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$cupsGetDocument_u24lambda_u2d15 = ippRequest;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{documentNumber};
        $this$cupsGetDocument_u24lambda_u2d15.getOperationGroup().attribute("document-number", IppTag.Integer, objectArray);
        IppRequest request2 = ippRequest;
        return new IppDocument(this, this.exchange(request2));
    }

    public static /* synthetic */ IppDocument cupsGetDocument$default(IppJob ippJob, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return ippJob.cupsGetDocument(n);
    }

    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @Nullable List<String> requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return this.printer.ippRequest(operation, this.getId(), requestedAttributes);
    }

    public static /* synthetic */ IppRequest ippRequest$default(IppJob ippJob, IppOperation ippOperation, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return ippJob.ippRequest(ippOperation, list);
    }

    @NotNull
    public final IppResponse exchange(@NotNull IppRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.printer.exchange(request2);
    }

    @NotNull
    public String toString() {
        IppAttributesGroup ippAttributesGroup = this.attributes;
        boolean bl = false;
        boolean bl2 = false;
        IppAttributesGroup $this$toString_u24lambda_u2d17 = ippAttributesGroup;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl4 = false;
        boolean bl5 = false;
        StringBuffer $this$toString_u24lambda_u2d17_u24lambda_u2d16 = stringBuffer;
        boolean bl6 = false;
        $this$toString_u24lambda_u2d17_u24lambda_u2d16.append("Job #" + this.getId() + ':');
        if ($this$toString_u24lambda_u2d17.containsKey((Object)"job-state")) {
            $this$toString_u24lambda_u2d17_u24lambda_u2d16.append(Intrinsics.stringPlus((String)" state=", (Object)((Object)this.getState())));
        }
        if (this.hasStateReasons()) {
            $this$toString_u24lambda_u2d17_u24lambda_u2d16.append(" (reasons=" + CollectionsKt.joinToString$default((Iterable)this.getStateReasons(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
        }
        if ($this$toString_u24lambda_u2d17.containsKey((Object)"job-name")) {
            $this$toString_u24lambda_u2d17_u24lambda_u2d16.append(Intrinsics.stringPlus((String)", name=", (Object)this.getName()));
        }
        if ($this$toString_u24lambda_u2d17.containsKey((Object)"job-originating-user-name")) {
            $this$toString_u24lambda_u2d17_u24lambda_u2d16.append(Intrinsics.stringPlus((String)", originating-user-name=", (Object)this.getOriginatingUserName()));
        }
        if ($this$toString_u24lambda_u2d17.containsKey((Object)"job-impressions-completed")) {
            $this$toString_u24lambda_u2d17_u24lambda_u2d16.append(Intrinsics.stringPlus((String)", impressions-completed=", (Object)this.getImpressionsCompleted()));
        }
        String string = $this$toString_u24lambda_u2d17_u24lambda_u2d16.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
        String string2 = string;
        return string2;
    }

    public final void logDetails() {
        IppAttributesGroup.logDetails$default(this.attributes, null, Intrinsics.stringPlus((String)"JOB-", (Object)this.getId()), 1, null);
    }

    @JvmOverloads
    @NotNull
    public final IppResponse getJobAttributes() {
        return IppJob.getJobAttributes$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void waitForTermination() {
        IppJob.waitForTermination$default(this, 0L, 1, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, lastDocument, documentName, null, 8, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, lastDocument, null, null, 12, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, false, null, null, 14, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, lastDocument, documentName, null, 8, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, lastDocument, null, null, 12, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, false, null, null, 14, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lde/gmuth/ipp/client/IppJob$Companion;", "", "()V", "defaultDelayMillis", "", "getDefaultDelayMillis", "()J", "setDefaultDelayMillis", "(J)V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public final long getDefaultDelayMillis() {
            return defaultDelayMillis;
        }

        public final void setDefaultDelayMillis(long l) {
            defaultDelayMillis = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

