/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.http.Http;
import de.gmuth.ipp.client.CupsMarker;
import de.gmuth.ipp.client.CupsPrinterType;
import de.gmuth.ipp.client.IppClient;
import de.gmuth.ipp.client.IppCommunicationChannel;
import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppPrinterState;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.client.IppWhichJobs;
import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import de.gmuth.log.Logging;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0015\b\u0016\u0018\u0000 \u00ad\u00012\u00020\u0001:\u0002\u00ad\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB5\u0012\u0006\u0010\u0007\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020>2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0004J\u0016\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u0001J\u001f\u0010Y\u001a\u00020Z2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020T0[\"\u00020T\u00a2\u0006\u0002\u0010\\J)\u0010]\u001a\u00020^2\n\b\u0002\u0010_\u001a\u0004\u0018\u00010`2\u0010\b\u0002\u0010a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001b\u00a2\u0006\u0002\u0010bJ=\u0010c\u001a\u00020\u00032\u0006\u0010d\u001a\u00020P2\u0010\b\u0002\u0010a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001b2\n\b\u0002\u0010_\u001a\u0004\u0018\u00010`2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010`\u00a2\u0006\u0002\u0010fJ\u000e\u0010g\u001a\u00020h2\u0006\u0010d\u001a\u00020PJ\u000e\u0010i\u001a\u00020Z2\u0006\u0010d\u001a\u00020PJ\u0010\u0010j\u001a\u00020V2\b\b\u0002\u0010k\u001a\u00020\bJ\u0006\u0010l\u001a\u00020hJ\u000e\u0010m\u001a\u00020Z2\u0006\u0010n\u001a\u00020`JG\u0010o\u001a\b\u0012\u0004\u0012\u00020Z0\u001b2\n\b\u0002\u0010p\u001a\u0004\u0018\u00010q2\n\b\u0002\u0010r\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010s\u001a\u0004\u0018\u00010`2\u000e\b\u0002\u0010t\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0007\u00a2\u0006\u0002\u0010uJ\u001f\u0010v\u001a\u00020h2\u0012\u0010t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0[\"\u00020\b\u00a2\u0006\u0002\u0010wJ\u0018\u0010v\u001a\u00020h2\u0010\b\u0002\u0010t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bJ\u000e\u0010x\u001a\u00020^2\u0006\u0010y\u001a\u00020`JG\u0010z\u001a\b\u0012\u0004\u0012\u00020^0\u001b2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010`2\n\b\u0002\u0010{\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010s\u001a\u0004\u0018\u00010`2\u0010\b\u0002\u0010t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001b\u00a2\u0006\u0002\u0010|J\u000e\u0010}\u001a\u00020\u00172\u0006\u0010~\u001a\u00020\u007fJ!\u0010\u0080\u0001\u001a\u00020h2\u0013\u0010\u0081\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0[\"\u00020\b\u00a2\u0006\u0002\u0010wJ\u0016\u0010\u0080\u0001\u001a\u00020h2\r\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u001bJ3\u0010\u0082\u0001\u001a\u00020P2\u0006\u0010Q\u001a\u00020>2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010`2\u0010\b\u0002\u0010t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001b\u00a2\u0006\u0003\u0010\u0083\u0001J\u001f\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u00172\u0006\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u0001\u00a2\u0006\u0003\u0010\u0085\u0001J\u0007\u0010\u0086\u0001\u001a\u00020\u0017J\u0007\u0010\u0087\u0001\u001a\u00020\u0017J\u0007\u0010\u0088\u0001\u001a\u00020\u0017J\u0007\u0010\u0089\u0001\u001a\u00020\u0017J\u0007\u0010\u008a\u0001\u001a\u00020\u0017J\u0007\u0010\u008b\u0001\u001a\u00020\u0017J\u0007\u0010\u008c\u0001\u001a\u00020VJ\u0011\u0010\u008d\u0001\u001a\u0002022\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001J\u0007\u0010\u0090\u0001\u001a\u00020hJ?\u0010\u0091\u0001\u001a\u00020Z2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020T0[\"\u00020T2\u0010\b\u0002\u0010a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0007\u00a2\u0006\u0003\u0010\u0094\u0001J?\u0010\u0091\u0001\u001a\u00020Z2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020T0[\"\u00020T2\u0010\b\u0002\u0010a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0007\u00a2\u0006\u0003\u0010\u0097\u0001J3\u0010\u0091\u0001\u001a\u00020Z2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\u0010\b\u0002\u0010a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0007J?\u0010\u0091\u0001\u001a\u00020Z2\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020T0[\"\u00020T2\u0010\b\u0002\u0010a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0007\u00a2\u0006\u0003\u0010\u009a\u0001J*\u0010\u009b\u0001\u001a\u00020Z2\u0007\u0010\u009c\u0001\u001a\u00020\r2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020T0[\"\u00020T\u00a2\u0006\u0003\u0010\u009d\u0001J\u0007\u0010\u009e\u0001\u001a\u00020hJ\u0007\u0010\u009f\u0001\u001a\u00020hJ\u0007\u0010\u00a0\u0001\u001a\u00020VJ\u0007\u0010\u00a1\u0001\u001a\u00020hJ\"\u0010\u00a2\u0001\u001a\u00020\u00172\u0013\u0010\u00a3\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020>0[\"\u00020>\u00a2\u0006\u0003\u0010\u00a4\u0001J\u0010\u0010\u00a5\u0001\u001a\u00020\u00172\u0007\u0010\u00a6\u0001\u001a\u00020\bJ\t\u0010\u00a7\u0001\u001a\u00020\bH\u0016J!\u0010\u00a8\u0001\u001a\u00020V2\u0012\u0010t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0[\"\u00020\b\u00a2\u0006\u0003\u0010\u00a9\u0001J\u0019\u0010\u00a8\u0001\u001a\u00020V2\u0010\b\u0002\u0010t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bJ\u0007\u0010\u00aa\u0001\u001a\u00020VJ!\u0010\u00ab\u0001\u001a\u00020h2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020T0[\"\u00020T\u00a2\u0006\u0003\u0010\u00ac\u0001R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001eR \u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0019R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0017\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001eR\u0011\u00104\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001eR\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020\b0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001eR\u0011\u0010;\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b<\u00100R\u0017\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u001eR\u0011\u0010@\u001a\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0011\u0010\u0007\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010!R\u0017\u0010E\u001a\b\u0012\u0004\u0012\u00020\b0\u001b8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001eR\u0011\u0010G\u001a\u00020H8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020\b0\u001b8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u001eR\u0017\u0010M\u001a\b\u0012\u0004\u0012\u00020\b0\u001b8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u001e\u00a8\u0006\u00ae\u0001"}, d2={"Lde/gmuth/ipp/client/IppPrinter;", "", "printerAttributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "ippClient", "Lde/gmuth/ipp/client/IppClient;", "(Lde/gmuth/ipp/core/IppAttributesGroup;Lde/gmuth/ipp/client/IppClient;)V", "printerUri", "", "(Ljava/lang/String;)V", "ippConfig", "Lde/gmuth/ipp/client/IppConfig;", "(Ljava/lang/String;Lde/gmuth/ipp/client/IppConfig;)V", "Ljava/net/URI;", "attributes", "httpConfig", "Lde/gmuth/http/Http$Config;", "(Ljava/net/URI;Lde/gmuth/ipp/core/IppAttributesGroup;Lde/gmuth/http/Http$Config;Lde/gmuth/ipp/client/IppConfig;Lde/gmuth/ipp/client/IppClient;)V", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "setAttributes", "(Lde/gmuth/ipp/core/IppAttributesGroup;)V", "colorSupported", "", "getColorSupported", "()Z", "communicationChannelsSupported", "", "Lde/gmuth/ipp/client/IppCommunicationChannel;", "getCommunicationChannelsSupported", "()Ljava/util/List;", "deviceUri", "getDeviceUri", "()Ljava/net/URI;", "documentFormatSupported", "getDocumentFormatSupported", "getJobsRequestedAttributes", "getGetJobsRequestedAttributes", "setGetJobsRequestedAttributes", "(Ljava/util/List;)V", "getIppClient", "()Lde/gmuth/ipp/client/IppClient;", "getIppConfig", "()Lde/gmuth/ipp/client/IppConfig;", "isAcceptingJobs", "makeAndModel", "Lde/gmuth/ipp/core/IppString;", "getMakeAndModel", "()Lde/gmuth/ipp/core/IppString;", "markers", "Lde/gmuth/ipp/client/CupsMarker;", "getMarkers", "mediaDefault", "getMediaDefault", "()Ljava/lang/String;", "mediaReady", "getMediaReady", "mediaSupported", "getMediaSupported", "name", "getName", "operationsSupported", "Lde/gmuth/ipp/core/IppOperation;", "getOperationsSupported", "printerType", "Lde/gmuth/ipp/client/CupsPrinterType;", "getPrinterType", "()Lde/gmuth/ipp/client/CupsPrinterType;", "getPrinterUri", "sidesSupported", "getSidesSupported", "state", "Lde/gmuth/ipp/client/IppPrinterState;", "getState", "()Lde/gmuth/ipp/client/IppPrinterState;", "stateReasons", "getStateReasons", "versionsSupported", "getVersionsSupported", "attributeBuildersRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "attributeBuilders", "", "Lde/gmuth/ipp/core/IppAttributeBuilder;", "checkIfValueIsSupported", "", "supportedAttributeName", "value", "createJob", "Lde/gmuth/ipp/client/IppJob;", "", "([Lde/gmuth/ipp/core/IppAttributeBuilder;)Lde/gmuth/ipp/client/IppJob;", "createPrinterSubscription", "Lde/gmuth/ipp/client/IppSubscription;", "notifyLeaseDuration", "", "notifyEvents", "(Ljava/lang/Integer;Ljava/util/List;)Lde/gmuth/ipp/client/IppSubscription;", "createSubscriptionGroup", "request", "notifyJobId", "(Lde/gmuth/ipp/core/IppRequest;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Integer;)Lde/gmuth/ipp/core/IppAttributesGroup;", "exchange", "Lde/gmuth/ipp/core/IppResponse;", "exchangeForIppJob", "fetchRawPrinterAttributes", "filename", "flash", "getJob", "jobId", "getJobs", "whichJobs", "Lde/gmuth/ipp/client/IppWhichJobs;", "myJobs", "limit", "requestedAttributes", "(Lde/gmuth/ipp/client/IppWhichJobs;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/util/List;)Ljava/util/List;", "getPrinterAttributes", "([Ljava/lang/String;)Lde/gmuth/ipp/core/IppResponse;", "getSubscription", "id", "getSubscriptions", "mySubscriptions", "(Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/util/List;)Ljava/util/List;", "hasCapability", "capability", "Lde/gmuth/ipp/client/CupsPrinterType$Capability;", "identify", "actions", "ippRequest", "(Lde/gmuth/ipp/core/IppOperation;Ljava/lang/Integer;Ljava/util/List;)Lde/gmuth/ipp/core/IppRequest;", "isAttributeValueSupported", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Boolean;", "isCups", "isDuplexSupported", "isIdle", "isMediaNeeded", "isProcessing", "isStopped", "logDetails", "marker", "color", "Lde/gmuth/ipp/client/CupsMarker$Color;", "pause", "printJob", "file", "Ljava/io/File;", "(Ljava/io/File;[Lde/gmuth/ipp/core/IppAttributeBuilder;Ljava/util/List;)Lde/gmuth/ipp/client/IppJob;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;[Lde/gmuth/ipp/core/IppAttributeBuilder;Ljava/util/List;)Lde/gmuth/ipp/client/IppJob;", "byteArray", "", "([B[Lde/gmuth/ipp/core/IppAttributeBuilder;Ljava/util/List;)Lde/gmuth/ipp/client/IppJob;", "printUri", "documentUri", "(Ljava/net/URI;[Lde/gmuth/ipp/core/IppAttributeBuilder;)Lde/gmuth/ipp/client/IppJob;", "purgeJobs", "resume", "savePrinterAttributes", "sound", "supportsOperations", "operations", "([Lde/gmuth/ipp/core/IppOperation;)Z", "supportsVersion", "version", "toString", "updateAttributes", "([Ljava/lang/String;)V", "updatePrinterStateAttributes", "validateJob", "([Lde/gmuth/ipp/core/IppAttributeBuilder;)Lde/gmuth/ipp/core/IppResponse;", "Companion", "ipp-client"})
public class IppPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI printerUri;
    @NotNull
    private IppAttributesGroup attributes;
    @NotNull
    private final IppClient ippClient;
    @NotNull
    private List<String> getJobsRequestedAttributes;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);
    @NotNull
    private static final List<String> printerStateAttributes;
    @NotNull
    private static final List<String> printerClassAttributes;

    public IppPrinter(@NotNull URI printerUri, @NotNull IppAttributesGroup attributes, @NotNull Http.Config httpConfig, @NotNull IppConfig ippConfig, @NotNull IppClient ippClient) {
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)httpConfig, (String)"httpConfig");
        Intrinsics.checkNotNullParameter((Object)ippConfig, (String)"ippConfig");
        Intrinsics.checkNotNullParameter((Object)ippClient, (String)"ippClient");
        this.printerUri = printerUri;
        this.attributes = attributes;
        this.ippClient = ippClient;
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"create IppPrinter for ", (Object)this.getPrinterUri());
            }
        }, 1, null);
        if (!this.ippClient.getConfig().getGetPrinterAttributesOnInit()) {
            Logging.Logger.warn$default(log, null, 2.INSTANCE, 1, null);
        } else if (this.attributes.size() == 0) {
            try {
                this.updateAttributes(this.ippClient.getConfig().getRequestedAttributesOnInit());
            }
            catch (IppExchangeException ippExchangeException) {
                Logging.Logger.logWithCauseMessages$default(log, ippExchangeException, null, 2, null);
                Logging.Logger.error$default(log, null, 3.INSTANCE, 1, null);
                IppResponse ippResponse = ippExchangeException.getResponse();
                if (ippResponse != null) {
                    IppResponse ippResponse2 = ippResponse;
                    boolean bl = false;
                    boolean bl2 = false;
                    IppResponse it = ippResponse2;
                    boolean bl3 = false;
                    Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(it){
                        final /* synthetic */ IppResponse $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$it.getPrinterGroup().size() + " attributes parsed";
                        }
                    }, 1, null);
                }
                this.fetchRawPrinterAttributes("getPrinterAttributesFailed.bin");
                throw ippExchangeException;
            }
        }
        Object[] objectArray = new String[]{"job-id", "job-uri", "job-printer-uri", "job-state", "job-name", "job-state-reasons", "job-originating-user-name"};
        this.getJobsRequestedAttributes = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ IppPrinter(URI uRI, IppAttributesGroup ippAttributesGroup, Http.Config config, IppConfig ippConfig, IppClient ippClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ippAttributesGroup = new IppAttributesGroup(IppTag.Printer);
        }
        if ((n & 4) != 0) {
            config = new Http.Config(0, null, null, null, false, null, null, false, 255, null);
        }
        if ((n & 8) != 0) {
            ippConfig = new IppConfig(null, null, null, null, false, null, 63, null);
        }
        if ((n & 0x10) != 0) {
            ippClient = new IppClient(ippConfig, (Http.Client)Http.Companion.getDefaultImplementation().getCreateClient().invoke((Object)config));
        }
        this(uRI, ippAttributesGroup, config, ippConfig, ippClient);
    }

    @NotNull
    public final URI getPrinterUri() {
        return this.printerUri;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@NotNull IppAttributesGroup ippAttributesGroup) {
        Intrinsics.checkNotNullParameter((Object)ippAttributesGroup, (String)"<set-?>");
        this.attributes = ippAttributesGroup;
    }

    @NotNull
    public final IppClient getIppClient() {
        return this.ippClient;
    }

    public IppPrinter(@NotNull IppAttributesGroup printerAttributes, @NotNull IppClient ippClient) {
        Intrinsics.checkNotNullParameter((Object)printerAttributes, (String)"printerAttributes");
        Intrinsics.checkNotNullParameter((Object)ippClient, (String)"ippClient");
        this((URI)CollectionsKt.first((List)((List)printerAttributes.getValues("printer-uri-supported"))), printerAttributes, null, null, ippClient, 12, null);
    }

    public /* synthetic */ IppPrinter(IppAttributesGroup ippAttributesGroup, IppClient ippClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ippClient = new IppClient(null, null, 3, null);
        }
        this(ippAttributesGroup, ippClient);
    }

    public IppPrinter(@NotNull String printerUri) {
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        URI uRI = URI.create(printerUri);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(printerUri)");
        this(uRI, null, null, null, null, 30, null);
    }

    public IppPrinter(@NotNull String printerUri, @NotNull IppConfig ippConfig) {
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        Intrinsics.checkNotNullParameter((Object)ippConfig, (String)"ippConfig");
        URI uRI = URI.create(printerUri);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(printerUri)");
        this(uRI, null, null, ippConfig, null, 22, null);
    }

    @NotNull
    public final IppConfig getIppConfig() {
        return this.ippClient.getConfig();
    }

    @NotNull
    public final List<String> getGetJobsRequestedAttributes() {
        return this.getJobsRequestedAttributes;
    }

    public final void setGetJobsRequestedAttributes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.getJobsRequestedAttributes = list;
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("printer-name");
    }

    @NotNull
    public final IppString getMakeAndModel() {
        return (IppString)this.attributes.getValue("printer-make-and-model");
    }

    public final boolean isAcceptingJobs() {
        return (Boolean)this.attributes.getValue("printer-is-accepting-jobs");
    }

    @NotNull
    public final IppPrinterState getState() {
        return IppPrinterState.Companion.fromInt(((Number)this.attributes.getValue("printer-state")).intValue());
    }

    @NotNull
    public final List<String> getStateReasons() {
        return (List)this.attributes.getValues("printer-state-reasons");
    }

    @NotNull
    public final List<String> getDocumentFormatSupported() {
        return (List)this.attributes.getValues("document-format-supported");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppOperation> getOperationsSupported() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.attributes.getValues("operations-supported");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IppOperation ippOperation = IppOperation.Companion.fromShort((short)it);
            collection.add(ippOperation);
        }
        return (List)destination$iv$iv;
    }

    public final boolean getColorSupported() {
        return (Boolean)this.attributes.getValue("color-supported");
    }

    @NotNull
    public final List<String> getSidesSupported() {
        return (List)this.attributes.getValues("sides-supported");
    }

    @NotNull
    public final List<String> getMediaSupported() {
        return (List)this.attributes.getValues("media-supported");
    }

    @NotNull
    public final List<String> getMediaReady() {
        return (List)this.attributes.getValues("media-ready");
    }

    @NotNull
    public final String getMediaDefault() {
        return (String)this.attributes.getValue("media-default");
    }

    @NotNull
    public final List<String> getVersionsSupported() {
        return (List)this.attributes.getValues("ipp-versions-supported");
    }

    @NotNull
    public final List<IppCommunicationChannel> getCommunicationChannelsSupported() {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$_get_communicationChannelsSupported__u24lambda_u2d3 = list;
        boolean bl4 = false;
        IppAttributesGroup ippAttributesGroup = this.getAttributes();
        boolean bl5 = false;
        boolean bl6 = false;
        IppAttributesGroup $this$_get_communicationChannelsSupported__u24lambda_u2d3_u24lambda_u2d2 = ippAttributesGroup;
        boolean bl7 = false;
        List printerUriSupportedList = (List)$this$_get_communicationChannelsSupported__u24lambda_u2d3_u24lambda_u2d2.getValues("printer-uri-supported");
        List uriSecuritySupportedList = (List)$this$_get_communicationChannelsSupported__u24lambda_u2d3_u24lambda_u2d2.getValues("uri-security-supported");
        List uriAuthenticationSupportedList = (List)$this$_get_communicationChannelsSupported__u24lambda_u2d3_u24lambda_u2d2.getValues("uri-authentication-supported");
        Iterator iterator = printerUriSupportedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            URI printerUriSupported = (URI)iterator.next();
            $this$_get_communicationChannelsSupported__u24lambda_u2d3.add(new IppCommunicationChannel(printerUriSupported, (String)uriSecuritySupportedList.get(index), (String)uriAuthenticationSupportedList.get(index)));
        }
        return list;
    }

    @NotNull
    public final URI getDeviceUri() {
        return (URI)this.attributes.getValue("device-uri");
    }

    @NotNull
    public final CupsPrinterType getPrinterType() {
        return new CupsPrinterType(((Number)this.attributes.getValue("printer-type")).intValue());
    }

    public final boolean hasCapability(@NotNull CupsPrinterType.Capability capability) {
        Intrinsics.checkNotNullParameter((Object)((Object)capability), (String)"capability");
        return this.getPrinterType().contains(capability);
    }

    @NotNull
    public final List<CupsMarker> getMarkers() {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$_get_markers__u24lambda_u2d5 = list;
        boolean bl4 = false;
        IppAttributesGroup ippAttributesGroup = this.getAttributes();
        boolean bl5 = false;
        boolean bl6 = false;
        IppAttributesGroup $this$_get_markers__u24lambda_u2d5_u24lambda_u2d4 = ippAttributesGroup;
        boolean bl7 = false;
        List levels = (List)$this$_get_markers__u24lambda_u2d5_u24lambda_u2d4.getValues("marker-levels");
        List lowLevels = (List)$this$_get_markers__u24lambda_u2d5_u24lambda_u2d4.getValues("marker-low-levels");
        List highLevels = (List)$this$_get_markers__u24lambda_u2d5_u24lambda_u2d4.getValues("marker-high-levels");
        List types = (List)$this$_get_markers__u24lambda_u2d5_u24lambda_u2d4.getValues("marker-types");
        List names = (List)$this$_get_markers__u24lambda_u2d5_u24lambda_u2d4.getValues("marker-names");
        List colors = (List)$this$_get_markers__u24lambda_u2d5_u24lambda_u2d4.getValues("marker-colors");
        Iterator iterator = types.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String type = (String)iterator.next();
            $this$_get_markers__u24lambda_u2d5.add(new CupsMarker(type, ((IppString)names.get(index)).getText(), ((Number)levels.get(index)).intValue(), ((Number)lowLevels.get(index)).intValue(), ((Number)highLevels.get(index)).intValue(), ((IppString)colors.get(index)).getText()));
        }
        return list;
    }

    @NotNull
    public final CupsMarker marker(@NotNull CupsMarker.Color color) {
        Intrinsics.checkNotNullParameter((Object)((Object)color), (String)"color");
        Iterable $this$single$iv = this.getMarkers();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            CupsMarker it = (CupsMarker)element$iv;
            boolean bl = false;
            if (!(it.getColor() == color)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    public final boolean isIdle() {
        return this.getState() == IppPrinterState.Idle;
    }

    public final boolean isStopped() {
        return this.getState() == IppPrinterState.Stopped;
    }

    public final boolean isProcessing() {
        return this.getState() == IppPrinterState.Processing;
    }

    public final boolean isMediaNeeded() {
        return this.getStateReasons().contains("media-needed");
    }

    public final boolean isDuplexSupported() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getSidesSupported();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"two-sided", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean supportsOperations(IppOperation ... operations) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        return this.getOperationsSupported().containsAll(ArraysKt.toList((Object[])operations));
    }

    public final boolean supportsVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.getVersionsSupported().contains(version);
    }

    public final boolean isCups() {
        return this.attributes.containsKey((Object)"cups-version");
    }

    @NotNull
    public final IppResponse identify(String ... actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        return this.identify(ArraysKt.toList((Object[])actions));
    }

    @NotNull
    public final IppResponse identify(@NotNull List<String> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.checkIfValueIsSupported("identify-actions-supported", actions);
        IppRequest ippRequest = IppPrinter.ippRequest$default(this, IppOperation.IdentifyPrinter, null, null, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$identify_u24lambda_u2d8 = ippRequest;
        boolean bl3 = false;
        $this$identify_u24lambda_u2d8.getOperationGroup().attribute("identify-actions", IppTag.Keyword, actions);
        IppRequest request2 = ippRequest;
        return this.exchange(request2);
    }

    @NotNull
    public final IppResponse flash() {
        String[] stringArray = new String[]{"flash"};
        return this.identify(stringArray);
    }

    @NotNull
    public final IppResponse sound() {
        String[] stringArray = new String[]{"sound"};
        return this.identify(stringArray);
    }

    @NotNull
    public final IppResponse pause() {
        return this.exchange(IppPrinter.ippRequest$default(this, IppOperation.PausePrinter, null, null, 6, null));
    }

    @NotNull
    public final IppResponse resume() {
        return this.exchange(IppPrinter.ippRequest$default(this, IppOperation.ResumePrinter, null, null, 6, null));
    }

    @NotNull
    public final IppResponse purgeJobs() {
        return this.exchange(IppPrinter.ippRequest$default(this, IppOperation.PurgeJobs, null, null, 6, null));
    }

    @NotNull
    public final IppResponse getPrinterAttributes(@Nullable List<String> requestedAttributes) {
        return this.exchange(IppPrinter.ippRequest$default(this, IppOperation.GetPrinterAttributes, null, requestedAttributes, 2, null));
    }

    public static /* synthetic */ IppResponse getPrinterAttributes$default(IppPrinter ippPrinter, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPrinterAttributes");
        }
        if ((n & 1) != 0) {
            list = null;
        }
        return ippPrinter.getPrinterAttributes(list);
    }

    @NotNull
    public final IppResponse getPrinterAttributes(String ... requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestedAttributes, (String)"requestedAttributes");
        return this.getPrinterAttributes(ArraysKt.toList((Object[])requestedAttributes));
    }

    public final void updateAttributes(@Nullable List<String> requestedAttributes) {
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(requestedAttributes){
            final /* synthetic */ List<String> $requestedAttributes;
            {
                this.$requestedAttributes = $requestedAttributes;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"update attributes: ", this.$requestedAttributes);
            }
        }, 1, null);
        IppResponse ippResponse = this.getPrinterAttributes(requestedAttributes);
        boolean bl = false;
        boolean bl2 = false;
        IppResponse $this$updateAttributes_u24lambda_u2d9 = ippResponse;
        boolean bl3 = false;
        if ($this$updateAttributes_u24lambda_u2d9.containsGroup(IppTag.Printer)) {
            this.getAttributes().put($this$updateAttributes_u24lambda_u2d9.getPrinterGroup());
        } else {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(requestedAttributes){
                final /* synthetic */ List<String> $requestedAttributes;
                {
                    this.$requestedAttributes = $requestedAttributes;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"no printerGroup in response for requested attributes: ", this.$requestedAttributes);
                }
            }, 1, null);
        }
    }

    public static /* synthetic */ void updateAttributes$default(IppPrinter ippPrinter, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateAttributes");
        }
        if ((n & 1) != 0) {
            list = null;
        }
        ippPrinter.updateAttributes(list);
    }

    public final void updateAttributes(String ... requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestedAttributes, (String)"requestedAttributes");
        this.updateAttributes(ArraysKt.toList((Object[])requestedAttributes));
    }

    public final void updatePrinterStateAttributes() {
        this.updateAttributes(printerStateAttributes);
    }

    @NotNull
    public final IppResponse validateJob(IppAttributeBuilder ... attributeBuilders) throws IppExchangeException {
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        IppRequest request2 = this.attributeBuildersRequest(IppOperation.ValidateJob, ArraysKt.toList((Object[])attributeBuilders));
        return this.exchange(request2);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, @NotNull Collection<? extends IppAttributeBuilder> attributeBuilders, @Nullable List<String> notifyEvents) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter(attributeBuilders, (String)"attributeBuilders");
        IppRequest ippRequest = this.attributeBuildersRequest(IppOperation.PrintJob, attributeBuilders);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$printJob_u24lambda_u2d11 = ippRequest;
        boolean bl3 = false;
        List<String> list = notifyEvents;
        if (list != null) {
            List<String> list2 = list;
            boolean bl4 = false;
            boolean bl5 = false;
            List<String> it = list2;
            boolean bl6 = false;
            IppPrinter.createSubscriptionGroup$default(this, $this$printJob_u24lambda_u2d11, notifyEvents, null, null, 12, null);
        }
        $this$printJob_u24lambda_u2d11.setDocumentInputStream(inputStream);
        IppRequest request2 = ippRequest;
        return this.exchangeForIppJob(request2);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, InputStream inputStream, Collection collection, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printJob");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(inputStream, collection, (List<String>)list);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, @NotNull IppAttributeBuilder[] attributeBuilders, @Nullable List<String> notifyEvents) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return this.printJob(inputStream, ArraysKt.toList((Object[])attributeBuilders), notifyEvents);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, InputStream inputStream, IppAttributeBuilder[] ippAttributeBuilderArray, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printJob");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(inputStream, ippAttributeBuilderArray, (List<String>)list);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull byte[] byteArray, @NotNull IppAttributeBuilder[] attributeBuilders, @Nullable List<String> notifyEvents) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return this.printJob((InputStream)new ByteArrayInputStream(byteArray), ArraysKt.toList((Object[])attributeBuilders), notifyEvents);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, byte[] byArray, IppAttributeBuilder[] ippAttributeBuilderArray, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printJob");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(byArray, ippAttributeBuilderArray, (List<String>)list);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull File file, @NotNull IppAttributeBuilder[] attributeBuilders, @Nullable List<String> notifyEvents) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return this.printJob((InputStream)new FileInputStream(file), ArraysKt.toList((Object[])attributeBuilders), notifyEvents);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, File file, IppAttributeBuilder[] ippAttributeBuilderArray, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printJob");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(file, ippAttributeBuilderArray, (List<String>)list);
    }

    @NotNull
    public final IppJob printUri(@NotNull URI documentUri, IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        IppRequest ippRequest = this.attributeBuildersRequest(IppOperation.PrintURI, ArraysKt.toList((Object[])attributeBuilders));
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$printUri_u24lambda_u2d12 = ippRequest;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{documentUri};
        $this$printUri_u24lambda_u2d12.getOperationGroup().attribute("document-uri", IppTag.Uri, objectArray);
        IppRequest request2 = ippRequest;
        return this.exchangeForIppJob(request2);
    }

    @NotNull
    public final IppJob createJob(IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        IppRequest request2 = this.attributeBuildersRequest(IppOperation.CreateJob, ArraysKt.toList((Object[])attributeBuilders));
        return this.exchangeForIppJob(request2);
    }

    @NotNull
    protected final IppRequest attributeBuildersRequest(@NotNull IppOperation operation, @NotNull Collection<? extends IppAttributeBuilder> attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter(attributeBuilders, (String)"attributeBuilders");
        IppRequest ippRequest = IppPrinter.ippRequest$default(this, operation, null, null, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$attributeBuildersRequest_u24lambda_u2d13 = ippRequest;
        boolean bl3 = false;
        for (IppAttributeBuilder ippAttributeBuilder : attributeBuilders) {
            IppTag groupTag;
            IppAttribute<?> attribute = ippAttributeBuilder.buildIppAttribute(this.getAttributes());
            this.checkIfValueIsSupported(Intrinsics.stringPlus((String)attribute.getName(), (Object)"-supported"), attribute.getValues());
            IppTag ippTag = IppRegistrationsSection2.INSTANCE.selectGroupForAttribute(attribute.getName());
            IppTag ippTag2 = groupTag = ippTag == null ? IppTag.Job : ippTag;
            if (!$this$attributeBuildersRequest_u24lambda_u2d13.containsGroup(groupTag)) {
                $this$attributeBuildersRequest_u24lambda_u2d13.createAttributesGroup(groupTag);
            }
            Logging.Logger.trace$default(log, null, (Function0)new Function0<Object>(groupTag, attribute){
                final /* synthetic */ IppTag $groupTag;
                final /* synthetic */ IppAttribute<?> $attribute;
                {
                    this.$groupTag = $groupTag;
                    this.$attribute = $attribute;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return (Object)((Object)this.$groupTag) + " put " + this.$attribute;
                }
            }, 1, null);
            IppAttributesGroup.put$default($this$attributeBuildersRequest_u24lambda_u2d13.getSingleAttributesGroup(groupTag), attribute, false, 2, null);
        }
        return ippRequest;
    }

    @NotNull
    public final IppJob getJob(int jobId) {
        IppRequest request2 = IppPrinter.ippRequest$default(this, IppOperation.GetJobAttributes, jobId, null, 4, null);
        return this.exchangeForIppJob(request2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<IppJob> getJobs(@Nullable IppWhichJobs whichJobs, @Nullable Boolean myJobs, @Nullable Integer limit, @NotNull List<String> requestedAttributes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter(requestedAttributes, (String)"requestedAttributes");
        Object object2 = IppPrinter.ippRequest$default(this, IppOperation.GetJobs, null, requestedAttributes, 2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        IppRequest $this$getJobs_u24lambda_u2d18 = object2;
        boolean bl4 = false;
        IppAttributesGroup ippAttributesGroup = $this$getJobs_u24lambda_u2d18.getOperationGroup();
        boolean bl5 = false;
        boolean bl6 = false;
        IppAttributesGroup $this$getJobs_u24lambda_u2d18_u24lambda_u2d17 = ippAttributesGroup;
        boolean bl7 = false;
        Object object3 = whichJobs;
        if (object3 != null && (object = object3.getKeyword()) != null) {
            String string = object;
            bl = false;
            boolean bl8 = false;
            String it2 = string;
            boolean bl9 = false;
            this.checkIfValueIsSupported("which-jobs-supported", it2);
            Object[] objectArray = new Object[]{it2};
            $this$getJobs_u24lambda_u2d18_u24lambda_u2d17.attribute("which-jobs", IppTag.Keyword, objectArray);
        }
        if ((object3 = myJobs) != null) {
            object = object3;
            boolean bl10 = false;
            bl = false;
            boolean bl8 = (Boolean)object;
            boolean bl11 = false;
            Object[] objectArray = new Object[]{bl8};
            $this$getJobs_u24lambda_u2d18_u24lambda_u2d17.attribute("my-jobs", IppTag.Boolean, objectArray);
        }
        object3 = limit;
        if (object3 != null) {
            object = object3;
            boolean bl12 = false;
            bl = false;
            int n = ((Number)object).intValue();
            boolean bl13 = false;
            Object[] objectArray = new Object[]{n};
            $this$getJobs_u24lambda_u2d18_u24lambda_u2d17.attribute("limit", IppTag.Integer, objectArray);
        }
        IppRequest request2 = object2;
        object2 = this.exchange(request2).getAttributesGroups(IppTag.Job);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            IppAttributesGroup ippAttributesGroup2 = (IppAttributesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl14 = false;
            IppJob ippJob = new IppJob(this, (IppAttributesGroup)it3, null, 4, null);
            collection.add(ippJob);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getJobs$default(IppPrinter ippPrinter, IppWhichJobs ippWhichJobs, Boolean bl, Integer n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getJobs");
        }
        if ((n2 & 1) != 0) {
            ippWhichJobs = null;
        }
        if ((n2 & 2) != 0) {
            bl = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            list = ippPrinter.getJobsRequestedAttributes;
        }
        return ippPrinter.getJobs(ippWhichJobs, bl, n, list);
    }

    @NotNull
    public final IppSubscription createPrinterSubscription(@Nullable Integer notifyLeaseDuration, @Nullable List<String> notifyEvents) {
        IppRequest ippRequest = IppPrinter.ippRequest$default(this, IppOperation.CreatePrinterSubscriptions, null, null, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest $this$createPrinterSubscription_u24lambda_u2d20 = ippRequest;
        boolean bl3 = false;
        IppPrinter.createSubscriptionGroup$default(this, $this$createPrinterSubscription_u24lambda_u2d20, notifyEvents, notifyLeaseDuration, null, 8, null);
        IppRequest request2 = ippRequest;
        IppAttributesGroup subscriptionAttributes = this.exchange(request2).getSingleAttributesGroup(IppTag.Subscription);
        return new IppSubscription(this, subscriptionAttributes, false, 4, null);
    }

    public static /* synthetic */ IppSubscription createPrinterSubscription$default(IppPrinter ippPrinter, Integer n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPrinterSubscription");
        }
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            list = CollectionsKt.listOf((Object)"all");
        }
        return ippPrinter.createPrinterSubscription(n, list);
    }

    @NotNull
    public final IppAttributesGroup createSubscriptionGroup(@NotNull IppRequest request2, @Nullable List<String> notifyEvents, @Nullable Integer notifyLeaseDuration, @Nullable Integer notifyJobId) {
        Object[] objectArray;
        int it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        IppAttributesGroup ippAttributesGroup = request2.createAttributesGroup(IppTag.Subscription);
        boolean bl3 = false;
        boolean bl4 = false;
        IppAttributesGroup $this$createSubscriptionGroup_u24lambda_u2d24 = ippAttributesGroup;
        boolean bl5 = false;
        Object object2 = new Object[]{"ippget"};
        $this$createSubscriptionGroup_u24lambda_u2d24.attribute("notify-pull-method", IppTag.Keyword, object2);
        object2 = notifyJobId;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = ((Number)object).intValue();
            boolean bl6 = false;
            objectArray = new Object[]{it};
            $this$createSubscriptionGroup_u24lambda_u2d24.attribute("notify-job-id", IppTag.Integer, objectArray);
        }
        object2 = notifyLeaseDuration;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = ((Number)object).intValue();
            boolean bl7 = false;
            objectArray = new Object[]{it};
            $this$createSubscriptionGroup_u24lambda_u2d24.attribute("notify-lease-duration", IppTag.Integer, objectArray);
        }
        object2 = notifyEvents;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            Object it2 = object;
            boolean bl8 = false;
            objectArray = (Collection)it2;
            boolean bl9 = false;
            if (!objectArray.isEmpty() && !Intrinsics.areEqual((Object)CollectionsKt.first((List)it2), (Object)"all")) {
                this.checkIfValueIsSupported("notify-events-supported", it2);
            }
            $this$createSubscriptionGroup_u24lambda_u2d24.attribute("notify-events", IppTag.Keyword, (List<? extends Object>)it2);
        }
        return ippAttributesGroup;
    }

    public static /* synthetic */ IppAttributesGroup createSubscriptionGroup$default(IppPrinter ippPrinter, IppRequest ippRequest, List list, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSubscriptionGroup");
        }
        if ((n3 & 2) != 0) {
            list = null;
        }
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return ippPrinter.createSubscriptionGroup(ippRequest, list, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppSubscription getSubscription(int id) {
        void $this$getSubscription_u24lambda_u2d25;
        IppRequest ippRequest = IppPrinter.ippRequest$default(this, IppOperation.GetSubscriptionAttributes, null, null, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        IppRequest ippRequest2 = ippRequest;
        IppPrinter ippPrinter = this;
        IppPrinter ippPrinter2 = this;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{id};
        $this$getSubscription_u24lambda_u2d25.getOperationGroup().attribute("notify-subscription-id", IppTag.Integer, objectArray);
        Unit unit = Unit.INSTANCE;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        boolean bl4 = false;
        IppAttributesGroup ippAttributesGroup = ippPrinter.exchange(ippRequest).getSingleAttributesGroup(IppTag.Subscription);
        IppPrinter ippPrinter3 = ippPrinter2;
        return new IppSubscription(ippPrinter3, ippAttributesGroup, bl4, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppSubscription> getSubscriptions(@Nullable Integer notifyJobId, @Nullable Boolean mySubscriptions, @Nullable Integer limit, @Nullable List<String> requestedAttributes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray;
        int it;
        boolean bl;
        boolean bl2;
        Integer n;
        Object object = IppPrinter.ippRequest$default(this, IppOperation.GetSubscriptions, null, requestedAttributes, 2, null);
        boolean bl3 = false;
        boolean bl4 = false;
        IppRequest $this$getSubscriptions_u24lambda_u2d30 = object;
        boolean bl5 = false;
        IppAttributesGroup ippAttributesGroup = $this$getSubscriptions_u24lambda_u2d30.getOperationGroup();
        boolean bl6 = false;
        boolean bl7 = false;
        IppAttributesGroup $this$getSubscriptions_u24lambda_u2d30_u24lambda_u2d29 = ippAttributesGroup;
        boolean bl8 = false;
        Constable constable = notifyJobId;
        if (constable != null) {
            n = constable;
            bl2 = false;
            bl = false;
            it = ((Number)n).intValue();
            boolean bl9 = false;
            objectArray = new Object[]{it};
            $this$getSubscriptions_u24lambda_u2d30_u24lambda_u2d29.attribute("notify-job-id", IppTag.Integer, objectArray);
        }
        constable = mySubscriptions;
        if (constable != null) {
            n = constable;
            bl2 = false;
            bl = false;
            it = ((Boolean)((Object)n)).booleanValue() ? 1 : 0;
            boolean bl10 = false;
            objectArray = new Object[]{it != 0};
            $this$getSubscriptions_u24lambda_u2d30_u24lambda_u2d29.attribute("my-subscriptions", IppTag.Boolean, objectArray);
        }
        constable = limit;
        if (constable != null) {
            n = constable;
            bl2 = false;
            bl = false;
            it = ((Number)n).intValue();
            boolean bl11 = false;
            objectArray = new Object[]{it};
            $this$getSubscriptions_u24lambda_u2d30_u24lambda_u2d29.attribute("limit", IppTag.Integer, objectArray);
        }
        IppRequest request2 = object;
        object = this.exchange(request2).getAttributesGroups(IppTag.Subscription);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IppAttributesGroup ippAttributesGroup2 = (IppAttributesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl12 = false;
            IppSubscription ippSubscription = new IppSubscription(this, (IppAttributesGroup)it2, false, 4, null);
            collection.add(ippSubscription);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getSubscriptions$default(IppPrinter ippPrinter, Integer n, Boolean bl, Integer n2, List list, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSubscriptions");
        }
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            bl = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            list = null;
        }
        return ippPrinter.getSubscriptions(n, bl, n2, list);
    }

    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @Nullable Integer jobId, @Nullable List<String> requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return this.ippClient.ippRequest(operation, this.printerUri, jobId, requestedAttributes);
    }

    public static /* synthetic */ IppRequest ippRequest$default(IppPrinter ippPrinter, IppOperation ippOperation, Integer n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ippRequest");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            list = null;
        }
        return ippPrinter.ippRequest(ippOperation, n, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppResponse exchange(@NotNull IppRequest request2) {
        void $this$exchange_u24lambda_u2d32;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        IppRequest ippRequest = request2;
        boolean bl = false;
        boolean bl2 = false;
        IppRequest ippRequest2 = ippRequest;
        IppClient ippClient = this.ippClient;
        boolean bl3 = false;
        String string = $this$exchange_u24lambda_u2d32.getVersion();
        Intrinsics.checkNotNull((Object)string);
        this.checkIfValueIsSupported("ipp-versions-supported", string);
        Short s = $this$exchange_u24lambda_u2d32.getCode();
        Intrinsics.checkNotNull((Object)s);
        this.checkIfValueIsSupported("operations-supported", s);
        this.checkIfValueIsSupported("charset-supported", $this$exchange_u24lambda_u2d32.getAttributesCharset());
        Unit unit = Unit.INSTANCE;
        return IppClient.exchange$default(ippClient, ippRequest, false, 2, null);
    }

    @NotNull
    public final IppJob exchangeForIppJob(@NotNull IppRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        IppResponse response = this.exchange(request2);
        if (request2.containsGroup(IppTag.Subscription) && !response.containsGroup(IppTag.Subscription)) {
            request2.logDetails("REQUEST: ");
            List events = (List)request2.getSingleAttributesGroup(IppTag.Subscription).getValues("notify-events");
            throw new IppException(Intrinsics.stringPlus((String)"printer/server did not create subscription for events: ", (Object)CollectionsKt.joinToString$default((Iterable)events, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), null, 2, null);
        }
        IppResponse ippResponse = response;
        boolean bl = false;
        boolean bl2 = false;
        IppResponse $this$exchangeForIppJob_u24lambda_u2d33 = ippResponse;
        boolean bl3 = false;
        IppAttributesGroup subscriptionsAttributes = $this$exchangeForIppJob_u24lambda_u2d33.containsGroup(IppTag.Subscription) ? $this$exchangeForIppJob_u24lambda_u2d33.getSingleAttributesGroup(IppTag.Subscription) : null;
        return new IppJob(this, response.getJobGroup(), subscriptionsAttributes);
    }

    @NotNull
    public String toString() {
        return "IppPrinter: name=" + this.getName() + ", makeAndModel=" + this.getMakeAndModel() + ", state=" + (Object)((Object)this.getState()) + ", stateReasons=" + this.getStateReasons();
    }

    public final void logDetails() {
        IppAttributesGroup.logDetails$default(this.attributes, null, "PRINTER-" + this.getName() + " (" + this.getMakeAndModel() + "), " + (Object)((Object)this.getState()) + ' ' + this.getStateReasons(), 1, null);
    }

    public final void checkIfValueIsSupported(@NotNull String supportedAttributeName, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)supportedAttributeName, (String)"supportedAttributeName");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.attributes.size() == 0) {
            return;
        }
        if (!StringsKt.endsWith$default((String)supportedAttributeName, (String)"-supported", (boolean)false, (int)2, null)) {
            throw new IppException("attribute name not ending with '-supported'", null, 2, null);
        }
        if (value2 instanceof Collection) {
            Iterator iterator = ((Collection)value2).iterator();
            while (iterator.hasNext()) {
                Object collectionValue;
                Object e = collectionValue = iterator.next();
                Intrinsics.checkNotNull(e);
                this.checkIfValueIsSupported(supportedAttributeName, e);
            }
        } else {
            this.isAttributeValueSupported(supportedAttributeName, value2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Boolean isAttributeValueSupported(@NotNull String supportedAttributeName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)supportedAttributeName, (String)"supportedAttributeName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        var5_3 = (IppAttribute)this.attributes.get((Object)supportedAttributeName);
        if (var5_3 == null) {
            return null;
        }
        supportedAttribute = var4_4 = var5_3;
        var5_3 = supportedAttribute.getTag();
        var6_6 = WhenMappings.$EnumSwitchMapping$0[var5_3.ordinal()];
        switch (var6_6) {
            case 1: {
                var7_7 /* !! */  = supportedAttribute.getValue();
                if (var7_7 /* !! */  == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                v0 = (boolean)((Boolean)var7_7 /* !! */ );
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                var7_7 /* !! */  = supportedAttributeName;
                if (Intrinsics.areEqual((Object)var7_7 /* !! */ , (Object)"media-col-supported")) {
                    var8_8 = (IppCollection)value;
                    var9_11 = 0;
                    var10_12 = 0;
                    $this$isAttributeValueSupported_u24lambda_u2d37 = var8_8;
                    $i$a$-with-IppPrinter$isAttributeValueSupported$attributeValueIsSupported$1 = false;
                    $this$filter$iv = $this$isAttributeValueSupported_u24lambda_u2d37.getMembers();
                    $i$f$filter = false;
                    var15_18 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    var18_24 = $this$filterTo$iv$iv.iterator();
                    while (var18_24.hasNext()) {
                        element$iv$iv = var18_24.next();
                        it = (IppAttribute)element$iv$iv;
                        $i$a$-filter-IppPrinter$isAttributeValueSupported$attributeValueIsSupported$1$1 = false;
                        if (!(CollectionsKt.contains((Iterable)supportedAttribute.getValues(), (Object)it.getName()) == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (IppAttribute)element$iv /* !! */ ;
                        $i$a$-forEach-IppPrinter$isAttributeValueSupported$attributeValueIsSupported$1$2 = false;
                        Logging.Logger.warn$default(IppPrinter.log, null, (Function0)new Function0<Object>(it){
                            final /* synthetic */ IppAttribute<?> $it;
                            {
                                this.$it = $it;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return Intrinsics.stringPlus((String)"member unsupported: ", this.$it);
                            }
                        }, 1, null);
                    }
                    var13_15 = supportedAttribute.getValues();
                    $this$map$iv = $this$isAttributeValueSupported_u24lambda_u2d37.getMembers();
                    $i$f$map = false;
                    element$iv /* !! */  = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        $i$a$-filter-IppPrinter$isAttributeValueSupported$attributeValueIsSupported$1$1 = (IppAttribute)item$iv$iv;
                        var22_31 = destination$iv$iv;
                        $i$a$-map-IppPrinter$isAttributeValueSupported$attributeValueIsSupported$1$3 = false;
                        var24_33 = it.getName();
                        var22_31.add(var24_33);
                    }
                    var14_17 = (List)destination$iv$iv;
                    var15_19 = false;
                    v1 = var13_15.containsAll(var14_17);
                } else {
                    v1 = CollectionsKt.contains((Iterable)supportedAttribute.getValues(), (Object)value);
                }
                v0 = v1;
                break;
            }
            case 8: {
                if (!supportedAttribute.is1setOf()) ** GOTO lbl72
                v2 = CollectionsKt.contains((Iterable)supportedAttribute.getValues(), (Object)value);
                ** GOTO lbl80
lbl72:
                // 1 sources

                if (!(value instanceof Integer)) ** GOTO lbl-1000
                var7_7 /* !! */  = supportedAttribute.getValue();
                if (var7_7 /* !! */  == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                if (((Number)value).intValue() <= (Integer)var7_7 /* !! */ ) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
lbl80:
                // 3 sources

                v0 = v2;
                break;
            }
            case 9: {
                if (!(value instanceof Integer)) ** GOTO lbl-1000
                var8_9 = supportedAttribute.getValue();
                if (var8_9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.ranges.IntRange");
                }
                var7_7 /* !! */  = (IntRange)var8_9;
                var8_10 = var7_7 /* !! */ .getFirst();
                var9_11 = var7_7 /* !! */ .getLast();
                var10_12 = ((Number)value).intValue();
                v3 = var8_10 <= var10_12 ? var10_12 <= var9_11 : false;
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                v0 = v4;
                break;
            }
            default: {
                v0 = null;
            }
        }
        attributeValueIsSupported = v0;
        var5_3 = attributeValueIsSupported;
        if (var5_3 == null) {
            Logging.Logger.warn$default(IppPrinter.log, null, (Function0)new Function0<Object>(value, supportedAttribute){
                final /* synthetic */ Object $value;
                final /* synthetic */ IppAttribute<?> $supportedAttribute;
                {
                    this.$value = $value;
                    this.$supportedAttribute = $supportedAttribute;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "unable to check if value '" + this.$value + "' is supported by " + this.$supportedAttribute;
                }
            }, 1, null);
        } else if (Intrinsics.areEqual((Object)var5_3, (Object)true)) {
            Logging.Logger.debug$default(IppPrinter.log, null, (Function0)new Function0<Object>(supportedAttributeName, value){
                final /* synthetic */ String $supportedAttributeName;
                final /* synthetic */ Object $value;
                {
                    this.$supportedAttributeName = $supportedAttributeName;
                    this.$value = $value;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$supportedAttributeName + ": " + this.$value;
                }
            }, 1, null);
        } else if (Intrinsics.areEqual((Object)var5_3, (Object)false)) {
            Logging.Logger.warn$default(IppPrinter.log, null, (Function0)new Function0<Object>(supportedAttribute, value){
                final /* synthetic */ IppAttribute<?> $supportedAttribute;
                final /* synthetic */ Object $value;
                {
                    this.$supportedAttribute = $supportedAttribute;
                    this.$value = $value;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "according to printer attributes value '" + this.$supportedAttribute.enumNameOrValue(this.$value) + "' is not supported.";
                }
            }, 1, null);
            Logging.Logger.warn$default(IppPrinter.log, null, (Function0)new Function0<Object>(supportedAttribute){
                final /* synthetic */ IppAttribute<?> $supportedAttribute;
                {
                    this.$supportedAttribute = $supportedAttribute;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return String.valueOf(this.$supportedAttribute);
                }
            }, 1, null);
        }
        return attributeValueIsSupported;
    }

    public final void savePrinterAttributes() {
        Object object = this.getMakeAndModel().getText();
        String string = "\\s+";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "_";
        boolean bl2 = false;
        String printerModel = string.replace((CharSequence)object, string2);
        object = IppPrinter.getPrinterAttributes$default(this, null, 1, null);
        boolean bl3 = false;
        boolean bl4 = false;
        Object $this$savePrinterAttributes_u24lambda_u2d38 = object;
        boolean bl5 = false;
        ((IppMessage)$this$savePrinterAttributes_u24lambda_u2d38).saveRawBytes(new File(Intrinsics.stringPlus((String)printerModel, (Object)".bin")));
        ((IppResponse)$this$savePrinterAttributes_u24lambda_u2d38).getPrinterGroup().saveText(new File(Intrinsics.stringPlus((String)printerModel, (Object)".txt")));
    }

    public final void fetchRawPrinterAttributes(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        IppClient ippClient = this.ippClient;
        boolean bl = false;
        boolean bl2 = false;
        IppClient $this$fetchRawPrinterAttributes_u24lambda_u2d40 = ippClient;
        boolean bl3 = false;
        Comparable<URI> comparable = $this$fetchRawPrinterAttributes_u24lambda_u2d40.toHttpUri(this.getPrinterUri());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"toHttpUri(printerUri)");
        Http.Response httpResponse = $this$fetchRawPrinterAttributes_u24lambda_u2d40.httpPostRequest((URI)comparable, IppPrinter.ippRequest$default(this, IppOperation.GetPrinterAttributes, null, null, 6, null));
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(httpResponse){
            final /* synthetic */ Http.Response $httpResponse;
            {
                this.$httpResponse = $httpResponse;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "http status: " + this.$httpResponse.getStatus() + ", content-type: " + this.$httpResponse.getContentType();
            }
        }, 1, null);
        comparable = new File(filename);
        boolean bl4 = false;
        boolean bl5 = false;
        Comparable<URI> $this$fetchRawPrinterAttributes_u24lambda_u2d40_u24lambda_u2d39 = comparable;
        boolean bl6 = false;
        InputStream inputStream = httpResponse.getContentStream();
        Intrinsics.checkNotNull((Object)inputStream);
        Comparable<URI> comparable2 = $this$fetchRawPrinterAttributes_u24lambda_u2d40_u24lambda_u2d39;
        boolean bl7 = false;
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)new FileOutputStream((File)comparable2), (int)0, (int)2, null);
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>((File)$this$fetchRawPrinterAttributes_u24lambda_u2d40_u24lambda_u2d39){
            final /* synthetic */ File $this_apply;
            {
                this.$this_apply = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "saved " + this.$this_apply.length() + " bytes: " + this.$this_apply.getPath();
            }
        }, 1, null);
    }

    public static /* synthetic */ void fetchRawPrinterAttributes$default(IppPrinter ippPrinter, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchRawPrinterAttributes");
        }
        if ((n & 1) != 0) {
            string = "printer-attributes.bin";
        }
        ippPrinter.fetchRawPrinterAttributes(string);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, @NotNull Collection<? extends IppAttributeBuilder> attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter(attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, inputStream, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, inputStream, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull byte[] byteArray, IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, byteArray, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull File file, IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, file, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppJob> getJobs(@Nullable IppWhichJobs whichJobs, @Nullable Boolean myJobs, @Nullable Integer limit) {
        return IppPrinter.getJobs$default(this, whichJobs, myJobs, limit, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppJob> getJobs(@Nullable IppWhichJobs whichJobs, @Nullable Boolean myJobs) {
        return IppPrinter.getJobs$default(this, whichJobs, myJobs, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppJob> getJobs(@Nullable IppWhichJobs whichJobs) {
        return IppPrinter.getJobs$default(this, whichJobs, null, null, null, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppJob> getJobs() {
        return IppPrinter.getJobs$default(this, null, null, null, null, 15, null);
    }

    static {
        Object[] objectArray = new String[]{"printer-is-accepting-jobs", "printer-state", "printer-state-reasons"};
        printerStateAttributes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"printer-name", "printer-make-and-model", "printer-is-accepting-jobs", "printer-state", "printer-state-reasons", "document-format-supported", "operations-supported", "color-supported", "sides-supported", "media-supported", "media-ready", "media-default", "ipp-versions-supported"};
        printerClassAttributes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lde/gmuth/ipp/client/IppPrinter$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "printerClassAttributes", "", "", "getPrinterClassAttributes", "()Ljava/util/List;", "printerStateAttributes", "getPrinterStateAttributes", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        @NotNull
        public final List<String> getPrinterStateAttributes() {
            return printerStateAttributes;
        }

        @NotNull
        public final List<String> getPrinterClassAttributes() {
            return printerClassAttributes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IppTag.values().length];
            nArray[IppTag.Boolean.ordinal()] = 1;
            nArray[IppTag.Enum.ordinal()] = 2;
            nArray[IppTag.Charset.ordinal()] = 3;
            nArray[IppTag.NaturalLanguage.ordinal()] = 4;
            nArray[IppTag.MimeMediaType.ordinal()] = 5;
            nArray[IppTag.Keyword.ordinal()] = 6;
            nArray[IppTag.Resolution.ordinal()] = 7;
            nArray[IppTag.Integer.ordinal()] = 8;
            nArray[IppTag.RangeOfInteger.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

