/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import de.gmuth.ipp.iana.IppRegistrationsSection6;
import de.gmuth.log.Logging;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0086\b\u0018\u0000 1*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u00011B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\"\u00028\u0000\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0000J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0018J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u0006\u0010&\u001a\u00020\"J\u0006\u0010'\u001a\u00020\"J\u0010\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u0004J\b\u0010+\u001a\u00020\u0004H\u0016J\u0015\u0010,\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b-J\u0017\u0010.\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b/\u00100R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lde/gmuth/ipp/core/IppAttribute;", "T", "Lde/gmuth/ipp/core/IppAttributeBuilder;", "name", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "values", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;Ljava/util/Collection;)V", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;[Ljava/lang/Object;)V", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;)V", "getName", "()Ljava/lang/String;", "getTag", "()Lde/gmuth/ipp/core/IppTag;", "value", "getValue", "()Ljava/lang/Object;", "", "getValues", "()Ljava/util/List;", "additionalValue", "", "attribute", "buildIppAttribute", "printerAttributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "component1", "component2", "copy", "enumNameOrValue", "equals", "", "other", "hashCode", "", "is1setOf", "isCollection", "logDetails", "", "prefix", "toString", "validateValueClass", "validateValueClass$ipp_client", "valueToString", "valueToString$ipp_client", "(Ljava/lang/Object;)Ljava/lang/String;", "Companion", "ipp-client"})
public final class IppAttribute<T>
implements IppAttributeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final IppTag tag;
    @NotNull
    private final List<T> values;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);

    public IppAttribute(@NotNull String name, @NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.name = name;
        this.tag = tag;
        boolean bl = false;
        this.values = new ArrayList();
        if (this.tag.isDelimiterTag()) {
            throw new IppException("" + '\'' + (Object)((Object)this.tag) + "' is not a value tag", null, 2, null);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final IppTag getTag() {
        return this.tag;
    }

    @NotNull
    public final List<T> getValues() {
        return this.values;
    }

    public IppAttribute(@NotNull String name, @NotNull IppTag tag, @NotNull Collection<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(name, tag);
        Object object = values;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = CollectionsKt.first((Iterable)values);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
            }
            this.validateValueClass$ipp_client(object);
        }
        this.values.addAll(CollectionsKt.toList((Iterable)values));
    }

    public IppAttribute(@NotNull String name, @NotNull IppTag tag, T ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(name, tag, ArraysKt.toList((Object[])values));
    }

    public final T getValue() {
        Object object = CollectionsKt.single(this.values);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$_get_value__u24lambda_u2d0 = object;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)IppRegistrationsSection2.INSTANCE.attributeIs1setOf(this.getName()), (Object)true)) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ IppAttribute<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return '\'' + this.this$0.getName() + "' is registered as '1setOf', use 'values' instead";
                }
            }, 1, null);
        }
        return (T)object;
    }

    @NotNull
    public final Object additionalValue(@NotNull IppAttribute<?> attribute) {
        Object object;
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        CharSequence charSequence = attribute.name;
        boolean bl = false;
        if (charSequence.length() > 0) {
            throw new IppException("for additional '" + this.name + "' values attribute name must be empty", null, 2, null);
        }
        if (attribute.values.size() != 1) {
            throw new IppException(Intrinsics.stringPlus((String)"expected 1 additional value, not ", (Object)attribute.values.size()), null, 2, null);
        }
        if (attribute.tag != this.tag) {
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>(this, attribute){
                final /* synthetic */ IppAttribute<T> this$0;
                final /* synthetic */ IppAttribute<?> $attribute;
                {
                    this.this$0 = $receiver;
                    this.$attribute = $attribute;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.this$0.getName() + ": ignore additional value \"" + this.$attribute + "\" - tag is not '" + (Object)((Object)this.this$0.getTag()) + '\'';
                }
            }, 1, null);
            object = Unit.INSTANCE;
        } else {
            charSequence = attribute.getValue();
            if (charSequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
            }
            this.validateValueClass$ipp_client(charSequence);
            object = this.values.add(attribute.getValue());
        }
        return object;
    }

    public final void validateValueClass$ipp_client(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!((Boolean)this.tag.getValueHasValidClass().invoke(value2)).booleanValue()) {
            throw new IppException("value class " + value2.getClass().getName() + " not valid for tag " + (Object)((Object)this.tag), null, 2, null);
        }
    }

    public final boolean is1setOf() {
        return this.values.size() > 1 || Intrinsics.areEqual((Object)IppRegistrationsSection2.INSTANCE.attributeIs1setOf(this.name), (Object)true);
    }

    public final boolean isCollection() {
        return this.tag == IppTag.BegCollection;
    }

    @Override
    @NotNull
    public IppAttribute<?> buildIppAttribute(@NotNull IppAttributesGroup printerAttributes) {
        Intrinsics.checkNotNullParameter((Object)printerAttributes, (String)"printerAttributes");
        return this;
    }

    @NotNull
    public String toString() {
        String tagString = Intrinsics.stringPlus((String)(this.is1setOf() ? "1setOf " : ""), (Object)((Object)this.tag));
        String valuesString2 = this.values.isEmpty() ? "no-value" : CollectionsKt.joinToString$default((Iterable)this.values, (CharSequence)",", null, null, (int)0, null, (Function1)new Function1<T, CharSequence>(this){
            final /* synthetic */ IppAttribute<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(T it) {
                return this.this$0.valueToString$ipp_client(it);
            }
        }, (int)30, null);
        return this.name + " (" + tagString + ") = " + valuesString2;
    }

    @NotNull
    public final String valueToString$ipp_client(T value2) {
        String string;
        if (this.tag == IppTag.Charset) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.nio.charset.Charset");
            }
            Charset charset = (Charset)value2;
            boolean bl = false;
            boolean bl2 = false;
            Charset $this$valueToString_u24lambda_u2d1 = charset;
            boolean bl3 = false;
            String string2 = $this$valueToString_u24lambda_u2d1.name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name()");
            boolean bl4 = false;
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        } else if (this.tag == IppTag.RangeOfInteger) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.ranges.IntRange");
            }
            IntRange intRange = (IntRange)value2;
            boolean bl = false;
            boolean bl5 = false;
            IntRange $this$valueToString_u24lambda_u2d2 = intRange;
            boolean bl6 = false;
            string = "" + $this$valueToString_u24lambda_u2d2.getStart() + '-' + $this$valueToString_u24lambda_u2d2.getEndInclusive();
        } else if (value2 instanceof byte[]) {
            byte[] byArray = (byte[])value2;
            boolean bl = false;
            boolean bl7 = false;
            byte[] $this$valueToString_u24lambda_u2d3 = byArray;
            boolean bl8 = false;
            byte[] byArray2 = $this$valueToString_u24lambda_u2d3;
            boolean bl9 = false;
            string = byArray2.length == 0 ? "no-value" : $this$valueToString_u24lambda_u2d3.length + " bytes";
        } else {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
            }
            string = this.enumNameOrValue(value2).toString();
        }
        return string;
    }

    @NotNull
    public final Object enumNameOrValue(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.tag == IppTag.Enum ? IppRegistrationsSection6.INSTANCE.getEnumName(this.name, value2) : value2;
    }

    public final void logDetails(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string = this.toString();
        if (string.length() < 160) {
            Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, string){
                final /* synthetic */ String $prefix;
                final /* synthetic */ String $string;
                {
                    this.$prefix = $prefix;
                    this.$string = $string;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)this.$prefix, (Object)this.$string);
                }
            }, 1, null);
        } else {
            Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, this){
                final /* synthetic */ String $prefix;
                final /* synthetic */ IppAttribute<T> this$0;
                {
                    this.$prefix = $prefix;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$prefix + this.this$0.getName() + " (" + (Object)((Object)this.this$0.getTag()) + ") =";
                }
            }, 1, null);
            for (T value2 : this.values) {
                if (value2 instanceof IppCollection) {
                    ((IppCollection)value2).logDetails(Intrinsics.stringPlus((String)prefix, (Object)"  "));
                    continue;
                }
                Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, this, value2){
                    final /* synthetic */ String $prefix;
                    final /* synthetic */ IppAttribute<T> this$0;
                    final /* synthetic */ T $value;
                    {
                        this.$prefix = $prefix;
                        this.this$0 = $receiver;
                        this.$value = $value;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        T t = this.$value;
                        if (t == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                        }
                        return this.$prefix + "  " + this.this$0.enumNameOrValue(t);
                    }
                }, 1, null);
            }
        }
    }

    public static /* synthetic */ void logDetails$default(IppAttribute ippAttribute, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        ippAttribute.logDetails(string);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final IppTag component2() {
        return this.tag;
    }

    @NotNull
    public final IppAttribute<T> copy(@NotNull String name, @NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        return new IppAttribute<T>(name, tag);
    }

    public static /* synthetic */ IppAttribute copy$default(IppAttribute ippAttribute, String string, IppTag ippTag, int n, Object object) {
        if ((n & 1) != 0) {
            string = ippAttribute.name;
        }
        if ((n & 2) != 0) {
            ippTag = ippAttribute.tag;
        }
        return ippAttribute.copy(string, ippTag);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.tag.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IppAttribute)) {
            return false;
        }
        IppAttribute ippAttribute = (IppAttribute)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)ippAttribute.name)) {
            return false;
        }
        return this.tag == ippAttribute.tag;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/core/IppAttribute$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

