/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.log.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B#\b\u0016\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\"\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0004J\u0018\u0010\u000e\u001a\u00020\f2\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u000fJ/\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0004\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u001d\u001a\u00020\u0012J\u0019\u0010\u001e\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001fJ\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0010\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u0012J\b\u0010%\u001a\u00020\u0012H\u0016R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lde/gmuth/ipp/core/IppCollection;", "", "attributes", "", "Lde/gmuth/ipp/core/IppAttribute;", "([Lde/gmuth/ipp/core/IppAttribute;)V", "members", "", "(Ljava/util/List;)V", "getMembers", "()Ljava/util/List;", "add", "", "attribute", "addAll", "", "addAttribute", "name", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "values", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;[Ljava/lang/Object;)Z", "component1", "copy", "equals", "other", "getMember", "T", "memberName", "getMemberValue", "(Ljava/lang/String;)Ljava/lang/Object;", "hashCode", "", "logDetails", "", "prefix", "toString", "Companion", "ipp-client"})
public final class IppCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IppAttribute<?>> members;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);

    public IppCollection(@NotNull List<IppAttribute<?>> members) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        this.members = members;
    }

    public /* synthetic */ IppCollection(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        this(list);
    }

    @NotNull
    public final List<IppAttribute<?>> getMembers() {
        return this.members;
    }

    public IppCollection(IppAttribute<?> ... attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this(ArraysKt.toMutableList((Object[])attributes));
    }

    public final boolean addAttribute(@NotNull String name, @NotNull IppTag tag, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.add(new IppAttribute(name, tag, ArraysKt.toMutableList((Object[])values)));
    }

    public final boolean add(@NotNull IppAttribute<?> attribute) {
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        return this.members.add(attribute);
    }

    public final boolean addAll(@NotNull Collection<? extends IppAttribute<?>> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        return this.members.addAll(attributes);
    }

    @NotNull
    public final <T> IppAttribute<T> getMember(@NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Iterable $this$single$iv = this.members;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IppAttribute it = (IppAttribute)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)memberName)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    public final <T> T getMemberValue(@NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return this.getMember(memberName).getValue();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.members, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    public final void logDetails(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string = this.toString();
        if (string.length() < 160) {
            Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, string){
                final /* synthetic */ String $prefix;
                final /* synthetic */ String $string;
                {
                    this.$prefix = $prefix;
                    this.$string = $string;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)this.$prefix, (Object)this.$string);
                }
            }, 1, null);
        } else {
            Iterable $this$forEach$iv = this.members;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IppAttribute it = (IppAttribute)element$iv;
                boolean bl = false;
                it.logDetails(prefix);
            }
        }
    }

    public static /* synthetic */ void logDetails$default(IppCollection ippCollection, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        ippCollection.logDetails(string);
    }

    @NotNull
    public final List<IppAttribute<?>> component1() {
        return this.members;
    }

    @NotNull
    public final IppCollection copy(@NotNull List<IppAttribute<?>> members) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        return new IppCollection(members);
    }

    public static /* synthetic */ IppCollection copy$default(IppCollection ippCollection, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = ippCollection.members;
        }
        return ippCollection.copy(list);
    }

    public int hashCode() {
        return ((Object)this.members).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IppCollection)) {
            return false;
        }
        IppCollection ippCollection = (IppCollection)other;
        return Intrinsics.areEqual(this.members, ippCollection.members);
    }

    public IppCollection() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/core/IppCollection$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

