/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.io.ByteArrayExtensionKt;
import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppDateTime;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppInputStream;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppResolution;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.log.Logging;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001f\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\b\b\u0002\u0010\u001e\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001fJ\r\u0010 \u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0017\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b+R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lde/gmuth/ipp/core/IppInputStream;", "Ljava/io/DataInputStream;", "inputStream", "Ljava/io/BufferedInputStream;", "(Ljava/io/BufferedInputStream;)V", "attributesCharset", "Ljava/nio/charset/Charset;", "getAttributesCharset$ipp_client", "()Ljava/nio/charset/Charset;", "setAttributesCharset$ipp_client", "(Ljava/nio/charset/Charset;)V", "readAttribute", "Lde/gmuth/ipp/core/IppAttribute;", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "readAttribute$ipp_client", "readAttributeValue", "readAttributeValue$ipp_client", "readBytes", "", "length", "", "readBytes$ipp_client", "readCollection", "Lde/gmuth/ipp/core/IppCollection;", "readCollection$ipp_client", "readExpectedValueLength", "", "expected", "throwException", "readExpectedValueLength$ipp_client", "readLengthAndValue", "readLengthAndValue$ipp_client", "readMessage", "", "message", "Lde/gmuth/ipp/core/IppMessage;", "readString", "", "charset", "readString$ipp_client", "readTag", "readTag$ipp_client", "Companion", "ipp-client"})
public final class IppInputStream
extends DataInputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public Charset attributesCharset;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);

    public IppInputStream(@NotNull BufferedInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
    }

    @NotNull
    public final Charset getAttributesCharset$ipp_client() {
        Charset charset = this.attributesCharset;
        if (charset != null) {
            return charset;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"attributesCharset");
        return null;
    }

    public final void setAttributesCharset$ipp_client(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.attributesCharset = charset;
    }

    public final void readMessage(@NotNull IppMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = false;
        boolean bl2 = false;
        IppMessage $this$readMessage_u24lambda_u2d0 = message;
        boolean bl3 = false;
        $this$readMessage_u24lambda_u2d0.setVersion("" + this.read() + '.' + this.read());
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$readMessage_u24lambda_u2d0){
            final /* synthetic */ IppMessage $this_with;
            {
                this.$this_with = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"version = ", (Object)this.$this_with.getVersion());
            }
        }, 1, null);
        $this$readMessage_u24lambda_u2d0.setCode(this.readShort());
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$readMessage_u24lambda_u2d0){
            final /* synthetic */ IppMessage $this_with;
            {
                this.$this_with = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "code = " + this.$this_with.getCode() + " (" + this.$this_with.getCodeDescription() + ')';
            }
        }, 1, null);
        $this$readMessage_u24lambda_u2d0.setRequestId(this.readInt());
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$readMessage_u24lambda_u2d0){
            final /* synthetic */ IppMessage $this_with;
            {
                this.$this_with = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"requestId = ", (Object)this.$this_with.getRequestId());
            }
        }, 1, null);
        IppAttributesGroup currentGroup = null;
        IppAttribute<Object> currentAttribute = null;
        try {
            IppTag tag;
            do {
                IppAttribute<Object> ippAttribute;
                tag = this.readTag$ipp_client();
                if (tag.isGroupTag()) {
                    currentGroup = message.createAttributesGroup(tag);
                    continue;
                }
                if (!tag.isValueTag()) continue;
                IppAttribute<Object> attribute = this.readAttribute$ipp_client(tag);
                Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(attribute){
                    final /* synthetic */ IppAttribute<Object> $attribute;
                    {
                        this.$attribute = $attribute;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return String.valueOf(this.$attribute);
                    }
                }, 1, null);
                CharSequence charSequence = attribute.getName();
                boolean bl4 = false;
                if (charSequence.length() > 0) {
                    IppAttributesGroup ippAttributesGroup;
                    if (currentGroup == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currentGroup");
                        ippAttributesGroup = null;
                    } else {
                        ippAttributesGroup = currentGroup;
                    }
                    ippAttributesGroup.put(attribute, true);
                    currentAttribute = attribute;
                    continue;
                }
                if (currentAttribute == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentAttribute");
                    ippAttribute = null;
                } else {
                    ippAttribute = currentAttribute;
                }
                ippAttribute.additionalValue(attribute);
            } while (tag != IppTag.End);
        }
        catch (Exception exception) {
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)this);
            boolean bl5 = false;
            boolean bl6 = false;
            byte[] $this$readMessage_u24lambda_u2d1 = byArray;
            boolean bl7 = false;
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>($this$readMessage_u24lambda_u2d1){
                final /* synthetic */ byte[] $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "skipped " + this.$this_apply.length + " unparsed bytes";
                }
            }, 1, null);
            ByteArrayExtensionKt.hexdump$default($this$readMessage_u24lambda_u2d1, 0, readMessage.3.2.INSTANCE, 1, null);
            throw exception;
        }
    }

    @NotNull
    public final IppTag readTag$ipp_client() {
        IppTag ippTag = IppTag.Companion.fromByte(this.readByte());
        boolean bl = false;
        boolean bl2 = false;
        IppTag $this$readTag_u24lambda_u2d2 = ippTag;
        boolean bl3 = false;
        if ($this$readTag_u24lambda_u2d2.isDelimiterTag()) {
            Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$readTag_u24lambda_u2d2){
                final /* synthetic */ IppTag $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "--- " + (Object)((Object)this.$this_apply) + " ---";
                }
            }, 1, null);
        }
        return ippTag;
    }

    @NotNull
    public final IppAttribute<Object> readAttribute$ipp_client(@NotNull IppTag tag) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        String name = IppInputStream.readString$ipp_client$default(this, null, 1, null);
        try {
            objectArray = this.readAttributeValue$ipp_client(tag);
        }
        catch (Exception exception) {
            if (!(exception instanceof EOFException)) {
                ByteArrayExtensionKt.hexdump$default(ByteStreamsKt.readBytes((InputStream)this), 0, readAttribute.value.1.INSTANCE, 1, null);
            }
            throw new IppException("failed to read attribute value of '" + name + "' (" + (Object)((Object)tag) + ')', exception);
        }
        Object[] value2 = objectArray;
        if (Intrinsics.areEqual((Object)name, (Object)"attributes-charset")) {
            this.setAttributesCharset$ipp_client((Charset)value2);
        }
        objectArray = new Object[]{value2};
        return new IppAttribute<Object>(name, tag, objectArray);
    }

    @NotNull
    public final Object readAttributeValue$ipp_client(@NotNull IppTag tag) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        IppTag ippTag = tag;
        int n = WhenMappings.$EnumSwitchMapping$0[ippTag.ordinal()];
        switch (n) {
            case 1: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 1, false, 2, null);
                object = this.readBoolean();
                break;
            }
            case 2: 
            case 3: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 4, false, 2, null);
                object = this.readInt();
                break;
            }
            case 4: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 8, false, 2, null);
                object = new IntRange(this.readInt(), this.readInt());
                break;
            }
            case 5: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 9, false, 2, null);
                object = new IppResolution(this.readInt(), this.readInt(), this.readByte());
                break;
            }
            case 6: {
                object = Charset.forName(IppInputStream.readString$ipp_client$default(this, null, 1, null));
                break;
            }
            case 7: {
                object = URI.create(IppInputStream.readString$ipp_client$default(this, null, 1, null));
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                object = IppInputStream.readString$ipp_client$default(this, null, 1, null);
                break;
            }
            case 14: 
            case 15: {
                object = new IppString(this.readString$ipp_client(this.getAttributesCharset$ipp_client()), null, 2, null);
                break;
            }
            case 16: 
            case 17: {
                this.readShort();
                Object object2 = this.readString$ipp_client(this.getAttributesCharset$ipp_client());
                String string = this.readString$ipp_client(this.getAttributesCharset$ipp_client());
                object = new IppString(string, (String)object2);
                break;
            }
            case 18: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 11, false, 2, null);
                object = new IppDateTime(this.readShort(), this.read(), this.read(), this.read(), this.read(), this.read(), this.read(), (char)this.readByte(), this.read(), this.read());
                break;
            }
            case 19: {
                if (this.readExpectedValueLength$ipp_client(0, false)) {
                    object = this.readCollection$ipp_client();
                    break;
                }
                Logging.Logger.warn$default(log, null, readAttributeValue.1.INSTANCE, 1, null);
                object = new IppCollection(null, 1, null);
                break;
            }
            default: {
                Object object2 = this.readLengthAndValue$ipp_client();
                boolean bl = false;
                boolean bl2 = false;
                Object $this$readAttributeValue_u24lambda_u2d3 = object2;
                boolean bl3 = false;
                if (((byte[])$this$readAttributeValue_u24lambda_u2d3).length > 0) {
                    Logging.LogLevel level = tag == IppTag.Unsupported_ ? Logging.LogLevel.DEBUG : Logging.LogLevel.WARN;
                    Logging.Logger.log$default(log, level, null, (Function0)new Function0<Object>($this$readAttributeValue_u24lambda_u2d3, tag){
                        final /* synthetic */ byte[] $this_apply;
                        final /* synthetic */ IppTag $tag;
                        {
                            this.$this_apply = $receiver;
                            this.$tag = $tag;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "ignore " + this.$this_apply.length + " value bytes tagged '" + (Object)((Object)this.$tag) + '\'';
                        }
                    }, 2, null);
                    ByteArrayExtensionKt.hexdump$default($this$readAttributeValue_u24lambda_u2d3, 0, (Function1)new Function1<String, Unit>(level){
                        final /* synthetic */ Logging.LogLevel $level;
                        {
                            this.$level = $level;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Logging.Logger.log$default(IppInputStream.Companion.getLog(), this.$level, null, (Function0)new Function0<Object>(it){
                                final /* synthetic */ String $it;
                                {
                                    this.$it = $it;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return this.$it;
                                }
                            }, 2, null);
                        }
                    }, 1, null);
                }
                object = object2;
            }
        }
        Object object3 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"when (tag) {\n\n          \u2026}\n            }\n        }");
        return object3;
    }

    @NotNull
    public final IppCollection readCollection$ipp_client() {
        IppAttribute<Object> attribute;
        IppCollection ippCollection = new IppCollection(null, 1, null);
        boolean bl = false;
        boolean bl2 = false;
        IppCollection $this$readCollection_u24lambda_u2d4 = ippCollection;
        boolean bl3 = false;
        IppAttribute<Object> currentMemberAttribute = null;
        do {
            IppAttribute<Object> ippAttribute;
            attribute = this.readAttribute$ipp_client(this.readTag$ipp_client());
            if (attribute.getTag().isMemberAttrName()) {
                String memberName = (String)attribute.getValue();
                IppAttribute<Object> firstValue = this.readAttribute$ipp_client(this.readTag$ipp_client());
                Object[] objectArray = new Object[]{firstValue.getValue()};
                currentMemberAttribute = new IppAttribute<Object>(memberName, firstValue.getTag(), objectArray);
                $this$readCollection_u24lambda_u2d4.add(currentMemberAttribute);
                continue;
            }
            if (!attribute.getTag().isMemberAttrValue()) continue;
            if (currentMemberAttribute == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentMemberAttribute");
                ippAttribute = null;
            } else {
                ippAttribute = currentMemberAttribute;
            }
            ippAttribute.additionalValue(attribute);
        } while (attribute.getTag() != IppTag.EndCollection);
        return ippCollection;
    }

    @NotNull
    public final String readString$ipp_client(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] byArray = this.readLengthAndValue$ipp_client();
        boolean bl = false;
        return new String(byArray, charset);
    }

    public static /* synthetic */ String readString$ipp_client$default(IppInputStream ippInputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.US_ASCII;
        }
        return ippInputStream.readString$ipp_client(charset);
    }

    @NotNull
    public final byte[] readLengthAndValue$ipp_client() {
        return this.readBytes$ipp_client(this.readShort());
    }

    @NotNull
    public final byte[] readBytes$ipp_client(int length) {
        byte[] byArray = new byte[length];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$readBytes_u24lambda_u2d5 = byArray;
        boolean bl3 = false;
        Logging.Logger.trace$default(log, null, (Function0)new Function0<Object>(length){
            final /* synthetic */ int $length;
            {
                this.$length = $length;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "read " + this.$length + " bytes";
            }
        }, 1, null);
        this.readFully($this$readBytes_u24lambda_u2d5);
        return byArray;
    }

    public final boolean readExpectedValueLength$ipp_client(int expected, boolean throwException) {
        this.mark(2);
        short length = this.readShort();
        boolean bl = length == expected;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean $this$readExpectedValueLength_u24lambda_u2d7 = bl;
        boolean bl4 = false;
        if (!$this$readExpectedValueLength_u24lambda_u2d7) {
            this.reset();
            String string = "expected value length of " + expected + " bytes but found " + length;
            boolean bl5 = false;
            boolean bl6 = false;
            String $this$readExpectedValueLength_u24lambda_u2d7_u24lambda_u2d6 = string;
            boolean bl7 = false;
            if (throwException) {
                throw new IppException($this$readExpectedValueLength_u24lambda_u2d7_u24lambda_u2d6, null, 2, null);
            }
            Logging.Logger.warn$default(log, null, (Function0)new Function0<Object>($this$readExpectedValueLength_u24lambda_u2d7_u24lambda_u2d6){
                final /* synthetic */ String $this_with;
                {
                    this.$this_with = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$this_with;
                }
            }, 1, null);
        }
        return bl;
    }

    public static /* synthetic */ boolean readExpectedValueLength$ipp_client$default(IppInputStream ippInputStream, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return ippInputStream.readExpectedValueLength$ipp_client(n, bl);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/core/IppInputStream$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IppTag.values().length];
            nArray[IppTag.Boolean.ordinal()] = 1;
            nArray[IppTag.Integer.ordinal()] = 2;
            nArray[IppTag.Enum.ordinal()] = 3;
            nArray[IppTag.RangeOfInteger.ordinal()] = 4;
            nArray[IppTag.Resolution.ordinal()] = 5;
            nArray[IppTag.Charset.ordinal()] = 6;
            nArray[IppTag.Uri.ordinal()] = 7;
            nArray[IppTag.Keyword.ordinal()] = 8;
            nArray[IppTag.UriScheme.ordinal()] = 9;
            nArray[IppTag.OctetString.ordinal()] = 10;
            nArray[IppTag.MimeMediaType.ordinal()] = 11;
            nArray[IppTag.MemberAttrName.ordinal()] = 12;
            nArray[IppTag.NaturalLanguage.ordinal()] = 13;
            nArray[IppTag.TextWithoutLanguage.ordinal()] = 14;
            nArray[IppTag.NameWithoutLanguage.ordinal()] = 15;
            nArray[IppTag.TextWithLanguage.ordinal()] = 16;
            nArray[IppTag.NameWithLanguage.ordinal()] = 17;
            nArray[IppTag.DateTime.ordinal()] = 18;
            nArray[IppTag.BegCollection.ordinal()] = 19;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

