/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.io.ByteArraySavingInputStream;
import de.gmuth.io.ByteArraySavingOutputStream;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppInputStream;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOutputStream;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.log.Logging;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 V2\u00020\u0001:\u0001VB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020<J\u0017\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020@H\u0002\u00a2\u0006\u0002\u0010AJ\u000e\u0010B\u001a\u00020\r2\u0006\u0010;\u001a\u00020<J\u000e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020,J\u0006\u0010F\u001a\u00020,J\u0006\u0010G\u001a\u00020HJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0I2\u0006\u0010;\u001a\u00020<J\u000e\u0010J\u001a\u00020\r2\u0006\u0010;\u001a\u00020<J\u0006\u0010K\u001a\u00020!J\u0010\u0010L\u001a\u00020D2\b\b\u0002\u0010M\u001a\u00020\u0003J\u000e\u0010N\u001a\u00020D2\u0006\u0010O\u001a\u00020PJ\u000e\u0010N\u001a\u00020D2\u0006\u0010Q\u001a\u00020\u001bJ\u000e\u0010R\u001a\u00020D2\u0006\u0010O\u001a\u00020PJ\u000e\u0010S\u001a\u00020D2\u0006\u0010O\u001a\u00020PJ\b\u0010T\u001a\u00020\u0003H\u0016J\u000e\u0010U\u001a\u00020D2\u0006\u0010O\u001a\u00020PJ\u000e\u0010U\u001a\u00020D2\u0006\u0010?\u001a\u00020@R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0017\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00105\u001a\u0004\b1\u00102\"\u0004\b3\u00104R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u00106\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0019\"\u0004\b8\u00109\u00a8\u0006W"}, d2={"Lde/gmuth/ipp/core/IppMessage;", "", "version", "", "requestId", "", "charset", "Ljava/nio/charset/Charset;", "naturalLanguage", "(Ljava/lang/String;ILjava/nio/charset/Charset;Ljava/lang/String;)V", "()V", "attributesGroups", "", "Lde/gmuth/ipp/core/IppAttributesGroup;", "getAttributesGroups", "()Ljava/util/List;", "code", "", "getCode", "()Ljava/lang/Short;", "setCode", "(Ljava/lang/Short;)V", "Ljava/lang/Short;", "codeDescription", "getCodeDescription", "()Ljava/lang/String;", "documentInputStream", "Ljava/io/InputStream;", "getDocumentInputStream", "()Ljava/io/InputStream;", "setDocumentInputStream", "(Ljava/io/InputStream;)V", "documentInputStreamIsConsumed", "", "getDocumentInputStreamIsConsumed", "()Z", "setDocumentInputStreamIsConsumed", "(Z)V", "jobGroup", "getJobGroup", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "operationGroup", "getOperationGroup", "rawBytes", "", "getRawBytes", "()[B", "setRawBytes", "([B)V", "getRequestId", "()Ljava/lang/Integer;", "setRequestId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "value", "getVersion", "setVersion", "(Ljava/lang/String;)V", "containsGroup", "tag", "Lde/gmuth/ipp/core/IppTag;", "copyDocumentStream", "", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)Ljava/lang/Long;", "createAttributesGroup", "decode", "", "byteArray", "encode", "encodeAsInputStream", "Ljava/io/ByteArrayInputStream;", "", "getSingleAttributesGroup", "hasDocument", "logDetails", "prefix", "read", "file", "Ljava/io/File;", "inputStream", "saveDocumentStream", "saveRawBytes", "toString", "write", "Companion", "ipp-client"})
public abstract class IppMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Short code;
    @Nullable
    private Integer requestId;
    @Nullable
    private String version;
    @NotNull
    private final List<IppAttributesGroup> attributesGroups;
    @Nullable
    private InputStream documentInputStream;
    private boolean documentInputStreamIsConsumed;
    @Nullable
    private byte[] rawBytes;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);

    public IppMessage() {
        boolean bl = false;
        this.attributesGroups = new ArrayList();
    }

    @Nullable
    public final Short getCode() {
        return this.code;
    }

    public final void setCode(@Nullable Short s) {
        this.code = s;
    }

    @Nullable
    public final Integer getRequestId() {
        return this.requestId;
    }

    public final void setRequestId(@Nullable Integer n) {
        this.requestId = n;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@Nullable String value2) {
        Regex regex = new Regex("^\\d\\.\\d$");
        String string = value2;
        Intrinsics.checkNotNull((Object)string);
        if (!regex.matches((CharSequence)string)) {
            throw new IppException(Intrinsics.stringPlus((String)"invalid version string: ", (Object)value2), null, 2, null);
        }
        this.version = value2;
    }

    @NotNull
    public final List<IppAttributesGroup> getAttributesGroups() {
        return this.attributesGroups;
    }

    @Nullable
    public final InputStream getDocumentInputStream() {
        return this.documentInputStream;
    }

    public final void setDocumentInputStream(@Nullable InputStream inputStream) {
        this.documentInputStream = inputStream;
    }

    public final boolean getDocumentInputStreamIsConsumed() {
        return this.documentInputStreamIsConsumed;
    }

    public final void setDocumentInputStreamIsConsumed(boolean bl) {
        this.documentInputStreamIsConsumed = bl;
    }

    @Nullable
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    public final void setRawBytes(@Nullable byte[] byArray) {
        this.rawBytes = byArray;
    }

    @NotNull
    public abstract String getCodeDescription();

    public IppMessage(@NotNull String version, int requestId, @NotNull Charset charset, @NotNull String naturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)naturalLanguage, (String)"naturalLanguage");
        this();
        this.setVersion(version);
        this.requestId = requestId;
        IppAttributesGroup ippAttributesGroup = this.createAttributesGroup(IppTag.Operation);
        boolean bl = false;
        boolean bl2 = false;
        IppAttributesGroup $this$_init__u24lambda_u2d0 = ippAttributesGroup;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{charset};
        $this$_init__u24lambda_u2d0.attribute("attributes-charset", IppTag.Charset, objectArray);
        objectArray = new Object[]{naturalLanguage};
        $this$_init__u24lambda_u2d0.attribute("attributes-natural-language", IppTag.NaturalLanguage, objectArray);
    }

    @NotNull
    public final IppAttributesGroup getOperationGroup() {
        return this.getSingleAttributesGroup(IppTag.Operation);
    }

    @NotNull
    public final IppAttributesGroup getJobGroup() {
        return this.getSingleAttributesGroup(IppTag.Job);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppAttributesGroup> getAttributesGroups(@NotNull IppTag tag) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Iterable $this$filter$iv = this.attributesGroups;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IppAttributesGroup it = (IppAttributesGroup)element$iv$iv;
            boolean bl = false;
            if (!(it.getTag() == tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final IppAttributesGroup getSingleAttributesGroup(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        List<IppAttributesGroup> list = this.getAttributesGroups(tag);
        boolean bl = false;
        boolean bl2 = false;
        List<IppAttributesGroup> $this$getSingleAttributesGroup_u24lambda_u2d2 = list;
        boolean bl3 = false;
        if ($this$getSingleAttributesGroup_u24lambda_u2d2.isEmpty()) {
            throw new IppException("no group found with tag '" + (Object)((Object)tag) + "' in " + this.getAttributesGroups(), null, 2, null);
        }
        return (IppAttributesGroup)CollectionsKt.single($this$getSingleAttributesGroup_u24lambda_u2d2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsGroup(@NotNull IppTag tag) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Iterable $this$map$iv = this.attributesGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IppTag ippTag = it.getTag();
            collection.add(ippTag);
        }
        return ((List)destination$iv$iv).contains((Object)tag);
    }

    @NotNull
    public final IppAttributesGroup createAttributesGroup(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        IppAttributesGroup ippAttributesGroup = new IppAttributesGroup(tag);
        boolean bl = false;
        boolean bl2 = false;
        IppAttributesGroup $this$createAttributesGroup_u24lambda_u2d4 = ippAttributesGroup;
        boolean bl3 = false;
        this.getAttributesGroups().add($this$createAttributesGroup_u24lambda_u2d4);
        return ippAttributesGroup;
    }

    public final boolean hasDocument() {
        return this.documentInputStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ByteArraySavingOutputStream byteArraySavingOutputStream = new ByteArraySavingOutputStream(outputStream);
        try {
            new IppOutputStream(byteArraySavingOutputStream).writeMessage(this);
            this.rawBytes = byteArraySavingOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            this.rawBytes = byteArraySavingOutputStream.toByteArray();
            Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ IppMessage this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("wrote raw ipp message: ");
                    byte[] byArray = this.this$0.getRawBytes();
                    Intrinsics.checkNotNull((Object)byArray);
                    return stringBuilder.append(byArray.length).append(" bytes").toString();
                }
            }, 1, null);
            byteArraySavingOutputStream.setSaveBytes(false);
            throw throwable;
        }
        Logging.Logger.debug$default(log, null, (Function0)new /* invalid duplicate definition of identical inner class */, 1, null);
        byteArraySavingOutputStream.setSaveBytes(false);
        this.copyDocumentStream(byteArraySavingOutputStream);
    }

    public final void write(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.write(new FileOutputStream(file));
    }

    @NotNull
    public final byte[] encode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream $this$encode_u24lambda_u2d5 = byteArrayOutputStream;
        boolean bl3 = false;
        this.write($this$encode_u24lambda_u2d5);
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$encode_u24lambda_u2d5){
            final /* synthetic */ ByteArrayOutputStream $this_with;
            {
                this.$this_with = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "ByteArrayOutputStream size: " + this.$this_with.size() + " bytes";
            }
        }, 1, null);
        byte[] byArray = $this$encode_u24lambda_u2d5.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"with(ByteArrayOutputStre\u2026      toByteArray()\n    }");
        return byArray;
    }

    @NotNull
    public final ByteArrayInputStream encodeAsInputStream() {
        return new ByteArrayInputStream(this.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArraySavingInputStream byteArraySavingInputStream = new ByteArraySavingInputStream(inputStream);
        InputStream inputStream2 = byteArraySavingInputStream;
        int n = 8192;
        boolean bl = false;
        BufferedInputStream bufferedInputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        try {
            new IppInputStream(bufferedInputStream).readMessage(this);
            this.documentInputStream = bufferedInputStream;
            this.rawBytes = byteArraySavingInputStream.toByteArray();
        }
        catch (Throwable throwable) {
            this.rawBytes = byteArraySavingInputStream.toByteArray();
            Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ IppMessage this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("read ");
                    byte[] byArray = this.this$0.getRawBytes();
                    Intrinsics.checkNotNull((Object)byArray);
                    return stringBuilder.append(byArray.length).append(" raw bytes").toString();
                }
            }, 1, null);
            throw throwable;
        }
        Logging.Logger.debug$default(log, null, (Function0)new /* invalid duplicate definition of identical inner class */, 1, null);
    }

    public final void read(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(file){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "read file " + this.$file.getAbsolutePath() + ": " + this.$file.length() + " bytes";
            }
        }, 1, null);
        this.read(new FileInputStream(file));
    }

    public final void decode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(byteArray){
            final /* synthetic */ byte[] $byteArray;
            {
                this.$byteArray = $byteArray;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "decode " + this.$byteArray.length + " bytes";
            }
        }, 1, null);
        this.read(new ByteArrayInputStream(byteArray));
    }

    private final Long copyDocumentStream(OutputStream outputStream) {
        InputStream inputStream;
        if (this.documentInputStreamIsConsumed) {
            Logging.Logger.warn$default(log, null, copyDocumentStream.1.INSTANCE, 1, null);
        }
        inputStream = (inputStream = this.documentInputStream) == null ? null : Long.valueOf(ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null));
        boolean bl = false;
        boolean bl2 = false;
        InputStream $this$copyDocumentStream_u24lambda_u2d6 = inputStream;
        boolean bl3 = false;
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>((Long)((Object)$this$copyDocumentStream_u24lambda_u2d6)){
            final /* synthetic */ Long $this_apply;
            {
                this.$this_apply = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "consumed documentInputStream: " + this.$this_apply + " bytes";
            }
        }, 1, null);
        this.setDocumentInputStreamIsConsumed(true);
        return inputStream;
    }

    public final void saveDocumentStream(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file;
        boolean bl = false;
        this.copyDocumentStream(new FileOutputStream(file2));
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(file){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "saved " + this.$file.length() + " document bytes to file " + this.$file.getPath();
            }
        }, 1, null);
    }

    public final void saveRawBytes(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.rawBytes == null) {
            Logging.Logger.warn$default(log, null, saveRawBytes.1.INSTANCE, 1, null);
        } else {
            Intrinsics.checkNotNull((Object)this.rawBytes);
            FilesKt.writeBytes((File)file, (byte[])this.rawBytes);
            Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "saved " + this.$file.length() + " bytes: " + this.$file.getPath();
                }
            }, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string2 = "%s %s%s";
        Object[] objectArray = new Object[3];
        objectArray[0] = this.getCodeDescription();
        Iterable iterable = this.attributesGroups;
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = "" + it.values().size() + ' ' + (Object)((Object)it.getTag());
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        if (this.rawBytes == null) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(" (");
            Intrinsics.checkNotNull((Object)this.rawBytes);
            string = stringBuilder.append(this.rawBytes.length).append(" bytes)").toString();
        }
        objectArray[2] = string;
        boolean bl = false;
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(this, *args)");
        return string4;
    }

    public final void logDetails(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (this.rawBytes != null) {
            Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, this){
                final /* synthetic */ String $prefix;
                final /* synthetic */ IppMessage this$0;
                {
                    this.$prefix = $prefix;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append(this.$prefix);
                    byte[] byArray = this.this$0.getRawBytes();
                    Intrinsics.checkNotNull((Object)byArray);
                    return stringBuilder.append(byArray.length).append(" raw ipp bytes").toString();
                }
            }, 1, null);
        }
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, this){
            final /* synthetic */ String $prefix;
            final /* synthetic */ IppMessage this$0;
            {
                this.$prefix = $prefix;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$prefix + "version = " + this.this$0.getVersion();
            }
        }, 1, null);
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, this){
            final /* synthetic */ String $prefix;
            final /* synthetic */ IppMessage this$0;
            {
                this.$prefix = $prefix;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)this.$prefix, (Object)this.this$0.getCodeDescription());
            }
        }, 1, null);
        Logging.Logger.info$default(log, null, (Function0)new Function0<Object>(prefix, this){
            final /* synthetic */ String $prefix;
            final /* synthetic */ IppMessage this$0;
            {
                this.$prefix = $prefix;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$prefix + "request-id = " + this.this$0.getRequestId();
            }
        }, 1, null);
        for (IppAttributesGroup group : this.attributesGroups) {
            IppAttributesGroup.logDetails$default(group, prefix, null, 2, null);
        }
    }

    public static /* synthetic */ void logDetails$default(IppMessage ippMessage, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logDetails");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        ippMessage.logDetails(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/core/IppMessage$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

