/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppDateTime;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOutputStream;
import de.gmuth.ipp.core.IppResolution;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.log.Logging;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018J\u001f\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\"R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lde/gmuth/ipp/core/IppOutputStream;", "Ljava/io/DataOutputStream;", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "attributesCharset", "Ljava/nio/charset/Charset;", "getAttributesCharset$ipp_client", "()Ljava/nio/charset/Charset;", "setAttributesCharset$ipp_client", "(Ljava/nio/charset/Charset;)V", "writeAttribute", "", "attribute", "Lde/gmuth/ipp/core/IppAttribute;", "writeAttribute$ipp_client", "writeAttributeValue", "tag", "Lde/gmuth/ipp/core/IppTag;", "value", "", "writeAttributeValue$ipp_client", "writeMessage", "message", "Lde/gmuth/ipp/core/IppMessage;", "writeString", "string", "", "charset", "writeString$ipp_client", "writeTag", "writeTag$ipp_client", "writeVersion", "version", "writeVersion$ipp_client", "Companion", "ipp-client"})
public final class IppOutputStream
extends DataOutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public Charset attributesCharset;
    @NotNull
    private static final Logging.Logger log = Logging.getLogger$default(Logging.INSTANCE, null, Companion.log.1.INSTANCE, 1, null);

    public IppOutputStream(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        super(outputStream);
    }

    @NotNull
    public final Charset getAttributesCharset$ipp_client() {
        Charset charset = this.attributesCharset;
        if (charset != null) {
            return charset;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"attributesCharset");
        return null;
    }

    public final void setAttributesCharset$ipp_client(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.attributesCharset = charset;
    }

    public final void writeMessage(@NotNull IppMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IppMessage ippMessage = message;
        boolean bl = false;
        boolean bl2 = false;
        IppMessage $this$writeMessage_u24lambda_u2d0 = ippMessage;
        boolean bl3 = false;
        this.setAttributesCharset$ipp_client((Charset)$this$writeMessage_u24lambda_u2d0.getOperationGroup().getValue("attributes-charset"));
        Iterator<IppAttributesGroup> iterator = $this$writeMessage_u24lambda_u2d0.getVersion();
        if (iterator == null) {
            throw new IppException("missing version", null, 2, null);
        }
        this.writeVersion$ipp_client((String)((Object)iterator));
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$writeMessage_u24lambda_u2d0){
            final /* synthetic */ IppMessage $this_run;
            {
                this.$this_run = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"version = ", (Object)this.$this_run.getVersion());
            }
        }, 1, null);
        Short s = $this$writeMessage_u24lambda_u2d0.getCode();
        Iterator<IppAttributesGroup> iterator2 = iterator = s == null ? null : Integer.valueOf(s.shortValue());
        if (iterator == null) {
            throw new IppException("missing operation or status code", null, 2, null);
        }
        this.writeShort((Integer)((Object)iterator));
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$writeMessage_u24lambda_u2d0){
            final /* synthetic */ IppMessage $this_run;
            {
                this.$this_run = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "code = " + this.$this_run.getCode() + " (" + this.$this_run.getCodeDescription() + ')';
            }
        }, 1, null);
        iterator = $this$writeMessage_u24lambda_u2d0.getRequestId();
        if (iterator == null) {
            throw new IppException("missing requestId", null, 2, null);
        }
        this.writeInt((Integer)((Object)iterator));
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>($this$writeMessage_u24lambda_u2d0){
            final /* synthetic */ IppMessage $this_run;
            {
                this.$this_run = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"requestId = ", (Object)this.$this_run.getRequestId());
            }
        }, 1, null);
        for (IppAttributesGroup group : $this$writeMessage_u24lambda_u2d0.getAttributesGroups()) {
            this.writeTag$ipp_client(group.getTag());
            for (IppAttribute<?> attribute : group.values()) {
                try {
                    Intrinsics.checkNotNullExpressionValue(attribute, (String)"attribute");
                    this.writeAttribute$ipp_client(attribute);
                }
                catch (Exception exception) {
                    throw new IppException(Intrinsics.stringPlus((String)"failed to write attribute: ", attribute), exception);
                }
            }
        }
        this.writeTag$ipp_client(IppTag.End);
    }

    public final void writeVersion$ipp_client(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        MatchResult matchResult = Regex.find$default((Regex)new Regex("^(\\d)\\.(\\d)$"), (CharSequence)version, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        MatchResult matchResult2 = matchResult;
        boolean bl = false;
        boolean bl2 = false;
        MatchResult $this$writeVersion_u24lambda_u2d1 = matchResult2;
        boolean bl3 = false;
        MatchGroup matchGroup = $this$writeVersion_u24lambda_u2d1.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        String string = matchGroup.getValue();
        boolean bl4 = false;
        this.writeByte(Integer.parseInt(string));
        MatchGroup matchGroup2 = $this$writeVersion_u24lambda_u2d1.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup2);
        string = matchGroup2.getValue();
        bl4 = false;
        this.writeByte(Integer.parseInt(string));
    }

    public final void writeTag$ipp_client(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        if (tag.isDelimiterTag()) {
            Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(tag){
                final /* synthetic */ IppTag $tag;
                {
                    this.$tag = $tag;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "--- " + (Object)((Object)this.$tag) + " ---";
                }
            }, 1, null);
        }
        this.writeByte(tag.getCode());
    }

    public final void writeString$ipp_client(@NotNull String string, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Object object = string;
        boolean bl = false;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        bl = false;
        boolean bl2 = false;
        Object $this$writeString_u24lambda_u2d2 = object;
        boolean bl3 = false;
        this.writeShort(((Object)$this$writeString_u24lambda_u2d2).length);
        this.write((byte[])$this$writeString_u24lambda_u2d2);
    }

    public static /* synthetic */ void writeString$ipp_client$default(IppOutputStream ippOutputStream, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.US_ASCII;
        }
        ippOutputStream.writeString$ipp_client(string, charset);
    }

    public final void writeAttribute$ipp_client(@NotNull IppAttribute<?> attribute) {
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        Logging.Logger.debug$default(log, null, (Function0)new Function0<Object>(attribute){
            final /* synthetic */ IppAttribute<?> $attribute;
            {
                this.$attribute = $attribute;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return String.valueOf(this.$attribute);
            }
        }, 1, null);
        boolean bl = false;
        boolean bl2 = false;
        IppAttribute<?> $this$writeAttribute_u24lambda_u2d3 = attribute;
        boolean bl3 = false;
        if ($this$writeAttribute_u24lambda_u2d3.getValues().isEmpty() || $this$writeAttribute_u24lambda_u2d3.getTag().isOutOfBandTag()) {
            this.writeTag$ipp_client($this$writeAttribute_u24lambda_u2d3.getTag());
            IppOutputStream.writeString$ipp_client$default(this, $this$writeAttribute_u24lambda_u2d3.getName(), null, 2, null);
            this.writeShort(0);
        } else {
            Iterator<?> iterator = $this$writeAttribute_u24lambda_u2d3.getValues().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                Object value2 = iterator.next();
                this.writeTag$ipp_client($this$writeAttribute_u24lambda_u2d3.getTag());
                IppOutputStream.writeString$ipp_client$default(this, index == 0 ? $this$writeAttribute_u24lambda_u2d3.getName() : "", null, 2, null);
                IppTag ippTag = $this$writeAttribute_u24lambda_u2d3.getTag();
                Object obj = value2;
                Intrinsics.checkNotNull(obj);
                this.writeAttributeValue$ipp_client(ippTag, obj);
            }
        }
    }

    public final void writeAttributeValue$ipp_client(@NotNull IppTag tag, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        IppTag ippTag = tag;
        int n = WhenMappings.$EnumSwitchMapping$0[ippTag.ordinal()];
        switch (n) {
            case 1: {
                Boolean bl = (Boolean)value2;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean $this$writeAttributeValue_u24lambda_u2d4 = bl;
                boolean bl4 = false;
                this.writeShort(1);
                this.writeBoolean((Boolean)value2);
                break;
            }
            case 2: 
            case 3: {
                Number number = (Number)value2;
                boolean bl = false;
                boolean bl5 = false;
                Number $this$writeAttributeValue_u24lambda_u2d5 = number;
                boolean bl6 = false;
                this.writeShort(4);
                this.writeInt(((Number)value2).intValue());
                break;
            }
            case 4: {
                IntRange intRange = (IntRange)value2;
                boolean bl = false;
                boolean bl7 = false;
                IntRange $this$writeAttributeValue_u24lambda_u2d6 = intRange;
                boolean bl8 = false;
                this.writeShort(8);
                this.writeInt($this$writeAttributeValue_u24lambda_u2d6.getStart());
                this.writeInt($this$writeAttributeValue_u24lambda_u2d6.getEndInclusive());
                break;
            }
            case 5: {
                IppResolution ippResolution = (IppResolution)value2;
                boolean bl = false;
                boolean bl9 = false;
                IppResolution $this$writeAttributeValue_u24lambda_u2d7 = ippResolution;
                boolean bl10 = false;
                this.writeShort(9);
                this.writeInt($this$writeAttributeValue_u24lambda_u2d7.getX());
                this.writeInt($this$writeAttributeValue_u24lambda_u2d7.getY());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d7.getUnit());
                break;
            }
            case 6: {
                Charset charset = (Charset)value2;
                boolean bl = false;
                boolean bl11 = false;
                Charset $this$writeAttributeValue_u24lambda_u2d8 = charset;
                boolean bl12 = false;
                String string = $this$writeAttributeValue_u24lambda_u2d8.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
                boolean bl13 = false;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                IppOutputStream.writeString$ipp_client$default(this, string2, null, 2, null);
                break;
            }
            case 7: {
                URI uRI = (URI)value2;
                boolean bl = false;
                boolean bl14 = false;
                URI $this$writeAttributeValue_u24lambda_u2d9 = uRI;
                boolean bl15 = false;
                IppOutputStream.writeString$ipp_client$default(this, value2.toString(), null, 2, null);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                String string = (String)value2;
                boolean bl = false;
                boolean bl16 = false;
                String $this$writeAttributeValue_u24lambda_u2d10 = string;
                boolean bl17 = false;
                IppOutputStream.writeString$ipp_client$default(this, (String)value2, null, 2, null);
                break;
            }
            case 14: 
            case 15: {
                IppString ippString = (IppString)value2;
                boolean bl = false;
                boolean bl18 = false;
                IppString $this$writeAttributeValue_u24lambda_u2d11 = ippString;
                boolean bl19 = false;
                this.writeString$ipp_client(((IppString)value2).getText(), this.getAttributesCharset$ipp_client());
                break;
            }
            case 16: 
            case 17: {
                IppString ippString = (IppString)value2;
                boolean bl = false;
                boolean bl20 = false;
                IppString $this$writeAttributeValue_u24lambda_u2d12 = ippString;
                boolean bl21 = false;
                if ($this$writeAttributeValue_u24lambda_u2d12.getLanguage() == null) {
                    throw new IppException("expected IppString with language", null, 2, null);
                }
                this.writeShort(4 + $this$writeAttributeValue_u24lambda_u2d12.getText().length() + $this$writeAttributeValue_u24lambda_u2d12.getLanguage().length());
                this.writeString$ipp_client($this$writeAttributeValue_u24lambda_u2d12.getLanguage(), this.getAttributesCharset$ipp_client());
                this.writeString$ipp_client($this$writeAttributeValue_u24lambda_u2d12.getText(), this.getAttributesCharset$ipp_client());
                break;
            }
            case 18: {
                IppDateTime ippDateTime = (IppDateTime)value2;
                boolean bl = false;
                boolean bl22 = false;
                IppDateTime $this$writeAttributeValue_u24lambda_u2d13 = ippDateTime;
                boolean bl23 = false;
                this.writeShort(11);
                this.writeShort($this$writeAttributeValue_u24lambda_u2d13.getYear());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getMonth());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getDay());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getHour());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getMinutes());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getSeconds());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getDeciSeconds());
                char c = $this$writeAttributeValue_u24lambda_u2d13.getDirectionFromUTC();
                boolean bl24 = false;
                this.writeByte(c);
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getHoursFromUTC());
                this.writeByte($this$writeAttributeValue_u24lambda_u2d13.getMinutesFromUTC());
                break;
            }
            case 19: {
                IppCollection ippCollection = (IppCollection)value2;
                boolean bl = false;
                boolean bl25 = false;
                IppCollection $this$writeAttributeValue_u24lambda_u2d14 = ippCollection;
                boolean bl26 = false;
                this.writeShort(0);
                for (IppAttribute<?> member : $this$writeAttributeValue_u24lambda_u2d14.getMembers()) {
                    String[] stringArray = new String[]{member.getName()};
                    this.writeAttribute$ipp_client(new IppAttribute<String>("", IppTag.MemberAttrName, stringArray));
                    for (Object memberValue : member.getValues()) {
                        Object[] objectArray = new Object[]{memberValue};
                        this.writeAttribute$ipp_client(new IppAttribute<Object>("", member.getTag(), objectArray));
                    }
                }
                this.writeAttribute$ipp_client(new IppAttribute("", IppTag.EndCollection));
                break;
            }
            default: {
                String string = "unknown tag 0x%02X %s";
                Object[] objectArray = new Object[]{tag.getCode(), tag};
                boolean bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
                throw new IppException(string3, null, 2, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/core/IppOutputStream$Companion;", "", "()V", "log", "Lde/gmuth/log/Logging$Logger;", "getLog", "()Lde/gmuth/log/Logging$Logger;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logging.Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IppTag.values().length];
            nArray[IppTag.Boolean.ordinal()] = 1;
            nArray[IppTag.Integer.ordinal()] = 2;
            nArray[IppTag.Enum.ordinal()] = 3;
            nArray[IppTag.RangeOfInteger.ordinal()] = 4;
            nArray[IppTag.Resolution.ordinal()] = 5;
            nArray[IppTag.Charset.ordinal()] = 6;
            nArray[IppTag.Uri.ordinal()] = 7;
            nArray[IppTag.Keyword.ordinal()] = 8;
            nArray[IppTag.UriScheme.ordinal()] = 9;
            nArray[IppTag.OctetString.ordinal()] = 10;
            nArray[IppTag.MimeMediaType.ordinal()] = 11;
            nArray[IppTag.MemberAttrName.ordinal()] = 12;
            nArray[IppTag.NaturalLanguage.ordinal()] = 13;
            nArray[IppTag.TextWithoutLanguage.ordinal()] = 14;
            nArray[IppTag.NameWithoutLanguage.ordinal()] = 15;
            nArray[IppTag.TextWithLanguage.ordinal()] = 16;
            nArray[IppTag.NameWithLanguage.ordinal()] = 17;
            nArray[IppTag.DateTime.ordinal()] = 18;
            nArray[IppTag.BegCollection.ordinal()] = 19;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

