/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.log;

import de.gmuth.log.Logging;
import java.io.PrintWriter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003()*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u001a\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\n2\b\b\u0002\u0010#\u001a\u00020\u0016H\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lde/gmuth/log/Logging;", "", "()V", "consoleWriterEnabled", "", "getConsoleWriterEnabled", "()Z", "setConsoleWriterEnabled", "(Z)V", "consoleWriterFormat", "", "getConsoleWriterFormat", "()Ljava/lang/String;", "setConsoleWriterFormat", "(Ljava/lang/String;)V", "consoleWriterSimpleClassName", "getConsoleWriterSimpleClassName", "setConsoleWriterSimpleClassName", "debugLoggingConfig", "getDebugLoggingConfig", "setDebugLoggingConfig", "defaultLogLevel", "Lde/gmuth/log/Logging$LogLevel;", "getDefaultLogLevel", "()Lde/gmuth/log/Logging$LogLevel;", "setDefaultLogLevel", "(Lde/gmuth/log/Logging$LogLevel;)V", "factory", "Lde/gmuth/log/Logging$Factory;", "getFactory", "()Lde/gmuth/log/Logging$Factory;", "setFactory", "(Lde/gmuth/log/Logging$Factory;)V", "getLogger", "Lde/gmuth/log/Logging$Logger;", "logLevel", "noOperation", "Lkotlin/Function0;", "", "name", "Factory", "LogLevel", "Logger", "ipp-client"})
public final class Logging {
    @NotNull
    public static final Logging INSTANCE = new Logging();
    private static boolean debugLoggingConfig;
    @NotNull
    private static LogLevel defaultLogLevel;
    private static boolean consoleWriterEnabled;
    @NotNull
    private static String consoleWriterFormat;
    private static boolean consoleWriterSimpleClassName;
    @NotNull
    private static Factory factory;

    private Logging() {
    }

    public final boolean getDebugLoggingConfig() {
        return debugLoggingConfig;
    }

    public final void setDebugLoggingConfig(boolean bl) {
        debugLoggingConfig = bl;
    }

    @NotNull
    public final LogLevel getDefaultLogLevel() {
        return defaultLogLevel;
    }

    public final void setDefaultLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        defaultLogLevel = logLevel;
    }

    public final boolean getConsoleWriterEnabled() {
        return consoleWriterEnabled;
    }

    public final void setConsoleWriterEnabled(boolean bl) {
        consoleWriterEnabled = bl;
    }

    @NotNull
    public final String getConsoleWriterFormat() {
        return consoleWriterFormat;
    }

    public final void setConsoleWriterFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        consoleWriterFormat = string;
    }

    public final boolean getConsoleWriterSimpleClassName() {
        return consoleWriterSimpleClassName;
    }

    public final void setConsoleWriterSimpleClassName(boolean bl) {
        consoleWriterSimpleClassName = bl;
    }

    @NotNull
    public final Factory getFactory() {
        return factory;
    }

    public final void setFactory(@NotNull Factory factory2) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"<set-?>");
        factory = factory2;
    }

    @JvmOverloads
    @NotNull
    public final Logger getLogger(@NotNull String name, @NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Logger logger = factory.getLogger(name);
        boolean bl = false;
        boolean bl2 = false;
        Logger $this$getLogger_u24lambda_u2d0 = logger;
        boolean bl3 = false;
        if (INSTANCE.getDebugLoggingConfig()) {
            String string = "new Logger: level=%-5s name=%s";
            Object[] objectArray = new Object[]{logLevel, name};
            boolean bl4 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            string = string2;
            boolean bl5 = false;
            System.out.println((Object)string);
        }
        $this$getLogger_u24lambda_u2d0.setLogLevel(logLevel);
        return logger;
    }

    public static /* synthetic */ Logger getLogger$default(Logging logging, String string, LogLevel logLevel, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = defaultLogLevel;
        }
        return logging.getLogger(string, logLevel);
    }

    @NotNull
    public final Logger getLogger(@NotNull LogLevel logLevel, @NotNull Function0<Unit> noOperation) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter(noOperation, (String)"noOperation");
        String string = noOperation.getClass().getEnclosingClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"noOperation.javaClass.enclosingClass.name");
        return this.getLogger(string, logLevel);
    }

    public static /* synthetic */ Logger getLogger$default(Logging logging, LogLevel logLevel, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = defaultLogLevel;
        }
        return logging.getLogger(logLevel, (Function0<Unit>)function0);
    }

    @JvmOverloads
    @NotNull
    public final Logger getLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Logging.getLogger$default(this, name, null, 2, null);
    }

    static {
        defaultLogLevel = LogLevel.INFO;
        consoleWriterEnabled = true;
        consoleWriterFormat = "%-25s %-5s %s";
        consoleWriterSimpleClassName = true;
        factory = factory.1.INSTANCE;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lde/gmuth/log/Logging$LogLevel;", "", "(Ljava/lang/String;I)V", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "ipp-client"})
    public static final class LogLevel
    extends Enum<LogLevel> {
        public static final /* enum */ LogLevel TRACE = new LogLevel();
        public static final /* enum */ LogLevel DEBUG = new LogLevel();
        public static final /* enum */ LogLevel INFO = new LogLevel();
        public static final /* enum */ LogLevel WARN = new LogLevel();
        public static final /* enum */ LogLevel ERROR = new LogLevel();
        private static final /* synthetic */ LogLevel[] $VALUES;

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String value2) {
            return Enum.valueOf(LogLevel.class, value2);
        }

        static {
            $VALUES = logLevelArray = new LogLevel[]{LogLevel.TRACE, LogLevel.DEBUG, LogLevel.INFO, LogLevel.WARN, LogLevel.ERROR};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012j\u0002`\u0013H\u0007J*\u0010\u0014\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012j\u0002`\u0013H\u0007J*\u0010\u0015\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012j\u0002`\u0013H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u001b\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012j\u0002`\u0013H\u0007J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0004\u001a\u00020\u0005J$\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0016J*\u0010\u001f\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012j\u0002`\u0013H\u0007J*\u0010 \u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012j\u0002`\u0013H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lde/gmuth/log/Logging$Logger;", "", "name", "", "logLevel", "Lde/gmuth/log/Logging$LogLevel;", "(Ljava/lang/String;Lde/gmuth/log/Logging$LogLevel;)V", "getLogLevel", "()Lde/gmuth/log/Logging$LogLevel;", "setLogLevel", "(Lde/gmuth/log/Logging$LogLevel;)V", "getName", "()Ljava/lang/String;", "debug", "", "throwable", "", "messageProducer", "Lkotlin/Function0;", "Lde/gmuth/log/MessageProducer;", "error", "info", "isEnabled", "", "level", "log", "messageLogLevel", "produceMessage", "logWithCauseMessages", "publish", "messageString", "trace", "warn", "ipp-client"})
    public static class Logger {
        @NotNull
        private final String name;
        @NotNull
        private LogLevel logLevel;

        public Logger(@NotNull String name, @NotNull LogLevel logLevel) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            this.name = name;
            this.logLevel = logLevel;
        }

        public /* synthetic */ Logger(String string, LogLevel logLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                logLevel = INSTANCE.getDefaultLogLevel();
            }
            this(string, logLevel);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final LogLevel getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(@NotNull LogLevel logLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
            this.logLevel = logLevel;
        }

        @JvmOverloads
        public final void trace(@Nullable Throwable throwable, @NotNull Function0<? extends Object> messageProducer) {
            Intrinsics.checkNotNullParameter(messageProducer, (String)"messageProducer");
            this.log(LogLevel.TRACE, throwable, messageProducer);
        }

        public static /* synthetic */ void trace$default(Logger logger, Throwable throwable, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: trace");
            }
            if ((n & 1) != 0) {
                throwable = null;
            }
            if ((n & 2) != 0) {
                function0 = trace.1.INSTANCE;
            }
            logger.trace(throwable, (Function0<? extends Object>)function0);
        }

        @JvmOverloads
        public final void debug(@Nullable Throwable throwable, @NotNull Function0<? extends Object> messageProducer) {
            Intrinsics.checkNotNullParameter(messageProducer, (String)"messageProducer");
            this.log(LogLevel.DEBUG, throwable, messageProducer);
        }

        public static /* synthetic */ void debug$default(Logger logger, Throwable throwable, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debug");
            }
            if ((n & 1) != 0) {
                throwable = null;
            }
            if ((n & 2) != 0) {
                function0 = debug.1.INSTANCE;
            }
            logger.debug(throwable, (Function0<? extends Object>)function0);
        }

        @JvmOverloads
        public final void info(@Nullable Throwable throwable, @NotNull Function0<? extends Object> messageProducer) {
            Intrinsics.checkNotNullParameter(messageProducer, (String)"messageProducer");
            this.log(LogLevel.INFO, throwable, messageProducer);
        }

        public static /* synthetic */ void info$default(Logger logger, Throwable throwable, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: info");
            }
            if ((n & 1) != 0) {
                throwable = null;
            }
            if ((n & 2) != 0) {
                function0 = info.1.INSTANCE;
            }
            logger.info(throwable, (Function0<? extends Object>)function0);
        }

        @JvmOverloads
        public final void warn(@Nullable Throwable throwable, @NotNull Function0<? extends Object> messageProducer) {
            Intrinsics.checkNotNullParameter(messageProducer, (String)"messageProducer");
            this.log(LogLevel.WARN, throwable, messageProducer);
        }

        public static /* synthetic */ void warn$default(Logger logger, Throwable throwable, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warn");
            }
            if ((n & 1) != 0) {
                throwable = null;
            }
            if ((n & 2) != 0) {
                function0 = warn.1.INSTANCE;
            }
            logger.warn(throwable, (Function0<? extends Object>)function0);
        }

        @JvmOverloads
        public final void error(@Nullable Throwable throwable, @NotNull Function0<? extends Object> messageProducer) {
            Intrinsics.checkNotNullParameter(messageProducer, (String)"messageProducer");
            this.log(LogLevel.ERROR, throwable, messageProducer);
        }

        public static /* synthetic */ void error$default(Logger logger, Throwable throwable, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
            }
            if ((n & 1) != 0) {
                throwable = null;
            }
            if ((n & 2) != 0) {
                function0 = error.1.INSTANCE;
            }
            logger.error(throwable, (Function0<? extends Object>)function0);
        }

        @JvmOverloads
        public final void log(@NotNull LogLevel messageLogLevel, @Nullable Throwable throwable, @NotNull Function0<? extends Object> produceMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageLogLevel), (String)"messageLogLevel");
            Intrinsics.checkNotNullParameter(produceMessage, (String)"produceMessage");
            if (this.isEnabled(messageLogLevel)) {
                Object object = produceMessage.invoke();
                this.publish(messageLogLevel, throwable, object == null ? null : object.toString());
            }
        }

        public static /* synthetic */ void log$default(Logger logger, LogLevel logLevel, Throwable throwable, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            logger.log(logLevel, throwable, (Function0<? extends Object>)function0);
        }

        public boolean isEnabled(@NotNull LogLevel level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return this.logLevel.compareTo((Enum)level) <= 0;
        }

        public void publish(@NotNull LogLevel messageLogLevel, @Nullable Throwable throwable, @Nullable String messageString) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageLogLevel), (String)"messageLogLevel");
            if (INSTANCE.getConsoleWriterEnabled()) {
                String loggerName = INSTANCE.getConsoleWriterSimpleClassName() ? StringsKt.substringAfterLast$default((String)this.name, (String)".", null, (int)2, null) : this.name;
                Object object = INSTANCE.getConsoleWriterFormat();
                Object[] objectArray = new Object[]{loggerName, messageLogLevel, messageString};
                boolean bl = false;
                String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(this, *args)");
                object = string;
                boolean bl2 = false;
                System.out.println(object);
                object = throwable;
                if (object != null) {
                    ((Throwable)object).printStackTrace(new PrintWriter(System.out, true));
                }
            }
        }

        public final void logWithCauseMessages(@NotNull Throwable throwable, @NotNull LogLevel logLevel) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                boolean bl = false;
                boolean bl2 = false;
                Throwable it = throwable3;
                boolean bl3 = false;
                this.logWithCauseMessages(it, logLevel);
            }
            Logger.log$default(this, logLevel, null, (Function0)new Function0<Object>(throwable){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = $throwable;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return String.valueOf(this.$throwable.getMessage());
                }
            }, 2, null);
        }

        public static /* synthetic */ void logWithCauseMessages$default(Logger logger, Throwable throwable, LogLevel logLevel, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logWithCauseMessages");
            }
            if ((n & 2) != 0) {
                logLevel = LogLevel.ERROR;
            }
            logger.logWithCauseMessages(throwable, logLevel);
        }

        @JvmOverloads
        public final void trace(@Nullable Throwable throwable) {
            Logger.trace$default(this, throwable, null, 2, null);
        }

        @JvmOverloads
        public final void trace() {
            Logger.trace$default(this, null, null, 3, null);
        }

        @JvmOverloads
        public final void debug(@Nullable Throwable throwable) {
            Logger.debug$default(this, throwable, null, 2, null);
        }

        @JvmOverloads
        public final void debug() {
            Logger.debug$default(this, null, null, 3, null);
        }

        @JvmOverloads
        public final void info(@Nullable Throwable throwable) {
            Logger.info$default(this, throwable, null, 2, null);
        }

        @JvmOverloads
        public final void info() {
            Logger.info$default(this, null, null, 3, null);
        }

        @JvmOverloads
        public final void warn(@Nullable Throwable throwable) {
            Logger.warn$default(this, throwable, null, 2, null);
        }

        @JvmOverloads
        public final void warn() {
            Logger.warn$default(this, null, null, 3, null);
        }

        @JvmOverloads
        public final void error(@Nullable Throwable throwable) {
            Logger.error$default(this, throwable, null, 2, null);
        }

        @JvmOverloads
        public final void error() {
            Logger.error$default(this, null, null, 3, null);
        }

        @JvmOverloads
        public final void log(@NotNull LogLevel messageLogLevel, @NotNull Function0<? extends Object> produceMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageLogLevel), (String)"messageLogLevel");
            Intrinsics.checkNotNullParameter(produceMessage, (String)"produceMessage");
            Logger.log$default(this, messageLogLevel, null, produceMessage, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lde/gmuth/log/Logging$Factory;", "", "getLogger", "Lde/gmuth/log/Logging$Logger;", "name", "", "ipp-client"})
    public static interface Factory {
        @NotNull
        public Logger getLogger(@NotNull String var1);
    }
}

