/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.configuration;

import de.governikus.panstar.sdk.saml.configuration.SamlConfiguration;
import de.governikus.panstar.sdk.utils.exception.InvalidInputException;
import org.apache.commons.lang3.StringUtils;

public final class SamlConfigurationHelper {
    private static final String MISSING_SAML_REQUEST_RECEIVER_URL = "SAML request receiver URL is missing.";
    private static final String INVALID_PROVIDER_CONFIGURATION = "Service provider configuration is invalid.";
    private static final String MISSING_KEY_MATERIAL = "Key material is missing.";

    private SamlConfigurationHelper() {
    }

    public static void checkSamlConfiguration(SamlConfiguration samlConfiguration) throws InvalidInputException {
        if (samlConfiguration.getSamlEidServerConfiguration() == null || StringUtils.isBlank((CharSequence)samlConfiguration.getSamlEidServerConfiguration().getSamlRequestReceiverUrl())) {
            throw new InvalidInputException(MISSING_SAML_REQUEST_RECEIVER_URL);
        }
        if (samlConfiguration.getSamlServiceProviderConfiguration() == null || StringUtils.isBlank((CharSequence)samlConfiguration.getSamlServiceProviderConfiguration().getSamlEntityId())) {
            throw new InvalidInputException(INVALID_PROVIDER_CONFIGURATION);
        }
        if (samlConfiguration.getSamlKeyMaterial() == null) {
            throw new InvalidInputException(MISSING_KEY_MATERIAL);
        }
        StringBuilder errorMessage = new StringBuilder();
        if (samlConfiguration.getSamlKeyMaterial().getSamlRequestEncryptionCertificate() == null) {
            errorMessage.append("Certificate for signing the SAML request is missing. ");
        }
        if (samlConfiguration.getSamlKeyMaterial().getSamlRequestSigningPrivateKey() == null) {
            errorMessage.append("Private key for signing the SAML request is missing. ");
        }
        if (samlConfiguration.getSamlKeyMaterial().getSamlResponseDecryptionKeyPair() == null) {
            errorMessage.append("Key pair for decrypting the SAML response is missing. ");
        }
        if (samlConfiguration.getSamlKeyMaterial().getSamlResponseSignatureValidatingCertificate() == null) {
            errorMessage.append("Certificate for validating the SAML response signature is missing. ");
        }
        if (!errorMessage.toString().isBlank()) {
            throw new InvalidInputException("Error while checking key material. " + errorMessage);
        }
    }
}

