/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.request;

import de.bund.bsi.eid240.AgeVerificationRequestType;
import de.bund.bsi.eid240.AttributeRequestType;
import de.bund.bsi.eid240.AuthnRequestExtension;
import de.bund.bsi.eid240.EIDTypeRequestType;
import de.bund.bsi.eid240.EidasExtensionType;
import de.bund.bsi.eid240.IdentityFlavourType;
import de.bund.bsi.eid240.PlaceVerificationRequestType;
import de.bund.bsi.eid240.RequestedAttributesType;
import de.bund.bsi.eid240.TransactionAttestationRequestType;
import de.governikus.panstar.sdk.saml.configuration.SamlKeyMaterial;
import de.governikus.panstar.sdk.saml.configuration.XmlConfiguration;
import de.governikus.panstar.sdk.saml.exception.SamlRequestException;
import de.governikus.panstar.sdk.utils.OperationsRequestorTypeExtension;
import de.governikus.panstar.sdk.utils.RequestData;
import de.governikus.panstar.sdk.utils.constant.EIDAttributeName;
import de.governikus.panstar.sdk.utils.saml.SamlEncrypterUtils;
import de.governikus.panstar.sdk.utils.xml.XmlUtils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import oasis.names.tc.saml._2_0.assertion.Attribute;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class AuthnRequestExtensionGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthnRequestExtensionGenerator.class);
    static final QName BSI_EXTENSION_QNAME = new QName("http://bsi.bund.de/eID/", "AuthnRequestExtension", "eid");
    private static final List<EIDAttributeName> EID_ATTRIBUTE_NAME_LIST = List.of(EIDAttributeName.TransactionInfo, EIDAttributeName.TransactionAttestation, EIDAttributeName.LevelOfAssurance, EIDAttributeName.EIDType, EIDAttributeName.EidasExtension, EIDAttributeName.IdentityFlavour, EIDAttributeName.UseEidas);
    private final JAXBContext jaxbContext;
    private final DocumentBuilder builder;
    private final XmlConfiguration xmlConfiguration;

    AuthnRequestExtensionGenerator(XmlConfiguration xmlConfiguration) throws SamlRequestException {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AuthnRequestExtension.class, AgeVerificationRequestType.class, PlaceVerificationRequestType.class, TransactionAttestationRequestType.class, EIDTypeRequestType.class, IdentityFlavourType.class, EidasExtensionType.class});
            this.xmlConfiguration = xmlConfiguration;
            this.builder = this.xmlConfiguration.getDocumentBuilderSupplier().get();
        }
        catch (Exception e) {
            throw new SamlRequestException("Could not init AuthnRequestExtensionGenerator", e);
        }
    }

    EncryptedData encryptAuthnRequestExtension(AuthnRequestExtension authnRequestExtension, SamlKeyMaterial samlKeyMaterial) throws SamlRequestException {
        EncryptedData encryptedData;
        Document doc = this.createDocumentFromAuthnRequestExtension(authnRequestExtension);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unencrypted AuthnRequestExtension: {}", (Object)XmlUtils.transformElement((Element)doc.getDocumentElement(), (Transformer)this.xmlConfiguration.getTransformerSupplier().get()));
            }
            encryptedData = SamlEncrypterUtils.getEncryptedData((Document)doc, (X509Certificate)samlKeyMaterial.getSamlRequestEncryptionCertificate());
        }
        catch (Exception e) {
            throw new SamlRequestException("Could not encrypt saml request.", e);
        }
        return encryptedData;
    }

    Document createDocumentFromAuthnRequestExtension(AuthnRequestExtension authnRequestExtension) throws SamlRequestException {
        Document doc;
        try {
            doc = this.builder.newDocument();
            Marshaller jaxMarshaller = this.jaxbContext.createMarshaller();
            jaxMarshaller.marshal((Object)authnRequestExtension, (Node)doc);
        }
        catch (Exception e) {
            throw new SamlRequestException("AuthnRequestExtension could not be marshalled", e);
        }
        return doc;
    }

    static AuthnRequestExtension createAuthnRequestExtension(RequestData requestData) {
        AuthnRequestExtension authnRequestExtension = new AuthnRequestExtension();
        authnRequestExtension.setVersion(BigInteger.valueOf(2L));
        OperationsRequestorTypeExtension useOperations = requestData.getUseOperations();
        RequestedAttributesType requestedAttributesType = new RequestedAttributesType();
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.AcademicTitle, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getAcademicTitle()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.ArtisticName, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getArtisticName()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.BirthName, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getBirthName()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.CommunityID, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getCommunityID()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.DateOfBirth, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getDateOfBirth()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.DateOfExpiry, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getDateOfExpiry()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.DocumentType, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getDocumentType()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.FamilyNames, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getFamilyNames()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.GivenNames, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getGivenNames()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.IssuingState, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getIssuingState()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.Nationality, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getNationality()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.PlaceOfBirth, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getPlaceOfBirth()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.PlaceOfResidence, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getPlaceOfResidence()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.ResidencePermitI, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getResidencePermitI()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.RestrictedID, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getRestrictedID()));
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.AgeVerification, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getAgeVerification()), requestData.getAgeVerificationRequest());
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.PlaceVerification, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getPlaceVerification()), requestData.getPlaceVerificationRequest());
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.TransactionInfo, requestData.getTransactionInfo() == null ? null : Boolean.TRUE, requestData.getTransactionInfo());
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.TransactionAttestation, requestData.getTransactionAttestationRequest() == null ? null : Boolean.TRUE, requestData.getTransactionAttestationRequest());
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.EIDType, requestData.getEidTypeRequest() == null ? null : Boolean.TRUE, requestData.getEidTypeRequest());
        if (requestData.getUseEidas()) {
            AuthnRequestExtensionGenerator.eidasRequestAttributes(requestData, useOperations, requestedAttributesType);
        } else {
            AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.LevelOfAssurance, requestData.getLevelOfAssuranceRequest() == null ? null : Boolean.TRUE, requestData.getLevelOfAssuranceRequest());
        }
        authnRequestExtension.setRequestedAttributes(requestedAttributesType);
        return authnRequestExtension;
    }

    private static void eidasRequestAttributes(RequestData requestData, OperationsRequestorTypeExtension useOperations, RequestedAttributesType requestedAttributesType) {
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.Sex, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getSex()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.LegalName, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getLegalName()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.LegalPersonIdentifier, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getLegalPersonIdentifier()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.LegalAddress, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getLegalAddress()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.VATRegistration, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getVatRegistration()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.TaxReference, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getTaxReference()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.BusinessCodes, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getBusinessCodes()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.LEI, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getLei()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.EORI, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getEori()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.SEED, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getSeed()));
        AuthnRequestExtensionGenerator.setAttribute(requestedAttributesType, EIDAttributeName.SIC, AuthnRequestExtensionGenerator.attributeRequired(useOperations.getSic()));
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.UseEidas, true, true);
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.IdentityFlavour, requestData.getIdentityFlavour() == null ? null : Boolean.TRUE, requestData.getIdentityFlavour());
        if (requestData.getLevelOfAssuranceRequest() != null || requestData.getSendingMemberState() != null) {
            EidasExtensionType eidasExtensionType = new EidasExtensionType();
            if (requestData.getLevelOfAssuranceRequest() != null) {
                eidasExtensionType.setLevelOfAssurance(requestData.getLevelOfAssuranceRequest());
            }
            if (requestData.getSendingMemberState() != null) {
                eidasExtensionType.setSendingMemberState(requestData.getSendingMemberState());
            }
            AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, EIDAttributeName.EidasExtension, true, eidasExtensionType);
        }
    }

    private static void setAttribute(RequestedAttributesType requestedAttributesType, EIDAttributeName name, Boolean required) {
        AuthnRequestExtensionGenerator.setAttributeWithAttributeValue(requestedAttributesType, name, required, null);
    }

    private static void setAttributeWithAttributeValue(RequestedAttributesType requestedAttributesType, EIDAttributeName name, Boolean required, Object attributeValue) {
        if (required != null) {
            Attribute attribute = new Attribute();
            attribute.setName(name.name());
            if (!EID_ATTRIBUTE_NAME_LIST.contains(name)) {
                attribute.getOtherAttributes().put(new QName(BSI_EXTENSION_QNAME.getNamespaceURI(), "RequiredAttribute", BSI_EXTENSION_QNAME.getPrefix()), required.toString());
            }
            if (attributeValue != null) {
                attribute.getAttributeValues().add(attributeValue);
            }
            requestedAttributesType.getAttributes().add(attribute);
        }
    }

    private static Boolean attributeRequired(AttributeRequestType type) {
        switch (type) {
            case ALLOWED: {
                return Boolean.FALSE;
            }
            case REQUIRED: {
                return Boolean.TRUE;
            }
        }
        return null;
    }
}

