/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.request;

import de.bund.bsi.eid240.AuthnRequestExtension;
import de.governikus.panstar.sdk.saml.configuration.SamlConfiguration;
import de.governikus.panstar.sdk.saml.configuration.XmlConfiguration;
import de.governikus.panstar.sdk.saml.exception.SamlRequestException;
import de.governikus.panstar.sdk.saml.request.AuthnRequestExtensionGenerator;
import de.governikus.panstar.sdk.saml.request.SamlRequestCreationInterceptor;
import de.governikus.panstar.sdk.utils.RequestData;
import de.governikus.panstar.sdk.utils.exception.InvalidInputException;
import de.governikus.panstar.sdk.utils.saml.SAMLUtils;
import de.governikus.panstar.sdk.utils.xml.XmlUtils;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.UUID;
import javax.xml.transform.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.impl.XSAnyBuilder;
import org.opensaml.core.xml.schema.impl.XSAnyUnmarshaller;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.ExtensionsBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AuthnRequestGenerator {
    private static final AuthnRequestMarshaller ARM = new AuthnRequestMarshaller();
    private static final Logger LOG = LoggerFactory.getLogger(AuthnRequestGenerator.class);
    private final SamlConfiguration samlConfiguration;
    private final SamlRequestCreationInterceptor interceptor;
    private final XmlConfiguration xmlConfiguration;
    private final AuthnRequestExtensionGenerator authnRequestExtensionGenerator;

    AuthnRequestGenerator(SamlConfiguration samlConfiguration, SamlRequestCreationInterceptor interceptor, XmlConfiguration xmlConfiguration) throws SamlRequestException {
        this.samlConfiguration = samlConfiguration;
        this.interceptor = interceptor;
        this.xmlConfiguration = xmlConfiguration;
        this.authnRequestExtensionGenerator = new AuthnRequestExtensionGenerator(xmlConfiguration);
    }

    AuthnRequest generateAuthnRequest(RequestData requestData, String authnRequestId) throws InvalidInputException, SamlRequestException {
        if (requestData == null) {
            throw new InvalidInputException("Request data may not be null.");
        }
        requestData.matchLoa();
        AuthnRequest request = new AuthnRequestBuilder().buildObject();
        if (StringUtils.isBlank((CharSequence)authnRequestId)) {
            request.setID("_" + UUID.randomUUID());
        } else {
            if (Character.isDigit(authnRequestId.charAt(0))) {
                throw new InvalidInputException("AuthnRequest IDs may not start with a number. Please change your AuthnRequest ID");
            }
            request.setID(authnRequestId);
        }
        request.setIssuer(new IssuerBuilder().buildObject());
        request.getIssuer().setValue(this.samlConfiguration.getSamlServiceProviderConfiguration().getSamlEntityId());
        request.setIssueInstant(Instant.now());
        request.setProviderName(this.samlConfiguration.getSamlServiceProviderConfiguration().getSamlEntityId());
        request.setDestination(this.samlConfiguration.getSamlEidServerConfiguration().getSamlRequestReceiverUrl());
        if (this.samlConfiguration.getSamlServiceProviderConfiguration().getSamlResponseReceiverUrl().isPresent()) {
            request.setAssertionConsumerServiceURL(this.samlConfiguration.getSamlServiceProviderConfiguration().getSamlResponseReceiverUrl().get().toString());
        }
        Extensions extensions = new ExtensionsBuilder().buildObject();
        AuthnRequestExtension authnRequestExtension = AuthnRequestExtensionGenerator.createAuthnRequestExtension(requestData);
        XSAny encryptedAuthnRequestExtension = new XSAnyBuilder().buildObject(AuthnRequestExtensionGenerator.BSI_EXTENSION_QNAME.getNamespaceURI(), "Encrypted" + AuthnRequestExtensionGenerator.BSI_EXTENSION_QNAME.getLocalPart(), AuthnRequestExtensionGenerator.BSI_EXTENSION_QNAME.getPrefix());
        if (this.interceptor.isDoNotEncryptExtensions()) {
            Document doc = this.authnRequestExtensionGenerator.createDocumentFromAuthnRequestExtension(authnRequestExtension);
            try {
                encryptedAuthnRequestExtension.getUnknownXMLObjects().add(new XSAnyUnmarshaller().unmarshall(doc.getDocumentElement()));
            }
            catch (UnmarshallingException e) {
                throw new SamlRequestException("Could not unmarshall xml object.", e);
            }
        } else {
            EncryptedData encryptedData = this.authnRequestExtensionGenerator.encryptAuthnRequestExtension(authnRequestExtension, this.samlConfiguration.getSamlKeyMaterial());
            encryptedAuthnRequestExtension.getUnknownXMLObjects().add(encryptedData);
        }
        extensions.getUnknownXMLObjects().add(encryptedAuthnRequestExtension);
        request.setExtensions(extensions);
        return request;
    }

    Element marshallAuthnRequest(AuthnRequest request) throws SamlRequestException {
        try {
            return ARM.marshall((XMLObject)request);
        }
        catch (Exception e) {
            throw new SamlRequestException("Unable to marshall saml request", e);
        }
    }

    String deflateAuthnRequest(Element requestElement) throws SamlRequestException {
        try {
            String arg = XmlUtils.transformElement((Element)requestElement, (Transformer)this.xmlConfiguration.getTransformerSupplier().get());
            LOG.debug("Request: {}", (Object)arg);
            return SAMLUtils.deflate((byte[])arg.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SamlRequestException("Unable to transform saml request", e);
        }
    }
}

