/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.request;

import java.util.function.Function;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.w3c.dom.Element;

public class SamlRequestCreationInterceptor {
    private Function<AuthnRequest, AuthnRequest> authnRequestModifier = Function.identity();
    private Function<String, String> newSignatureDigestAlgo = Function.identity();
    private Function<Element, Element> marshalledAuthnRequestModifier = Function.identity();
    private Function<String, String> deflatedRequestModifier = Function.identity();
    private boolean doNotEncryptExtensions;

    public SamlRequestCreationInterceptor modifyAuthnRequest(Function<AuthnRequest, AuthnRequest> modifier) {
        this.authnRequestModifier = modifier;
        return this;
    }

    public SamlRequestCreationInterceptor modifySignatureDigestAlgo(Function<String, String> newSignatureDigestAlgo) {
        this.newSignatureDigestAlgo = newSignatureDigestAlgo;
        return this;
    }

    public SamlRequestCreationInterceptor modifyMarshalledAuthnRequest(Function<Element, Element> modifier) {
        this.marshalledAuthnRequestModifier = modifier;
        return this;
    }

    public SamlRequestCreationInterceptor modifyDeflatedRequest(Function<String, String> modifier) {
        this.deflatedRequestModifier = modifier;
        return this;
    }

    public SamlRequestCreationInterceptor doNotEncryptExtensions(boolean doNotEncryptExtensions) {
        this.doNotEncryptExtensions = doNotEncryptExtensions;
        return this;
    }

    public void reset() {
        this.authnRequestModifier = Function.identity();
        this.newSignatureDigestAlgo = Function.identity();
        this.marshalledAuthnRequestModifier = Function.identity();
        this.deflatedRequestModifier = Function.identity();
        this.doNotEncryptExtensions = false;
    }

    Function<AuthnRequest, AuthnRequest> getAuthnRequestModifier() {
        return this.authnRequestModifier;
    }

    Function<String, String> getNewSignatureDigestAlgo() {
        return this.newSignatureDigestAlgo;
    }

    Function<Element, Element> getMarshalledAuthnRequestModifier() {
        return this.marshalledAuthnRequestModifier;
    }

    Function<String, String> getDeflatedRequestModifier() {
        return this.deflatedRequestModifier;
    }

    boolean isDoNotEncryptExtensions() {
        return this.doNotEncryptExtensions;
    }
}

