/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.request;

import de.governikus.panstar.sdk.saml.SamlInitializer;
import de.governikus.panstar.sdk.saml.configuration.SamlConfiguration;
import de.governikus.panstar.sdk.saml.configuration.SamlConfigurationHelper;
import de.governikus.panstar.sdk.saml.configuration.XmlConfiguration;
import de.governikus.panstar.sdk.saml.exception.SamlRequestException;
import de.governikus.panstar.sdk.saml.request.AuthnRequestGenerator;
import de.governikus.panstar.sdk.saml.request.SamlRequestCreationInterceptor;
import de.governikus.panstar.sdk.utils.RequestData;
import de.governikus.panstar.sdk.utils.exception.InvalidInputException;
import de.governikus.panstar.sdk.utils.saml.SAMLUtils;
import de.governikus.panstar.sdk.utils.xml.XMLSignatureHandler;
import de.governikus.panstar.sdk.utils.xml.XmlUtils;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import javax.xml.transform.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.core.config.InitializationException;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Element;

public class SamlRequestGenerator {
    private final SamlConfiguration samlConfiguration;
    private final XmlConfiguration xmlConfiguration;
    private final AuthnRequestGenerator authnRequestGenerator;
    private final SamlRequestCreationInterceptor interceptor;

    public SamlRequestGenerator(SamlConfiguration samlConfiguration) throws InvalidInputException, InitializationException, SamlRequestException {
        this.samlConfiguration = samlConfiguration;
        this.xmlConfiguration = new XmlConfiguration();
        SamlConfigurationHelper.checkSamlConfiguration(this.samlConfiguration);
        SamlInitializer.initialize();
        this.interceptor = new SamlRequestCreationInterceptor();
        this.authnRequestGenerator = new AuthnRequestGenerator(this.samlConfiguration, this.interceptor, this.xmlConfiguration);
    }

    public SamlRequestGenerator(SamlConfiguration samlConfiguration, XmlConfiguration xmlConfiguration) throws InvalidInputException, InitializationException, SamlRequestException {
        this.samlConfiguration = samlConfiguration;
        this.xmlConfiguration = xmlConfiguration;
        SamlConfigurationHelper.checkSamlConfiguration(this.samlConfiguration);
        SamlInitializer.initialize();
        this.interceptor = new SamlRequestCreationInterceptor();
        this.authnRequestGenerator = new AuthnRequestGenerator(this.samlConfiguration, this.interceptor, xmlConfiguration);
    }

    public String createSamlRequestUrl(RequestData requestData) throws InvalidInputException, SamlRequestException {
        return this.createSamlRequestUrl(requestData, null, null);
    }

    public String createSamlRequestUrl(RequestData requestData, String relayState) throws InvalidInputException, SamlRequestException {
        return this.createSamlRequestUrl(requestData, relayState, null);
    }

    public String createSamlRequestUrl(RequestData requestData, String relayState, String authnRequestId) throws InvalidInputException, SamlRequestException {
        if (requestData == null) {
            throw new InvalidInputException("Request data may not be null.");
        }
        if (requestData.getUseEidas()) {
            throw new InvalidInputException("If eID authentication is used, the useEidas attribute must be set to false. Don't call the RequestData.useEidas() method.");
        }
        if (StringUtils.isWhitespace((CharSequence)relayState)) {
            throw new InvalidInputException("RelayState contains only whitespaces.");
        }
        if (StringUtils.isNotBlank((CharSequence)relayState) && relayState.getBytes(StandardCharsets.UTF_8).length > 80) {
            throw new InvalidInputException("RelayState may not exceed 80 bytes.");
        }
        AuthnRequest request = this.authnRequestGenerator.generateAuthnRequest(requestData, authnRequestId);
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        return this.marshallAndSignEidRequest(relayState, request);
    }

    public String createEidasSamlRequest(RequestData requestData) throws InvalidInputException, SamlRequestException {
        return this.createEidasSamlRequest(requestData, null);
    }

    public String createEidasSamlRequest(RequestData requestData, String authnRequestId) throws InvalidInputException, SamlRequestException {
        if (requestData == null) {
            throw new InvalidInputException("Request data may not be null.");
        }
        if (!requestData.getUseEidas()) {
            throw new InvalidInputException("If eIDAS authentication is used, the useEidas attribute must be set to true by calling the RequestData.useEidas() method.");
        }
        AuthnRequest request = this.authnRequestGenerator.generateAuthnRequest(requestData, authnRequestId);
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        return this.marshallAndSignEidasRequest(request);
    }

    private String marshallAndSignEidasRequest(AuthnRequest request) throws SamlRequestException {
        String encodedRequest;
        try {
            XMLSignatureHandler.addSignature((SignableXMLObject)request, (PrivateKey)this.samlConfiguration.getSamlKeyMaterial().getSamlRequestSigningPrivateKey(), (X509Certificate)this.samlConfiguration.getSamlKeyMaterial().getSamlRequestEncryptionCertificate(), (XMLSignatureHandler.SigEntryType)XMLSignatureHandler.SigEntryType.CERTIFICATE);
            ArrayList<Signature> sigs = new ArrayList<Signature>();
            sigs.add(request.getSignature());
            Element requestElement = this.authnRequestGenerator.marshallAuthnRequest(request);
            Signer.signObjects(sigs);
            encodedRequest = Base64.getMimeEncoder().encodeToString(XmlUtils.transformElement((Element)requestElement, (Transformer)this.xmlConfiguration.getTransformerSupplier().get()).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SamlRequestException("Unable to marshall saml request", e);
        }
        return encodedRequest;
    }

    private String marshallAndSignEidRequest(String relayState, AuthnRequest request) throws SamlRequestException {
        String requestUrl;
        request = this.interceptor.getAuthnRequestModifier().apply(request);
        Element requestElement = this.authnRequestGenerator.marshallAuthnRequest(request);
        requestElement = this.interceptor.getMarshalledAuthnRequestModifier().apply(requestElement);
        String deflatedRequest = this.authnRequestGenerator.deflateAuthnRequest(requestElement);
        deflatedRequest = this.interceptor.getDeflatedRequestModifier().apply(deflatedRequest);
        try {
            requestUrl = SAMLUtils.signQueryParameter((String)this.samlConfiguration.getSamlEidServerConfiguration().getSamlRequestReceiverUrl(), (boolean)true, (String)deflatedRequest, (String)relayState, (PrivateKey)this.samlConfiguration.getSamlKeyMaterial().getSamlRequestSigningPrivateKey(), (String)this.interceptor.getNewSignatureDigestAlgo().apply("SHA-256"));
        }
        catch (Exception e) {
            throw new SamlRequestException("Could not generate saml request url.", e);
        }
        return requestUrl;
    }

    public SamlRequestCreationInterceptor getSamlRequestCreationInterceptor() {
        return this.interceptor;
    }
}

