/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.response;

import de.governikus.panstar.sdk.saml.exception.SamlAuthenticationException;
import de.governikus.panstar.sdk.utils.constant.EIDAttributeName;
import de.governikus.panstar.sdk.utils.xml.XmlUtils;
import jakarta.xml.bind.DatatypeConverter;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.datatype.DatatypeConfigurationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextDecl;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParsedAssertion {
    private static final Logger LOG = LoggerFactory.getLogger(ParsedAssertion.class);
    private final Assertion assertion;
    private final Conditions conditions;
    private final Subject subject;
    private final Map<String, Object[]> attributes = new HashMap<String, Object[]>();
    private final Set<String> attributesNotOnChip = new TreeSet<String>();

    ParsedAssertion(Assertion assertion, boolean doCheckTime) throws SamlAuthenticationException {
        this.assertion = assertion;
        this.conditions = assertion.getConditions();
        this.subject = assertion.getSubject();
        if (doCheckTime) {
            this.checkTimeFromConditions();
        }
        for (AttributeStatement ast : assertion.getAttributeStatements()) {
            for (Attribute attrib : ast.getAttributes()) {
                Node node = attrib.getDOM().getAttributes().getNamedItem("AttributeNotOnChip");
                if (node != null && Boolean.parseBoolean(node.getNodeValue())) {
                    this.attributesNotOnChip.add(attrib.getName());
                    continue;
                }
                this.attributes.put(attrib.getName(), attrib.getAttributeValues().stream().map(ParsedAssertion::translateXMLObject).toArray());
            }
        }
    }

    private static Object translateXMLObject(XMLObject xml) {
        String schemaType;
        if (xml instanceof XSString) {
            XSString xsString = (XSString)xml;
            return ParsedAssertion.translateToXSString(xsString);
        }
        if (xml instanceof XSBoolean) {
            XSBoolean xsBoolean = (XSBoolean)xml;
            return ParsedAssertion.translateToXSBoolean(xsBoolean);
        }
        if (!(xml instanceof XSAny)) {
            LOG.debug("cannot parse element of type {}", (Object)xml.getClass().getName());
            return xml;
        }
        XSAny any = (XSAny)xml;
        String string = schemaType = any.getSchemaType() == null ? null : any.getSchemaType().getLocalPart();
        if ("hexbinary".equals(schemaType)) {
            return ParsedAssertion.translateBase64ToBytes(any);
        }
        if ("date".equals(schemaType)) {
            try {
                return XmlUtils.toXmlGregorianCalendar((String)any.getTextContent());
            }
            catch (DatatypeConfigurationException e) {
                LOG.debug("Wrong format of date in tag {}: {}", (Object)any.getElementQName().getLocalPart(), (Object)any.getTextContent());
                return xml;
            }
        }
        if (EIDAttributeName.Nationality.getQName().getLocalPart().equals(schemaType) || EIDAttributeName.DocumentType.getQName().getLocalPart().equals(schemaType) || EIDAttributeName.Sex.getQName().getLocalPart().equals(schemaType) || EIDAttributeName.LevelOfAssurance.getQName().getLocalPart().equals(schemaType) || EIDAttributeName.IdentityFlavour.getQName().getLocalPart().equals(schemaType) || EIDAttributeName.CommunityID.getQName().getLocalPart().equals(schemaType)) {
            return any.getTextContent();
        }
        if (any.hasChildren()) {
            return ParsedAssertion.translateChildren(any);
        }
        if (schemaType == null) {
            return any.getTextContent();
        }
        LOG.debug("cannot parse element of type {} \n QName: {} Textcontent: {} Schema: {} SchemaType: {}", new Object[]{xml.getClass().getName(), any.getElementQName(), any.getTextContent(), any.getSchemaType(), schemaType});
        return xml;
    }

    private static Map<String, Object> translateChildren(XSAny any) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (XMLObject child : any.getOrderedChildren()) {
            value.put(child.getDOM().getLocalName(), ParsedAssertion.translateXMLObject(child));
        }
        return value;
    }

    private static Serializable translateBase64ToBytes(XSAny any) {
        if (any.getTextContent() == null) {
            return null;
        }
        return DatatypeConverter.parseHexBinary((String)any.getTextContent());
    }

    private static String translateToXSString(XSString xsString) {
        if (Boolean.TRUE.equals(xsString.isNil())) {
            return null;
        }
        if (xsString.getValue() == null) {
            return "";
        }
        return xsString.getValue();
    }

    private static String translateToXSBoolean(XSBoolean xml) {
        if (xml.getValue() == null || xml.getValue().getValue() == null) {
            return null;
        }
        return xml.getValue().getValue().toString();
    }

    private void checkTimeFromConditions() throws SamlAuthenticationException {
        if (this.conditions == null) {
            return;
        }
        Instant currentTime = Instant.now();
        if (this.conditions.getNotBefore() != null && currentTime.plusSeconds(10L).isBefore(this.conditions.getNotBefore())) {
            throw new SamlAuthenticationException("Assertion outdated! notbefore: " + this.conditions.getNotBefore());
        }
        if (this.conditions.getNotOnOrAfter() != null && currentTime.isAfter(this.conditions.getNotOnOrAfter())) {
            throw new SamlAuthenticationException("Assertion outdated! notOnOrAfter: " + this.conditions.getNotOnOrAfter());
        }
    }

    public Object[] getAttributeValue(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean isNotOnChip(String attributeName) {
        return this.attributesNotOnChip.contains(attributeName);
    }

    public String getIssuer() {
        if (this.assertion.getIssuer() != null) {
            return this.assertion.getIssuer().getValue();
        }
        return null;
    }

    public SubjectConfirmation getSubjectConfirmation() {
        if (this.subject.getSubjectConfirmations() == null || this.subject.getSubjectConfirmations().size() != 1) {
            return null;
        }
        return (SubjectConfirmation)this.subject.getSubjectConfirmations().get(0);
    }

    public SubjectConfirmationData getSubjectConfirmationData() {
        SubjectConfirmation subjectConfirmation = this.getSubjectConfirmation();
        if (subjectConfirmation == null) {
            return null;
        }
        return subjectConfirmation.getSubjectConfirmationData();
    }

    public String getSubjectName() {
        if (this.subject == null || this.subject.getNameID() == null) {
            return null;
        }
        return this.subject.getNameID().getValue();
    }

    public String getNameFormat() {
        if (this.subject == null || this.subject.getNameID() == null) {
            return null;
        }
        return this.subject.getNameID().getFormat();
    }

    public String getAddress() {
        SubjectConfirmationData subjectConfirmationData = this.getSubjectConfirmationData();
        if (subjectConfirmationData == null) {
            return null;
        }
        return subjectConfirmationData.getAddress();
    }

    public String getInResponseTo() {
        SubjectConfirmationData subjectConfirmationData = this.getSubjectConfirmationData();
        if (subjectConfirmationData == null) {
            return null;
        }
        return subjectConfirmationData.getInResponseTo();
    }

    public String getRecipient() {
        SubjectConfirmationData subjectConfirmationData = this.getSubjectConfirmationData();
        if (subjectConfirmationData == null) {
            return null;
        }
        return subjectConfirmationData.getRecipient();
    }

    public Instant getNotOnOrAfter() {
        SubjectConfirmationData subjectConfirmationData = this.getSubjectConfirmationData();
        if (subjectConfirmationData == null || subjectConfirmationData.getNotOnOrAfter() == null) {
            return null;
        }
        return subjectConfirmationData.getNotOnOrAfter();
    }

    public String getMethod() {
        SubjectConfirmation subjectConfirmation = this.getSubjectConfirmation();
        if (subjectConfirmation == null) {
            return null;
        }
        return subjectConfirmation.getMethod();
    }

    public String getAuthnContextDeclRef() {
        for (AuthnStatement ast : this.assertion.getAuthnStatements()) {
            AuthnContextDeclRef acdr = ast.getAuthnContext().getAuthnContextDeclRef();
            if (acdr == null) continue;
            return acdr.getURI();
        }
        return null;
    }

    public String getAuthnContextClassRef() {
        for (AuthnStatement ast : this.assertion.getAuthnStatements()) {
            AuthnContextClassRef accr = ast.getAuthnContext().getAuthnContextClassRef();
            if (accr == null) continue;
            return accr.getURI();
        }
        return null;
    }

    @Deprecated(since="4.1.0")
    public Element getAuthContextDecl() {
        for (AuthnStatement ast : this.assertion.getAuthnStatements()) {
            AuthnContextDecl acd = ast.getAuthnContext().getAuthContextDecl();
            if (acd == null) continue;
            return acd.getDOM();
        }
        return null;
    }

    public List<String> getAudienceRestrictions() {
        ArrayList<String> audienceRestrictions = new ArrayList<String>();
        if (this.conditions == null || this.conditions.getAudienceRestrictions() == null) {
            return audienceRestrictions;
        }
        for (AudienceRestriction restriction : this.conditions.getAudienceRestrictions()) {
            for (Audience audience : restriction.getAudiences()) {
                audienceRestrictions.add(audience.getURI());
            }
        }
        return audienceRestrictions;
    }

    public List<String> getAuthenticatingAuthorities() {
        LinkedList<String> result = new LinkedList<String>();
        for (AuthnStatement ast : this.assertion.getAuthnStatements()) {
            AuthnContext authnContext = ast.getAuthnContext();
            if (authnContext == null) continue;
            for (AuthenticatingAuthority entry : authnContext.getAuthenticatingAuthorities()) {
                result.add(entry.getURI());
            }
        }
        return result;
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public Map<String, Object[]> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

