/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.response;

import de.governikus.panstar.sdk.saml.exception.SamlAuthenticationException;
import de.governikus.panstar.sdk.saml.response.ParsedAssertion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;

public class ParsedResponse {
    private final Response response;
    private final ParsedAssertion assertion;

    public ParsedResponse(Response response, boolean doCheckTime) throws SamlAuthenticationException {
        this.response = response;
        this.assertion = response.getAssertions().isEmpty() ? null : new ParsedAssertion((Assertion)response.getAssertions().get(0), doCheckTime);
    }

    public boolean isStatusSuccess() {
        return "urn:oasis:names:tc:SAML:2.0:status:Success".equals(this.response.getStatus().getStatusCode().getValue());
    }

    public String getStatusCode() {
        return this.response.getStatus().getStatusCode().getValue();
    }

    public String getMinorStatusCode() {
        StatusCode minorCode = this.response.getStatus().getStatusCode().getStatusCode();
        return minorCode == null ? null : minorCode.getValue();
    }

    public String getStatusMessage() {
        StatusMessage msg = this.response.getStatus().getStatusMessage();
        return msg == null ? null : msg.getValue();
    }

    public Response getResponse() {
        return this.response;
    }

    public ParsedAssertion getAssertion() {
        return this.assertion;
    }
}

