/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.response;

import de.bund.bsi.eid240.OperationsResponderType;
import de.bund.bsi.eid240.PersonalDataType;
import de.governikus.panstar.sdk.saml.exception.SamlAuthenticationException;
import de.governikus.panstar.sdk.saml.exception.UnsuccessfulSamlAuthenticationProcessException;
import de.governikus.panstar.sdk.saml.response.EidasLegalPersonData;
import de.governikus.panstar.sdk.saml.response.EidasLegalPersonOperationsResponderType;
import de.governikus.panstar.sdk.saml.response.EidasNaturalPersonData;
import de.governikus.panstar.sdk.saml.response.EidasNaturalPersonOperationsResponderType;
import de.governikus.panstar.sdk.saml.response.Gender;
import de.governikus.panstar.sdk.saml.response.ParsedResponse;
import de.governikus.panstar.sdk.saml.response.ProcessedSamlResult;
import de.governikus.panstar.sdk.utils.constant.EIDAttributeName;
import de.governikus.panstar.sdk.utils.constant.LevelOfAssuranceType;
import java.util.HashMap;
import java.util.Map;

public class ProcessedSamlEidasResult
extends ProcessedSamlResult {
    private static final long serialVersionUID = 1L;
    private final EidasLegalPersonData eidasLegalPersonData = this.buildLegalPersonData();
    private final EidasLegalPersonOperationsResponderType eidasLegalPersonOperationsAllowedByUser = this.buildEidasLegalPersonOperationResponderType();

    ProcessedSamlEidasResult(ParsedResponse response) throws UnsuccessfulSamlAuthenticationProcessException, SamlAuthenticationException {
        super(response);
        this.setPersonalData(this.buildPersonalDataType(new EidasNaturalPersonData()));
        this.setOperationsAllowedByUser(this.buildOperationsResponderType(new EidasNaturalPersonOperationsResponderType()));
    }

    private EidasLegalPersonData buildLegalPersonData() {
        return new EidasLegalPersonData(this.getFirstString(EIDAttributeName.LegalName), this.getFirstString(EIDAttributeName.LegalPersonIdentifier), ProcessedSamlEidasResult.toGeneralPlaceType(this.extractMap(EIDAttributeName.LegalAddress)), this.getFirstString(EIDAttributeName.VATRegistration), this.getFirstString(EIDAttributeName.TaxReference), this.getFirstString(EIDAttributeName.BusinessCodes), this.getFirstString(EIDAttributeName.LEI), this.getFirstString(EIDAttributeName.EORI), this.getFirstString(EIDAttributeName.SEED), this.getFirstString(EIDAttributeName.SIC));
    }

    public String getIdentityFlavour() {
        return (String)this.assertion.getAttributes().get(EIDAttributeName.IdentityFlavour.name())[0];
    }

    public String getSendingMemberState() {
        return this.getEidasExtentionValuesAsMap().getOrDefault("SendingMemberState", null);
    }

    public LevelOfAssuranceType getReceivedLevelOfAssurance() {
        return LevelOfAssuranceType.byUri((String)this.getEidasExtentionValuesAsMap().getOrDefault("LevelOfAssurance", null)).orElse(null);
    }

    private Map<String, String> getEidasExtentionValuesAsMap() {
        Object[] eidasExtensionAttributes = this.assertion.getAttributes().get(EIDAttributeName.EidasExtension.name());
        if (eidasExtensionAttributes == null || eidasExtensionAttributes.length == 0) {
            return new HashMap<String, String>();
        }
        return (HashMap)eidasExtensionAttributes[0];
    }

    private PersonalDataType buildPersonalDataType(EidasNaturalPersonData personalDataType) {
        super.buildPersonalDataType(personalDataType);
        personalDataType.setSex(Gender.findByPanstarResponseValue(this.getFirstString(EIDAttributeName.Sex)));
        return personalDataType;
    }

    private OperationsResponderType buildOperationsResponderType(EidasNaturalPersonOperationsResponderType operationsResponderType) {
        super.buildOperationsResponderType(operationsResponderType);
        operationsResponderType.setSex(this.toAttributeResponderType(EIDAttributeName.Sex));
        return operationsResponderType;
    }

    private EidasLegalPersonOperationsResponderType buildEidasLegalPersonOperationResponderType() {
        EidasLegalPersonOperationsResponderType operationsResponderType = new EidasLegalPersonOperationsResponderType();
        operationsResponderType.setName(this.toAttributeResponderType(EIDAttributeName.LegalName));
        operationsResponderType.setPersonIdentifier(this.toAttributeResponderType(EIDAttributeName.LegalPersonIdentifier));
        operationsResponderType.setAddress(this.toAttributeResponderType(EIDAttributeName.LegalAddress));
        operationsResponderType.setVatRegistration(this.toAttributeResponderType(EIDAttributeName.VATRegistration));
        operationsResponderType.setTaxReference(this.toAttributeResponderType(EIDAttributeName.TaxReference));
        operationsResponderType.setBusinessCodes(this.toAttributeResponderType(EIDAttributeName.BusinessCodes));
        operationsResponderType.setLegalEntityIdentifier(this.toAttributeResponderType(EIDAttributeName.LEI));
        operationsResponderType.setEconomicOperatorRegistrationAndIdentification(this.toAttributeResponderType(EIDAttributeName.EORI));
        operationsResponderType.setSystemForExchangeOfExciseData(this.toAttributeResponderType(EIDAttributeName.SEED));
        operationsResponderType.setStandardIndustrialClassification(this.toAttributeResponderType(EIDAttributeName.SIC));
        return operationsResponderType;
    }

    public EidasLegalPersonData getLegalPersonData() {
        return this.eidasLegalPersonData;
    }

    public EidasLegalPersonOperationsResponderType getEidasLegalPersonOperationsAllowedByUser() {
        return this.eidasLegalPersonOperationsAllowedByUser;
    }

    public EidasNaturalPersonData getEidasNaturalPersonData() {
        return (EidasNaturalPersonData)this.getPersonalData();
    }

    public EidasNaturalPersonOperationsResponderType getEidasNaturalPersonOperationsAllowedByUser() {
        return (EidasNaturalPersonOperationsResponderType)this.getOperationsAllowedByUser();
    }
}

