/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.response;

import de.bund.bsi.eid240.AttributeResponseType;
import de.bund.bsi.eid240.EIDTypeResponseType;
import de.bund.bsi.eid240.EIDTypeUsedType;
import de.bund.bsi.eid240.GeneralDateType;
import de.bund.bsi.eid240.GeneralPlaceType;
import de.bund.bsi.eid240.GetResultResponse;
import de.bund.bsi.eid240.OperationsResponderType;
import de.bund.bsi.eid240.PersonalDataType;
import de.bund.bsi.eid240.PlaceType;
import de.bund.bsi.eid240.RestrictedIDType;
import de.bund.bsi.eid240.TransactionAttestationResponseType;
import de.bund.bsi.eid240.VerificationResultType;
import de.governikus.panstar.sdk.saml.exception.SamlAuthenticationException;
import de.governikus.panstar.sdk.saml.exception.UnsuccessfulSamlAuthenticationProcessException;
import de.governikus.panstar.sdk.saml.response.DocumentValidityResult;
import de.governikus.panstar.sdk.saml.response.ParsedAssertion;
import de.governikus.panstar.sdk.saml.response.ParsedResponse;
import de.governikus.panstar.sdk.utils.constant.Common;
import de.governikus.panstar.sdk.utils.constant.EIDAttributeName;
import de.governikus.panstar.sdk.utils.constant.SamlError;
import de.governikus.panstar.sdk.utils.xml.XmlUtils;
import jakarta.xml.bind.DatatypeConverter;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBElement;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.dom.DOMResult;
import oasis.names.tc.dss._1_0.core.schema.AnyType;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessedSamlResult
extends GetResultResponse {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessedSamlResult.class);
    private static final long serialVersionUID = 1L;
    private final String samlResponseID;
    private final String inResponseTo;
    private final Instant issueInstant;
    private final String destination;
    final transient ParsedAssertion assertion;
    private final String placeVerificationReferenceValue;
    private final String ageVerificationReferenceValue;
    private final DocumentValidityResult documentValidityResult;

    ProcessedSamlResult(ParsedResponse response) throws UnsuccessfulSamlAuthenticationProcessException, SamlAuthenticationException {
        this.samlResponseID = response.getResponse().getID();
        this.inResponseTo = response.getResponse().getInResponseTo();
        this.issueInstant = response.getResponse().getIssueInstant();
        this.destination = response.getResponse().getDestination();
        this.assertion = response.getAssertion();
        Result result = new Result();
        result.setResultMajor(response.getStatusCode());
        if (!response.isStatusSuccess()) {
            String minorStatusCode = response.getMinorStatusCode();
            SamlError samlError = SamlError.getSamlErrorFromMinorStatusCode((String)minorStatusCode);
            result.setResultMinor(minorStatusCode);
            if (response.getStatusMessage() != null) {
                InternationalStringType ist = new InternationalStringType();
                ist.setLang("EN");
                ist.setValue(response.getStatusMessage());
                result.setResultMessage(ist);
            }
            throw new UnsuccessfulSamlAuthenticationProcessException("Result was not success but was: " + result.getResultMajor(), result, samlError, this.samlResponseID, this.inResponseTo, this.issueInstant, this.destination);
        }
        this.setPersonalData(this.buildPersonalDataType(new PersonalDataType()));
        this.setFulfilsAgeVerification(this.buildVerificationResultType(EIDAttributeName.AgeVerification));
        this.ageVerificationReferenceValue = this.getVerificationRequestValue(EIDAttributeName.AgeVerification);
        this.setFulfilsPlaceVerification(this.buildVerificationResultType(EIDAttributeName.PlaceVerification));
        this.placeVerificationReferenceValue = this.getVerificationRequestValue(EIDAttributeName.PlaceVerification);
        this.setOperationsAllowedByUser(this.buildOperationsResponderType(new OperationsResponderType()));
        this.setTransactionAttestationResponse(this.buildTransactionAttestationResponseType());
        this.setLevelOfAssuranceResult(this.getFirstString(EIDAttributeName.LevelOfAssurance));
        this.setEIDTypeResponse(this.buildEIDTypeResponseType());
        this.documentValidityResult = this.buildDocumentValidityResultType();
        this.setResult(result);
    }

    private DocumentValidityResult buildDocumentValidityResultType() {
        Map<String, Object> map = this.extractMap(EIDAttributeName.DocumentValidity);
        if (map == null || map.isEmpty()) {
            return null;
        }
        return new DocumentValidityResult(LocalDate.parse((String)map.get("ReferenceDate")), DocumentValidityResult.DocumentValidityStatus.valueOf(((String)map.get("Status")).toUpperCase()));
    }

    PersonalDataType buildPersonalDataType(PersonalDataType personalDataType) {
        personalDataType.setDocumentType(this.getFirstString(EIDAttributeName.DocumentType));
        personalDataType.setIssuingState(this.getFirstString(EIDAttributeName.IssuingState));
        personalDataType.setDateOfExpiry(this.getDateOfExpiry());
        personalDataType.setGivenNames(this.getFirstString(EIDAttributeName.GivenNames));
        personalDataType.setFamilyNames(this.getFirstString(EIDAttributeName.FamilyNames));
        personalDataType.setArtisticName(this.getFirstString(EIDAttributeName.ArtisticName));
        personalDataType.setAcademicTitle(this.getFirstString(EIDAttributeName.AcademicTitle));
        personalDataType.setDateOfBirth(this.getDateOfBirth());
        personalDataType.setPlaceOfBirth(ProcessedSamlResult.toGeneralPlaceType(this.extractMap(EIDAttributeName.PlaceOfBirth)));
        personalDataType.setNationality(this.getFirstString(EIDAttributeName.Nationality));
        personalDataType.setBirthName(this.getFirstString(EIDAttributeName.BirthName));
        personalDataType.setPlaceOfResidence(ProcessedSamlResult.toGeneralPlaceType(this.extractMap(EIDAttributeName.PlaceOfResidence)));
        personalDataType.setCommunityID(this.getFirstString(EIDAttributeName.CommunityID));
        personalDataType.setResidencePermitI(this.getFirstString(EIDAttributeName.ResidencePermitI));
        personalDataType.setRestrictedID(this.getRestrictedID());
        return personalDataType;
    }

    private XMLGregorianCalendar getDateOfExpiry() {
        Object result = this.getFirstValue(EIDAttributeName.DateOfExpiry);
        if (result instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar c = (XMLGregorianCalendar)result;
            return c;
        }
        return null;
    }

    private GeneralDateType getDateOfBirth() {
        Map<String, Object> map = this.extractMap(EIDAttributeName.DateOfBirth);
        if (map == null || map.isEmpty()) {
            return null;
        }
        GeneralDateType generalDateType = new GeneralDateType();
        generalDateType.setDateString((String)map.get("DateString"));
        try {
            generalDateType.setDateValue(XmlUtils.toXmlGregorianCalendar((String)((String)map.get("DateValue"))));
        }
        catch (IllegalArgumentException | DatatypeConfigurationException e) {
            LOG.debug("cannot process dateValue, use dateString only", (Throwable)e);
        }
        return generalDateType;
    }

    static GeneralPlaceType toGeneralPlaceType(Map<String, Object> place) {
        if (place == null || place.isEmpty()) {
            return null;
        }
        GeneralPlaceType generalPlaceType = new GeneralPlaceType();
        Map structuredValues = (Map)place.get("StructuredPlace");
        if (structuredValues != null) {
            PlaceType placeType = new PlaceType();
            placeType.setCity(StringUtils.trim((String)((String)structuredValues.get("City"))));
            placeType.setCountry(StringUtils.trim((String)((String)structuredValues.get("Country"))));
            placeType.setStreet(StringUtils.trim((String)((String)structuredValues.get("Street"))));
            placeType.setZipCode(StringUtils.trim((String)((String)structuredValues.get("ZipCode"))));
            placeType.setState(StringUtils.trim((String)((String)structuredValues.get("State"))));
            generalPlaceType.setStructuredPlace(placeType);
            return generalPlaceType;
        }
        String freetextPlace = StringUtils.trim((String)((String)place.get("FreetextPlace")));
        if (freetextPlace != null) {
            generalPlaceType.setFreetextPlace(freetextPlace);
            return generalPlaceType;
        }
        generalPlaceType.setNoPlaceInfo(StringUtils.trim((String)((String)place.get("NoPlaceInfo"))));
        return generalPlaceType;
    }

    private RestrictedIDType getRestrictedID() {
        Map<String, Object> map = this.extractMap(EIDAttributeName.RestrictedID);
        if (map == null || !map.containsKey("ID")) {
            return null;
        }
        RestrictedIDType restrictedIDType = new RestrictedIDType();
        restrictedIDType.setID(DatatypeConverter.parseHexBinary((String)((String)map.get("ID")).trim()));
        return restrictedIDType;
    }

    private String getVerificationRequestValue(EIDAttributeName eidAttribute) throws SamlAuthenticationException {
        if (eidAttribute != EIDAttributeName.AgeVerification && eidAttribute != EIDAttributeName.PlaceVerification) {
            throw new SamlAuthenticationException("Cannot get the Verification Request for value for the eID attribute " + eidAttribute);
        }
        Map<String, Object> map = this.extractMap(eidAttribute);
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object request = map.get("Request");
        if (request instanceof Map) {
            Map m = (Map)request;
            return (String)m.get(eidAttribute == EIDAttributeName.AgeVerification ? "Age" : "CommunityID");
        }
        if (request instanceof String) {
            String s = (String)request;
            return s.trim();
        }
        throw new SamlAuthenticationException("Unexpected type for the request parameter of an VerificationResultType: " + (String)Optional.ofNullable(request).map(Object::getClass).map(Class::getName).orElse(null));
    }

    private VerificationResultType buildVerificationResultType(EIDAttributeName eidAttribute) {
        Map<String, Object> map = this.extractMap(eidAttribute);
        if (map == null || map.isEmpty()) {
            return null;
        }
        boolean fulfilsRequest = false;
        Object result = map.get("Result");
        if (result instanceof Map) {
            Map m = (Map)result;
            result = m.get("FulfilsRequest");
        }
        if (result instanceof String) {
            String s = (String)result;
            fulfilsRequest = Boolean.parseBoolean(s.trim());
        }
        VerificationResultType veriResult = new VerificationResultType();
        veriResult.setFulfilsRequest(fulfilsRequest);
        return veriResult;
    }

    OperationsResponderType buildOperationsResponderType(OperationsResponderType operationsResponderType) {
        operationsResponderType.setDocumentType(this.toAttributeResponderType(EIDAttributeName.DocumentType));
        operationsResponderType.setIssuingState(this.toAttributeResponderType(EIDAttributeName.IssuingState));
        operationsResponderType.setDateOfExpiry(this.toAttributeResponderType(EIDAttributeName.DateOfExpiry));
        operationsResponderType.setGivenNames(this.toAttributeResponderType(EIDAttributeName.GivenNames));
        operationsResponderType.setFamilyNames(this.toAttributeResponderType(EIDAttributeName.FamilyNames));
        operationsResponderType.setArtisticName(this.toAttributeResponderType(EIDAttributeName.ArtisticName));
        operationsResponderType.setAcademicTitle(this.toAttributeResponderType(EIDAttributeName.AcademicTitle));
        operationsResponderType.setDateOfBirth(this.toAttributeResponderType(EIDAttributeName.DateOfBirth));
        operationsResponderType.setPlaceOfBirth(this.toAttributeResponderType(EIDAttributeName.PlaceOfBirth));
        operationsResponderType.setNationality(this.toAttributeResponderType(EIDAttributeName.Nationality));
        operationsResponderType.setBirthName(this.toAttributeResponderType(EIDAttributeName.BirthName));
        operationsResponderType.setPlaceOfResidence(this.toAttributeResponderType(EIDAttributeName.PlaceOfResidence));
        operationsResponderType.setCommunityID(this.toAttributeResponderType(EIDAttributeName.CommunityID));
        operationsResponderType.setResidencePermitI(this.toAttributeResponderType(EIDAttributeName.ResidencePermitI));
        operationsResponderType.setRestrictedID(this.toAttributeResponderType(EIDAttributeName.RestrictedID));
        operationsResponderType.setAgeVerification(this.toAttributeResponderType(EIDAttributeName.AgeVerification));
        operationsResponderType.setPlaceVerification(this.toAttributeResponderType(EIDAttributeName.PlaceVerification));
        return operationsResponderType;
    }

    AttributeResponseType toAttributeResponderType(EIDAttributeName attributeName) {
        if (this.isNotOnChip(attributeName)) {
            return AttributeResponseType.NOTONCHIP;
        }
        if (this.assertion.getAttributeNames().contains(attributeName.name())) {
            return AttributeResponseType.ALLOWED;
        }
        return AttributeResponseType.PROHIBITED;
    }

    private TransactionAttestationResponseType buildTransactionAttestationResponseType() {
        if (this.getTransactionAttestationData() != null || this.getTransactionAttestationFormat() != null) {
            TransactionAttestationResponseType transactionAttestationResponseType = new TransactionAttestationResponseType();
            if (this.getTransactionAttestationData() != null) {
                JAXBElement jaxbElement = new JAXBElement(Common.TRANSACTION_ATTESTATION_QNAME, String.class, (Object)this.getTransactionAttestationData());
                Document document = XmlUtils.getDocumentBuilder().newDocument();
                JAXB.marshal((Object)jaxbElement, (javax.xml.transform.Result)new DOMResult(document));
                Element element = document.getDocumentElement();
                AnyType any = new AnyType();
                any.getAnies().add(element);
                transactionAttestationResponseType.setTransactionAttestationData(any);
            }
            if (this.getTransactionAttestationFormat() != null) {
                transactionAttestationResponseType.setTransactionAttestationFormat(this.getTransactionAttestationFormat());
            }
            return transactionAttestationResponseType;
        }
        return null;
    }

    private String getTransactionAttestationFormat() {
        Object extracted = this.extractTransactionAttestationAttribute("TransactionAttestationFormat");
        if (extracted instanceof String) {
            String s = (String)extracted;
            return s;
        }
        return null;
    }

    private String getTransactionAttestationData() {
        Object extractedInner;
        Object extracted = this.extractTransactionAttestationAttribute("TransactionAttestationData");
        if (extracted instanceof String) {
            String s = (String)extracted;
            return s;
        }
        if (extracted instanceof Map && (extractedInner = ((Map)extracted).get("TransactionAttestation")) instanceof String) {
            String s = (String)extractedInner;
            return s;
        }
        return null;
    }

    private Object extractTransactionAttestationAttribute(String attributeName) {
        Object[] transactionAttestations = this.assertion.getAttributeValue(EIDAttributeName.TransactionAttestation.name());
        if (transactionAttestations == null) {
            return null;
        }
        Object transactionAttestation = transactionAttestations[0];
        if (transactionAttestation instanceof Map) {
            Map attributes = (Map)transactionAttestation;
            return attributes.get(attributeName);
        }
        return null;
    }

    private EIDTypeResponseType buildEIDTypeResponseType() {
        Object[] eidTypes = this.assertion.getAttributeValue(EIDAttributeName.EIDType.name());
        if (eidTypes == null) {
            return null;
        }
        Object eidType = eidTypes[0];
        if (!(eidType instanceof Map)) {
            return null;
        }
        Map attributes = (Map)eidType;
        EIDTypeResponseType result = new EIDTypeResponseType();
        if (EIDTypeUsedType.USED.name().equals(attributes.get("CardCertified"))) {
            result.setCardCertified(EIDTypeUsedType.USED);
        }
        if (EIDTypeUsedType.USED.name().equals(attributes.get("HWKeyStore"))) {
            result.setHWKeyStore(EIDTypeUsedType.USED);
        }
        if (EIDTypeUsedType.USED.name().equals(attributes.get("SECertified"))) {
            result.setSECertified(EIDTypeUsedType.USED);
        }
        if (EIDTypeUsedType.USED.name().equals(attributes.get("SEEndorsed"))) {
            result.setSEEndorsed(EIDTypeUsedType.USED);
        }
        return result;
    }

    Map<String, Object> extractMap(EIDAttributeName attributeName) {
        Object firstValue = this.getFirstValue(attributeName);
        if (firstValue == null) {
            return null;
        }
        return (Map)firstValue;
    }

    String getFirstString(EIDAttributeName key) {
        Object object = this.getFirstValue(key);
        if (object instanceof String) {
            String s = (String)object;
            return s;
        }
        return null;
    }

    private Object getFirstValue(EIDAttributeName key) {
        Object[] values = this.assertion.getAttributeValue(key.name());
        return values == null || values.length == 0 ? null : values[0];
    }

    private boolean isNotOnChip(EIDAttributeName attribute) {
        return this.assertion.isNotOnChip(attribute.name());
    }

    public String getSamlResponseID() {
        return this.samlResponseID;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getPlaceVerificationReferenceValue() {
        return this.placeVerificationReferenceValue;
    }

    public String getAgeVerificationReferenceValue() {
        return this.ageVerificationReferenceValue;
    }

    public DocumentValidityResult getDocumentValidityResult() {
        return this.documentValidityResult;
    }
}

