/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.saml.response;

import de.governikus.panstar.sdk.saml.SamlInitializer;
import de.governikus.panstar.sdk.saml.configuration.SamlConfiguration;
import de.governikus.panstar.sdk.saml.configuration.SamlConfigurationHelper;
import de.governikus.panstar.sdk.saml.exception.SamlAuthenticationException;
import de.governikus.panstar.sdk.saml.exception.UnsuccessfulSamlAuthenticationProcessException;
import de.governikus.panstar.sdk.saml.response.ParsedAssertion;
import de.governikus.panstar.sdk.saml.response.ParsedResponse;
import de.governikus.panstar.sdk.saml.response.ProcessedSamlEidasResult;
import de.governikus.panstar.sdk.saml.response.ProcessedSamlResult;
import de.governikus.panstar.sdk.utils.exception.InvalidInputException;
import de.governikus.panstar.sdk.utils.saml.SAMLUtils;
import de.governikus.panstar.sdk.utils.saml.SamlDecrypterUtils;
import de.governikus.panstar.sdk.utils.xml.XMLSignatureHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.DataFormatException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SamlResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SamlResponseHandler.class);
    private final SamlConfiguration samlConfiguration;
    protected boolean checkAssertionTime = true;

    public SamlResponseHandler(@Nonnull SamlConfiguration samlConfiguration) throws InitializationException, InvalidInputException {
        this.samlConfiguration = samlConfiguration;
        SamlConfigurationHelper.checkSamlConfiguration(this.samlConfiguration);
        SamlInitializer.initialize();
    }

    public ProcessedSamlResult parseSamlResponse(String queryString) throws SamlAuthenticationException, InvalidInputException, UnsuccessfulSamlAuthenticationProcessException {
        Map<String, String> parameterList = SamlResponseHandler.getParameterList(queryString, true);
        if (!(parameterList.containsKey("SAMLResponse") && parameterList.containsKey("Signature") && parameterList.containsKey("SigAlg"))) {
            throw new InvalidInputException(String.format("Given query string misses some parameter. Necessary are: %s. Found parameter: %s", String.join((CharSequence)",", List.of("SAMLResponse", "Signature", "SigAlg")), String.join((CharSequence)",", parameterList.values())));
        }
        return this.parseSamlResponse(parameterList.get("SAMLResponse"), parameterList.get("RelayState"), parameterList.get("Signature"), parameterList.get("SigAlg"));
    }

    public ProcessedSamlEidasResult parseEidasSamlResponse(String samlResponse) throws SamlAuthenticationException, InvalidInputException, UnsuccessfulSamlAuthenticationProcessException {
        return new ProcessedSamlEidasResult(this.parseToResponse(Base64.getMimeDecoder().decode(samlResponse), true, false));
    }

    public ProcessedSamlResult parseSamlResponse(String samlResponse, @Nullable String relayState, String signature, String signatureAlgorithm) throws SamlAuthenticationException, InvalidInputException, UnsuccessfulSamlAuthenticationProcessException {
        byte[] samlResponseBytes;
        if (StringUtils.isBlank((CharSequence)samlResponse)) {
            throw new InvalidInputException("Argument samlResponse may not be null!");
        }
        if (StringUtils.isBlank((CharSequence)signature)) {
            throw new InvalidInputException("Argument signature may not be null!");
        }
        if (StringUtils.isBlank((CharSequence)signatureAlgorithm)) {
            throw new InvalidInputException("Argument signatureAlgorithm may not be null!");
        }
        if (!SAMLUtils.checkQuerySignature((String)samlResponse, (String)relayState, (String)signatureAlgorithm, (String)signature, (X509Certificate)this.samlConfiguration.getSamlKeyMaterial().getSamlResponseSignatureValidatingCertificate(), (boolean)false)) {
            throw new SamlAuthenticationException("Signature is invalid!");
        }
        try {
            samlResponseBytes = SAMLUtils.inflate((String)samlResponse);
        }
        catch (DataFormatException e) {
            throw new InvalidInputException("samlResponse not in expected format", (Throwable)e);
        }
        ParsedResponse parsedResponse = this.parseToResponse(samlResponseBytes, false, false);
        this.validateSamlResponse(parsedResponse, this.samlConfiguration.getSamlServiceProviderConfiguration().getSamlResponseReceiverUrl(), this.samlConfiguration.getSamlServiceProviderConfiguration().getSamlEntityId());
        return new ProcessedSamlResult(parsedResponse);
    }

    private ParsedResponse parseToResponse(byte[] samlResponse, boolean checkResponseInlineSignature, boolean checkAssertionSignature) throws SamlAuthenticationException, InvalidInputException {
        Response response;
        try {
            Document document = XMLObjectProviderRegistrySupport.getParserPool().parse((InputStream)new ByteArrayInputStream(samlResponse));
            Unmarshaller um = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(document.getDocumentElement());
            response = (Response)um.unmarshall(document.getDocumentElement());
        }
        catch (NullPointerException | XMLParserException | UnmarshallingException e) {
            throw new InvalidInputException("Could not parse or unmarshal the saml response!", e);
        }
        if (checkResponseInlineSignature) {
            try {
                XMLSignatureHandler.checkSignature((Signature)response.getSignature(), (X509Certificate[])new X509Certificate[]{this.samlConfiguration.getSamlKeyMaterial().getSamlResponseSignatureValidatingCertificate()});
            }
            catch (SignatureException e) {
                throw new SamlAuthenticationException(e);
            }
        }
        HashSet<EncryptedAssertion> decryptedAssertions = new HashSet<EncryptedAssertion>();
        BasicCredential simpleCredential = CredentialSupport.getSimpleCredential((PublicKey)this.samlConfiguration.getSamlKeyMaterial().getSamlResponseDecryptionKeyPair().getPublic(), (PrivateKey)this.samlConfiguration.getSamlKeyMaterial().getSamlResponseDecryptionKeyPair().getPrivate());
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            Decrypter decr = SamlDecrypterUtils.setupDecrypter((Credential)simpleCredential);
            decr.setRootInNewDocument(true);
            try {
                response.getAssertions().add((Assertion)decr.decryptData(encryptedAssertion.getEncryptedData()));
                decryptedAssertions.add(encryptedAssertion);
            }
            catch (DecryptionException e) {
                throw new SamlAuthenticationException("Could not decrypt assertion", e);
            }
        }
        response.getEncryptedAssertions().removeAll(decryptedAssertions);
        if (checkAssertionSignature) {
            for (Assertion assertion : response.getAssertions()) {
                try {
                    XMLSignatureHandler.checkSignature((Signature)assertion.getSignature(), (X509Certificate[])new X509Certificate[]{this.samlConfiguration.getSamlKeyMaterial().getSamlResponseSignatureValidatingCertificate()});
                }
                catch (SignatureException e) {
                    throw new SamlAuthenticationException(e);
                }
            }
        }
        return new ParsedResponse(response, this.checkAssertionTime);
    }

    private void validateSamlResponse(ParsedResponse parsedResponse, Optional<URL> destination, String audienceRestriction) throws SamlAuthenticationException {
        LOG.trace("validating parsed saml response");
        if (destination.isPresent() && !StringUtils.equals((CharSequence)destination.get().toString(), (CharSequence)parsedResponse.getResponse().getDestination())) {
            throw new SamlAuthenticationException("expected destination does not match the real destination: \n\texpected destination: " + destination.get() + "\n\treal destination: " + parsedResponse.getResponse().getDestination());
        }
        this.validateParsedAssertions(parsedResponse, audienceRestriction);
        if (parsedResponse.isStatusSuccess()) {
            LOG.trace("saml response was parsed successfully");
        }
    }

    private void validateParsedAssertions(ParsedResponse parsedResponse, String audienceRestriction) throws SamlAuthenticationException {
        ParsedAssertion parsedAssertion = parsedResponse.getAssertion();
        if (audienceRestriction != null && parsedAssertion != null) {
            if (parsedAssertion.getAudienceRestrictions().size() != 1) {
                throw new SamlAuthenticationException("audience restriction must contain exactly a single element but it contains '" + parsedAssertion.getAudienceRestrictions().size() + "' elements.");
            }
            if (!parsedAssertion.getAudienceRestrictions().get(0).equals(audienceRestriction)) {
                throw new SamlAuthenticationException("audience restriction was expected to be for audience '" + audienceRestriction + "' but it is for '" + parsedAssertion.getAudienceRestrictions().get(0) + "'");
            }
        }
        if (this.checkAssertionTime && parsedAssertion != null) {
            Instant currentTime = Instant.now();
            if (currentTime.plusSeconds(10L).isBefore(parsedAssertion.getAssertion().getIssueInstant())) {
                throw new SamlAuthenticationException("SAML response is not yet valid: (issueInstant = " + parsedAssertion.getAssertion().getIssueInstant() + ")");
            }
            if (currentTime.isAfter(parsedAssertion.getNotOnOrAfter())) {
                throw new SamlAuthenticationException("SAML response has expired: (notOnOrAfter = " + parsedAssertion.getNotOnOrAfter() + ")");
            }
        }
    }

    private static Map<String, String> getParameterList(String queryString, boolean urlDecodeValues) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String parameter : queryString.split("&")) {
            String[] parameterKeyValueSplit = parameter.split("=");
            String key = parameterKeyValueSplit[0];
            if (parameterKeyValueSplit.length == 1) {
                LOG.info("Parameter has no value: {}", (Object)key);
            }
            if (ret.containsKey(key)) {
                throw new IllegalArgumentException("Parameter must be unique: " + key);
            }
            String value = parameterKeyValueSplit.length == 1 ? "" : parameterKeyValueSplit[1];
            ret.put(key, urlDecodeValues ? URLDecoder.decode(value, StandardCharsets.UTF_8) : value);
        }
        return ret;
    }

    void setCheckAssertionTime(boolean checkAssertionTime) {
        this.checkAssertionTime = checkAssertionTime;
    }
}

