/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils;

import de.bund.bsi.eid240.AgeVerificationRequestType;
import de.bund.bsi.eid240.AttributeRequestType;
import de.bund.bsi.eid240.EIDTypeRequestType;
import de.bund.bsi.eid240.EIDTypeSelectionType;
import de.bund.bsi.eid240.IdentityFlavourType;
import de.bund.bsi.eid240.PlaceVerificationRequestType;
import de.bund.bsi.eid240.TransactionAttestationRequestType;
import de.governikus.panstar.sdk.utils.OperationsRequestorTypeExtension;
import de.governikus.panstar.sdk.utils.constant.LevelOfAssuranceType;
import de.governikus.panstar.sdk.utils.exception.InvalidInputException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RequestData.class);
    private OperationsRequestorTypeExtension useOperations = new OperationsRequestorTypeExtension();
    private AgeVerificationRequestType ageVerificationRequest;
    private PlaceVerificationRequestType placeVerificationRequest;
    private String transactionInfo;
    private TransactionAttestationRequestType transactionAttestationRequest;
    private String levelOfAssuranceRequest;
    private EIDTypeRequestType eidTypeRequest;
    private IdentityFlavourType identityFlavourType;
    private Boolean useEidas;
    private String sendingMemberState;

    public RequestData() {
        this.useOperations.setAcademicTitle(AttributeRequestType.PROHIBITED);
        this.useOperations.setAgeVerification(AttributeRequestType.PROHIBITED);
        this.useOperations.setArtisticName(AttributeRequestType.PROHIBITED);
        this.useOperations.setBirthName(AttributeRequestType.PROHIBITED);
        this.useOperations.setCommunityID(AttributeRequestType.PROHIBITED);
        this.useOperations.setDateOfBirth(AttributeRequestType.PROHIBITED);
        this.useOperations.setDateOfExpiry(AttributeRequestType.PROHIBITED);
        this.useOperations.setDocumentType(AttributeRequestType.PROHIBITED);
        this.useOperations.setFamilyNames(AttributeRequestType.PROHIBITED);
        this.useOperations.setGivenNames(AttributeRequestType.PROHIBITED);
        this.useOperations.setIssuingState(AttributeRequestType.PROHIBITED);
        this.useOperations.setNationality(AttributeRequestType.PROHIBITED);
        this.useOperations.setPlaceOfBirth(AttributeRequestType.PROHIBITED);
        this.useOperations.setPlaceOfResidence(AttributeRequestType.PROHIBITED);
        this.useOperations.setPlaceVerification(AttributeRequestType.PROHIBITED);
        this.useOperations.setResidencePermitI(AttributeRequestType.PROHIBITED);
        this.useOperations.setRestrictedID(AttributeRequestType.PROHIBITED);
        this.useOperations.setSex(AttributeRequestType.PROHIBITED);
        this.useOperations.setLegalName(AttributeRequestType.PROHIBITED);
        this.useOperations.setLegalPersonIdentifier(AttributeRequestType.PROHIBITED);
        this.useOperations.setLegalAddress(AttributeRequestType.PROHIBITED);
        this.useOperations.setVatRegistration(AttributeRequestType.PROHIBITED);
        this.useOperations.setTaxReference(AttributeRequestType.PROHIBITED);
        this.useOperations.setBusinessCodes(AttributeRequestType.PROHIBITED);
        this.useOperations.setLei(AttributeRequestType.PROHIBITED);
        this.useOperations.setEori(AttributeRequestType.PROHIBITED);
        this.useOperations.setSeed(AttributeRequestType.PROHIBITED);
        this.useOperations.setSic(AttributeRequestType.PROHIBITED);
        this.useEidas = false;
    }

    public RequestData documentType(boolean required) {
        this.useOperations.setDocumentType(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData documentType(AttributeRequestType attributeRequestType) {
        this.useOperations.setDocumentType(attributeRequestType);
        return this;
    }

    public RequestData issuingState(boolean required) {
        this.useOperations.setIssuingState(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData issuingState(AttributeRequestType attributeRequestType) {
        this.useOperations.setIssuingState(attributeRequestType);
        return this;
    }

    public RequestData dateOfExpiry(boolean required) {
        this.useOperations.setDateOfExpiry(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData dateOfExpiry(AttributeRequestType attributeRequestType) {
        this.useOperations.setDateOfExpiry(attributeRequestType);
        return this;
    }

    public RequestData givenNames(boolean required) {
        this.useOperations.setGivenNames(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData givenNames(AttributeRequestType attributeRequestType) {
        this.useOperations.setGivenNames(attributeRequestType);
        return this;
    }

    public RequestData familyNames(boolean required) {
        this.useOperations.setFamilyNames(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData familyNames(AttributeRequestType attributeRequestType) {
        this.useOperations.setFamilyNames(attributeRequestType);
        return this;
    }

    public RequestData artisticName(boolean required) {
        this.useOperations.setArtisticName(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData artisticName(AttributeRequestType attributeRequestType) {
        this.useOperations.setArtisticName(attributeRequestType);
        return this;
    }

    public RequestData academicTitle(boolean required) {
        this.useOperations.setAcademicTitle(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData academicTitle(AttributeRequestType attributeRequestType) {
        this.useOperations.setAcademicTitle(attributeRequestType);
        return this;
    }

    public RequestData dateOfBirth(boolean required) {
        this.useOperations.setDateOfBirth(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData dateOfBirth(AttributeRequestType attributeRequestType) {
        this.useOperations.setDateOfBirth(attributeRequestType);
        return this;
    }

    public RequestData placeOfBirth(boolean required) {
        this.useOperations.setPlaceOfBirth(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData placeOfBirth(AttributeRequestType attributeRequestType) {
        this.useOperations.setPlaceOfBirth(attributeRequestType);
        return this;
    }

    public RequestData nationality(boolean required) {
        this.useOperations.setNationality(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData nationality(AttributeRequestType attributeRequestType) {
        this.useOperations.setNationality(attributeRequestType);
        return this;
    }

    public RequestData birthName(boolean required) {
        this.useOperations.setBirthName(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData birthName(AttributeRequestType attributeRequestType) {
        this.useOperations.setBirthName(attributeRequestType);
        return this;
    }

    public RequestData placeOfResidence(boolean required) {
        this.useOperations.setPlaceOfResidence(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData placeOfResidence(AttributeRequestType attributeRequestType) {
        this.useOperations.setPlaceOfResidence(attributeRequestType);
        return this;
    }

    public RequestData communityID(boolean required) {
        this.useOperations.setCommunityID(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData communityID(AttributeRequestType attributeRequestType) {
        this.useOperations.setCommunityID(attributeRequestType);
        return this;
    }

    public RequestData residencePermitI(boolean required) {
        this.useOperations.setResidencePermitI(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData residencePermitI(AttributeRequestType attributeRequestType) {
        this.useOperations.setResidencePermitI(attributeRequestType);
        return this;
    }

    public RequestData restrictedID(boolean required) {
        this.useOperations.setRestrictedID(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData restrictedID(AttributeRequestType attributeRequestType) {
        this.useOperations.setRestrictedID(attributeRequestType);
        return this;
    }

    public RequestData sex(boolean required) {
        this.useOperations.setSex(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData sex(AttributeRequestType attributeRequestType) {
        this.useOperations.setSex(attributeRequestType);
        return this;
    }

    public RequestData legalName(boolean required) {
        this.useOperations.setLegalName(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData legalName(AttributeRequestType attributeRequestType) {
        this.useOperations.setLegalName(attributeRequestType);
        return this;
    }

    public RequestData legalPersonIdentifier(boolean required) {
        this.useOperations.setLegalPersonIdentifier(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData legalPersonIdentifier(AttributeRequestType attributeRequestType) {
        this.useOperations.setLegalPersonIdentifier(attributeRequestType);
        return this;
    }

    public RequestData legalAddress(boolean required) {
        this.useOperations.setLegalAddress(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData legalAddress(AttributeRequestType attributeRequestType) {
        this.useOperations.setLegalAddress(attributeRequestType);
        return this;
    }

    public RequestData vatRegistration(boolean required) {
        this.useOperations.setVatRegistration(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData vatRegistration(AttributeRequestType attributeRequestType) {
        this.useOperations.setVatRegistration(attributeRequestType);
        return this;
    }

    public RequestData taxReference(boolean required) {
        this.useOperations.setTaxReference(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData taxReference(AttributeRequestType attributeRequestType) {
        this.useOperations.setTaxReference(attributeRequestType);
        return this;
    }

    public RequestData businessCodes(boolean required) {
        this.useOperations.setBusinessCodes(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData businessCodes(AttributeRequestType attributeRequestType) {
        this.useOperations.setBusinessCodes(attributeRequestType);
        return this;
    }

    public RequestData lei(boolean required) {
        this.useOperations.setLei(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData lei(AttributeRequestType attributeRequestType) {
        this.useOperations.setLei(attributeRequestType);
        return this;
    }

    public RequestData eori(boolean required) {
        this.useOperations.setEori(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData eori(AttributeRequestType attributeRequestType) {
        this.useOperations.setEori(attributeRequestType);
        return this;
    }

    public RequestData seed(boolean required) {
        this.useOperations.setSeed(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData seed(AttributeRequestType attributeRequestType) {
        this.useOperations.setSeed(attributeRequestType);
        return this;
    }

    public RequestData sic(boolean required) {
        this.useOperations.setSic(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        return this;
    }

    public RequestData sic(AttributeRequestType attributeRequestType) {
        this.useOperations.setSic(attributeRequestType);
        return this;
    }

    public RequestData ageVerification(boolean required, int age) {
        this.useOperations.setAgeVerification(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        this.ageVerificationRequest = new AgeVerificationRequestType();
        this.ageVerificationRequest.setAge(age);
        return this;
    }

    public RequestData ageVerification(AttributeRequestType attributeRequestType, int age) {
        this.useOperations.setAgeVerification(attributeRequestType);
        if (attributeRequestType != AttributeRequestType.PROHIBITED) {
            this.ageVerificationRequest = new AgeVerificationRequestType();
            this.ageVerificationRequest.setAge(age);
        }
        return this;
    }

    public RequestData placeVerification(boolean required, String communityID) {
        this.useOperations.setPlaceVerification(required ? AttributeRequestType.REQUIRED : AttributeRequestType.ALLOWED);
        this.placeVerificationRequest = new PlaceVerificationRequestType();
        this.placeVerificationRequest.setCommunityID(communityID);
        return this;
    }

    public RequestData placeVerification(AttributeRequestType attributeRequestType, String communityID) {
        this.useOperations.setPlaceVerification(attributeRequestType);
        if (attributeRequestType != AttributeRequestType.PROHIBITED) {
            this.placeVerificationRequest = new PlaceVerificationRequestType();
            this.placeVerificationRequest.setCommunityID(communityID);
        }
        return this;
    }

    public RequestData identityFlavour(IdentityFlavourType identityFlavourType) {
        this.identityFlavourType = identityFlavourType;
        return this;
    }

    public RequestData setSendingMemberState(String sendingMemberState) {
        this.sendingMemberState = sendingMemberState;
        return this;
    }

    public RequestData useEidas() {
        this.useEidas = true;
        return this;
    }

    public RequestData transactionInfo(String info) {
        this.transactionInfo = info;
        return this;
    }

    public RequestData transactionAttestation(String format, String context) {
        this.transactionAttestationRequest = new TransactionAttestationRequestType();
        this.transactionAttestationRequest.setTransactionAttestationFormat(format);
        this.transactionAttestationRequest.setTransactionContext(context);
        return this;
    }

    public RequestData levelOfAssurance(LevelOfAssuranceType loa) {
        this.levelOfAssuranceRequest = loa.getUri();
        return this;
    }

    public RequestData cardCertified(boolean allowed) {
        this.tryConstructEidType();
        this.eidTypeRequest.setCardCertified(allowed ? EIDTypeSelectionType.ALLOWED : EIDTypeSelectionType.DENIED);
        return this;
    }

    public RequestData hwKeyStore(boolean allowed) {
        this.tryConstructEidType();
        this.eidTypeRequest.setHWKeyStore(allowed ? EIDTypeSelectionType.ALLOWED : EIDTypeSelectionType.DENIED);
        return this;
    }

    public RequestData seCertified(boolean allowed) {
        this.tryConstructEidType();
        this.eidTypeRequest.setSECertified(allowed ? EIDTypeSelectionType.ALLOWED : EIDTypeSelectionType.DENIED);
        return this;
    }

    public RequestData seEndorsed(boolean allowed) {
        this.tryConstructEidType();
        this.eidTypeRequest.setSEEndorsed(allowed ? EIDTypeSelectionType.ALLOWED : EIDTypeSelectionType.DENIED);
        return this;
    }

    private void tryConstructEidType() {
        if (this.eidTypeRequest == null) {
            this.eidTypeRequest = new EIDTypeRequestType();
        }
    }

    public void matchLoa() throws InvalidInputException {
        if (this.levelOfAssuranceRequest == null) {
            return;
        }
        LevelOfAssuranceType levelOfAssuranceType = LevelOfAssuranceType.byUri(this.levelOfAssuranceRequest).orElseThrow(() -> new InvalidInputException("This level of assurance is unknown."));
        if (this.getUseEidas() && !levelOfAssuranceType.isLoaBund().booleanValue()) {
            return;
        }
        if (!this.getUseEidas() && levelOfAssuranceType.isLoaBund().booleanValue()) {
            return;
        }
        LOG.debug("LOA miss match. useEidas was set to {} and loa was set to {}", (Object)this.getUseEidas(), (Object)this.levelOfAssuranceRequest);
        throw new InvalidInputException("The level of assurance type must match the type of validation. Either eIDAS (http://eidas.europa.eu/LoA/) or eID (http://bsi.bund.de/eID/LoA).");
    }

    public OperationsRequestorTypeExtension getUseOperations() {
        return this.useOperations;
    }

    public AgeVerificationRequestType getAgeVerificationRequest() {
        return this.ageVerificationRequest;
    }

    public PlaceVerificationRequestType getPlaceVerificationRequest() {
        return this.placeVerificationRequest;
    }

    public String getTransactionInfo() {
        return this.transactionInfo;
    }

    public TransactionAttestationRequestType getTransactionAttestationRequest() {
        return this.transactionAttestationRequest;
    }

    public String getLevelOfAssuranceRequest() {
        return this.levelOfAssuranceRequest;
    }

    public EIDTypeRequestType getEidTypeRequest() {
        return this.eidTypeRequest;
    }

    public boolean getUseEidas() {
        return this.useEidas;
    }

    public IdentityFlavourType getIdentityFlavour() {
        return this.identityFlavourType;
    }

    public String getSendingMemberState() {
        return this.sendingMemberState;
    }
}

