/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.constant;

public enum ATAccessRights {
    WRITE_DG17("Write DG17 (eID): Normal Place of Residence", 0, 32),
    WRITE_DG18("Write DG18 (eID): Municipality ID", 0, 16),
    WRITE_DG19("Write DG19 (eID): Residence Permit I", 0, 8),
    WRITE_DG20("Write DG20 (eID): Residence Permit II", 0, 4),
    WRITE_DG21("Write DG21 (eID): Phone Number", 0, 2),
    WRITE_DG22("Write DG22 (eID): Email Address", 0, 1),
    PSA("PSA", 1, 64),
    READ_DG22("Read DG22 (eID): Email Address", 1, 32),
    READ_DG21("Read DG21 (eID): Phone Number", 1, 16),
    READ_DG20("Read DG20 (eID): Residence Permit II", 1, 8),
    READ_DG19("Read DG19 (eID): Residence Permit I", 1, 4),
    READ_DG18("Read DG18 (eID): Municipality ID", 1, 2),
    READ_DG17("Read DG17 (eID): Normal Place of Residence", 1, 1),
    READ_DG16("Read DG16 (eID): RFU", 2, -128),
    READ_DG15("Read DG15 (eID): Date of Issuance", 2, 64),
    READ_DG14("Read DG14 (eID): Written Signature", 2, 32),
    READ_DG13("Read DG13 (eID): Birth Name", 2, 16),
    READ_DG12("Read DG12 (eID): Optional Data", 2, 8),
    READ_DG11("Read DG11 (eID): Sex", 2, 4),
    READ_DG10("Read DG10 (eID): Nationality", 2, 2),
    READ_DG9("Read DG9 (eID): Place of Birth", 2, 1),
    READ_DG8("Read DG8 (eID): Date of Birth", 3, -128),
    READ_DG7("Read DG7 (eID): Academic Title", 3, 64),
    READ_DG6("Read DG6 (eID): Nom de Plume", 3, 32),
    READ_DG5("Read DG5 (eID): Family Names", 3, 16),
    READ_DG4("Read DG4 (eID): Given Names", 3, 8),
    READ_DG3("Read DG3 (eID): Date of Expiry", 3, 4),
    READ_DG2("Read DG2 (eID): Issuing State, Region and Municipality", 3, 2),
    READ_DG1("Read DG1 (eID): Document Type", 3, 1),
    INSTALL_QUALIFIED_CERTIFICATE("Install Qualified Certificate", 4, -128),
    INSTALL_CERTIFICATE("Install Certificate", 4, 64),
    PIN_MANAGEMENT("PIN Management", 4, 32),
    CAN_ALLOWED("CAN allowed", 4, 16),
    PRIVILEGED_TERMINAL("Privileged Terminal", 4, 8),
    RESTRICTED_IDENTIFICATION("Restricted Identification", 4, 4),
    MUNICIPALITY_ID_VERIFICATION("Municipality ID Identification", 4, 2),
    AGE_VERIFICATION("Age Verification", 4, 1);

    private String name;
    private int byteIndex;
    private byte bitMask;

    public boolean isWriteRight() {
        int index = this.getAbsoluteBitIndex();
        return index >= 32 && index <= 37;
    }

    public boolean isReadRight() {
        int index = this.getAbsoluteBitIndex();
        return index >= 8 && index <= 29;
    }

    public boolean isSpecialFunction() {
        int index = this.getAbsoluteBitIndex();
        return index >= 0 && index <= 7 || index == 30;
    }

    private int getAbsoluteBitIndex() {
        return this.getBitIndex() + (4 - this.byteIndex) * 8;
    }

    private int getBitIndex() {
        int index;
        int unsignedBitMask = Byte.toUnsignedInt(this.bitMask);
        for (index = 7; index >= 0 && unsignedBitMask >>> index == 0; --index) {
        }
        return index;
    }

    public String getName() {
        return this.name;
    }

    public int getByteIndex() {
        return this.byteIndex;
    }

    public byte getBitMask() {
        return this.bitMask;
    }

    private ATAccessRights(String name, int byteIndex, byte bitMask) {
        this.name = name;
        this.byteIndex = byteIndex;
        this.bitMask = bitMask;
    }
}

