/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.constant;

import de.governikus.panstar.sdk.utils.constant.ATAccessRights;
import javax.xml.namespace.QName;

public enum EIDAttributeName {
    DocumentValidity(new QName("http://bsi.bund.de/eID/", "DocumentValidityResultType", "idp"), null),
    DocumentType(new QName("http://bsi.bund.de/eID/", "DocumentType", "idp"), ATAccessRights.READ_DG1, new byte[]{1, 1}, (byte)1),
    IssuingState(new QName("http://bsi.bund.de/eID/", "ICAOCountry", "idp"), ATAccessRights.READ_DG2, new byte[]{1, 2}, (byte)2),
    DateOfExpiry(new QName("http://www.w3.org/2001/XMLSchema", "date", "xsd"), ATAccessRights.READ_DG3, new byte[]{1, 3}, (byte)3),
    GivenNames(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), ATAccessRights.READ_DG4, new byte[]{1, 4}, (byte)4),
    FamilyNames(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), ATAccessRights.READ_DG5, new byte[]{1, 5}, (byte)5),
    ArtisticName(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), ATAccessRights.READ_DG6, new byte[]{1, 6}, (byte)6),
    AcademicTitle(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), ATAccessRights.READ_DG7, new byte[]{1, 7}, (byte)7),
    DateOfBirth(new QName("http://bsi.bund.de/eID/", "GeneralDateType", "idp"), ATAccessRights.READ_DG8, new byte[]{1, 8}, (byte)8),
    PlaceOfBirth(new QName("http://bsi.bund.de/eID/", "GeneralPlaceType", "idp"), ATAccessRights.READ_DG9, new byte[]{1, 9}, (byte)9),
    Nationality(new QName("http://bsi.bund.de/eID/", "ICAOCountry", "idp"), ATAccessRights.READ_DG10, new byte[]{1, 10}, (byte)10),
    BirthName(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), ATAccessRights.READ_DG13, new byte[]{1, 13}, (byte)13),
    PlaceOfResidence(new QName("http://bsi.bund.de/eID/", "GeneralPlaceType", "idp"), ATAccessRights.READ_DG17, new byte[]{1, 17}, (byte)17),
    CommunityID(new QName("http://bsi.bund.de/eID/", "CommunityIDType", "idp"), ATAccessRights.READ_DG18, new byte[]{1, 18}, (byte)18),
    ResidencePermitI(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), ATAccessRights.READ_DG19, new byte[]{1, 19}, (byte)19),
    RestrictedID(new QName("http://bsi.bund.de/eID/", "RestrictedIDType", "idp"), ATAccessRights.RESTRICTED_IDENTIFICATION),
    AgeVerification(new QName("http://bsi.bund.de/eID/", "AgeVerificationResultType", "idp"), ATAccessRights.AGE_VERIFICATION),
    PlaceVerification(new QName("http://bsi.bund.de/eID/", "PlaceVerificationResultType", "idp"), ATAccessRights.MUNICIPALITY_ID_VERIFICATION),
    TransactionAttestation(new QName("http://bsi.bund.de/eID/", "TransactionAttestationResponseType", "idp"), null),
    LevelOfAssurance(new QName("http://bsi.bund.de/eID/", "LevelOfAssuranceType", "idp"), null),
    EIDType(new QName("http://bsi.bund.de/eID/", "EIDTypeResponseType", "idp"), null),
    TransactionInfo(null, null),
    UseEidas(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd"), null),
    EidasExtension(new QName("http://bsi.bund.de/eID/", "EidasExtensionType", "idp"), null),
    Sex(new QName("http://bsi.bund.de/eID/", "ICAOSex", "idp"), ATAccessRights.READ_DG11, new byte[]{1, 11}, (byte)11),
    IdentityFlavour(new QName("http://bsi.bund.de/eID/", "IdentityFlavourType", "idp"), null),
    LegalName(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    LegalPersonIdentifier(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    LegalAddress(new QName("http://bsi.bund.de/eID/", "GeneralPlaceType", "idp"), null),
    VATRegistration(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    TaxReference(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    BusinessCodes(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    LEI(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    EORI(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    SEED(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    SIC(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), null),
    WRITE_PLACE_OF_RESIDENCE(null, ATAccessRights.WRITE_DG17, new byte[]{1, 17}, (byte)17),
    WRITE_MUNICIPALITY_ID(null, ATAccessRights.WRITE_DG18, new byte[]{1, 18}, (byte)18),
    PIN_MANAGEMENT(null, ATAccessRights.PIN_MANAGEMENT),
    PSA(null, ATAccessRights.PSA),
    CAN(null, ATAccessRights.CAN_ALLOWED),
    INSTALL_CERTIFICATE(null, ATAccessRights.INSTALL_CERTIFICATE);

    private final QName qName;
    private final ATAccessRights accessRights;
    private byte[] fid;
    private Byte sfi;

    public boolean isReadCommand() {
        return this.accessRights != null && this.accessRights.isReadRight();
    }

    public boolean isSpecialFunctionCommand() {
        return this.accessRights != null && this.accessRights.isSpecialFunction();
    }

    private EIDAttributeName(QName qName, ATAccessRights accessRights, byte[] fid, Byte sfi) {
        this.qName = qName;
        this.accessRights = accessRights;
        this.fid = fid;
        this.sfi = sfi;
    }

    private EIDAttributeName(QName qName, ATAccessRights accessRights) {
        this.qName = qName;
        this.accessRights = accessRights;
    }

    public QName getQName() {
        return this.qName;
    }

    public ATAccessRights getAccessRights() {
        return this.accessRights;
    }

    public byte[] getFid() {
        return this.fid;
    }

    public Byte getSfi() {
        return this.sfi;
    }

    public static class Constants {
        public static final String STRING_TYPE = "string";
        private static final String GENERAL_PLACE_TYPE = "GeneralPlaceType";
        private static final String ICAO_COUNTRY_TYPE = "ICAOCountry";

        private Constants() {
        }
    }
}

