/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.constant;

import java.util.Arrays;
import java.util.Optional;

public enum LevelOfAssuranceType {
    TEST("test"),
    BUND_UNDEFINED("http://bsi.bund.de/eID/LoA/undefined"),
    BUND_NORMAL("http://bsi.bund.de/eID/LoA/normal"),
    BUND_SUBSTANTIELL("http://bsi.bund.de/eID/LoA/substantiell"),
    BUND_HOCH("http://bsi.bund.de/eID/LoA/hoch"),
    EIDAS_LOW("http://eidas.europa.eu/LoA/low"),
    EIDAS_SUBSTANTIAL("http://eidas.europa.eu/LoA/substantial"),
    EIDAS_HIGH("http://eidas.europa.eu/LoA/high");

    private final String uri;

    public String getUri() {
        return this.uri;
    }

    public Boolean isLoaBund() {
        return this.uri.startsWith("http://bsi.bund.de/eID/LoA/");
    }

    private LevelOfAssuranceType(String uri) {
        this.uri = uri;
    }

    public static Optional<LevelOfAssuranceType> byUri(String uri) {
        return Arrays.stream(LevelOfAssuranceType.values()).filter(l -> l.getUri().equals(uri)).findAny();
    }
}

