/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.constant;

import de.governikus.panstar.sdk.utils.constant.ResultMinor;
import org.apache.commons.lang3.StringUtils;

public enum SamlError {
    COMMON_INTERNAL_ERROR("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:internalError", ResultMinor.COMMON_INTERNAL_ERROR),
    DOCUMENT_BLOCKED("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:documentBlocked", ResultMinor.SAL_MEAC_DOCUMENT_VALIDITY_VERIFICATION_FAILED),
    DOCUMENT_EXPIRED("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:documentExpired", ResultMinor.SAL_MEAC_DOCUMENT_VALIDITY_VERIFICATION_FAILED),
    EID_TYPE_FORBIDDEN("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:eidTypeForbidden", ResultMinor.SAL_SECURITY_CONDITION_NOT_SATISFIED),
    EID_TYPE_UNKNOWN("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:eidTypeUnknown", ResultMinor.SAL_SECURITY_CONDITION_NOT_SATISFIED),
    PA_SIGNATURE("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:paSignature", ResultMinor.SAL_MEAC_DOCUMENT_VALIDITY_VERIFICATION_FAILED),
    PAOS_CANCELLED_BY_USER("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:paosCancelledByUser", ResultMinor.SAL_CANCELLATION_BY_USER),
    REQUEST_ATTESTATION_FORMAT_UNSUPPORTED("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:governikus.de:SAML:panstar:requestAttestationFormat", ResultMinor.COMMON_INCORRECT_PARAMETER),
    REQUEST_ATTESTATION_INVALID_JSON("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:governikus.de:SAML:panstar:requestAttestationJson", ResultMinor.COMMON_SCHEMAVIOLATION),
    REQUEST_ATTESTATION_SUBJECT_REF_UNSUPPORTED("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:governikus.de:SAML:panstar:requestAttestationSubjectRef", ResultMinor.COMMON_SCHEMAVIOLATION),
    REQUEST_INCOMPLETE("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:governikus.de:SAML:panstar:requestIncomplete", ResultMinor.USEID_MISSING_ARGUMENT),
    REQUEST_MISSING_TERMINAL_RIGHTS("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:governikus.de:SAML:panstar:requestMissingRights", ResultMinor.USEID_MISSING_TERMINAL_RIGHTS),
    EIDAS_CANCELLED_BY_USER("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:eidasCancelledByUser", "CancellationByUser"),
    EIDAS_GENERATE_NODE_REQUEST("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:generateRequestToNode", "GenerateRequestToNode"),
    EIDAS_GENERATE_SP_RESPONSE("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:generateResponseToService", "GenerateResponseToService"),
    EIDAS_HANDLE_NODE_RESPONSE("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:handleResponseFromNode", "HandleResponseFromNode"),
    EIDAS_INTERNAL_ERROR("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:internalError", "InternalError"),
    EIDAS_LOA_NOT_SATISFIED("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:unsatisfiedLoA", "UnsatisfiedLoA"),
    EIDAS_METADATA_NOT_AVAILABLE("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:metadataNotAvailable", "MetadataNotAvailable"),
    EIDAS_NODE_ERROR("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:governikus.de:SAML:panstar:errorReportedFromNode", "ErrorReportedFromNode");

    private final String topLevelStatusCode;
    private final String secondLevelStatusCode;
    private final String message;

    private SamlError(String topLevelStatusCode, String secondLevelStatusCode, ResultMinor resultMinor) {
        this.topLevelStatusCode = topLevelStatusCode;
        this.secondLevelStatusCode = secondLevelStatusCode;
        this.message = resultMinor.getUri();
    }

    private SamlError(String topLevelStatusCode, String secondLevelStatusCode, String resultMinor) {
        this.topLevelStatusCode = topLevelStatusCode;
        this.secondLevelStatusCode = secondLevelStatusCode;
        this.message = resultMinor;
    }

    public String getTopLevelStatusCode() {
        return this.topLevelStatusCode;
    }

    public String getSecondLevelStatusCode() {
        return this.secondLevelStatusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public static SamlError getSamlErrorFromMinorStatusCode(String minorStatusCode) {
        if (StringUtils.isBlank((CharSequence)minorStatusCode)) {
            return null;
        }
        for (SamlError samlError : SamlError.values()) {
            if (!samlError.secondLevelStatusCode.equals(minorStatusCode)) continue;
            return samlError;
        }
        return null;
    }
}

