/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.saml;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.ChainingKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.AgreementMethodKeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.ECKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;

public final class SamlDecrypterUtils {
    private SamlDecrypterUtils() {
    }

    public static Decrypter setupDecrypter(X509Certificate certificate, PrivateKey privateKey) {
        BasicX509Credential decryptionCredential = CredentialSupport.getSimpleCredential((X509Certificate)certificate, (PrivateKey)privateKey);
        DecryptionParameters decryptionParameters = SamlDecrypterUtils.getDecryptionParameters((Credential)decryptionCredential);
        return new Decrypter(decryptionParameters);
    }

    public static Decrypter setupDecrypter(Credential decryptionCredential) {
        DecryptionParameters decryptionParameters = SamlDecrypterUtils.getDecryptionParameters(decryptionCredential);
        return new Decrypter(decryptionParameters);
    }

    private static DecryptionParameters getDecryptionParameters(Credential decryptionCredential) {
        DecryptionParameters paramters = new DecryptionParameters();
        ChainingEncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver(), new SimpleKeyInfoReferenceEncryptedKeyResolver()));
        paramters.setEncryptedKeyResolver((EncryptedKeyResolver)encryptedKeyResolver);
        StaticKeyInfoCredentialResolver staticKeyInfoCredentialResolver = new StaticKeyInfoCredentialResolver(decryptionCredential);
        List<KeyInfoProvider> providers = Arrays.asList(new AgreementMethodKeyInfoProvider(), new RSAKeyValueProvider(), new ECKeyValueProvider(), new InlineX509DataProvider());
        CollectionKeyInfoCredentialResolver localCredentialResolver = new CollectionKeyInfoCredentialResolver(List.of(decryptionCredential));
        LocalKeyInfoCredentialResolver localKeyInfoCredentialResolver = new LocalKeyInfoCredentialResolver(providers, (CredentialResolver)localCredentialResolver);
        ChainingKeyInfoCredentialResolver keyInfoCredentialResolver = new ChainingKeyInfoCredentialResolver(List.of(localKeyInfoCredentialResolver, staticKeyInfoCredentialResolver));
        paramters.setKEKKeyInfoCredentialResolver((KeyInfoCredentialResolver)keyInfoCredentialResolver);
        return paramters;
    }
}

