/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.saml;

import de.governikus.panstar.sdk.utils.exception.SAMLInternalErrorException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.impl.XSAnyUnmarshaller;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.KeyAgreementKeyInfoGeneratorFactory;
import org.w3c.dom.Document;

public final class SamlEncrypterUtils {
    private SamlEncrypterUtils() {
    }

    public static EncryptedData getEncryptedData(Document doc, X509Certificate certificate) throws SAMLInternalErrorException {
        DataEncryptionParameters encParams = SamlEncrypterUtils.createDataEncryptionParameters();
        KeyEncryptionParameters kekParameters = SamlEncrypterUtils.getKeyEncryptionParameters(certificate, false);
        Encrypter encrypter = SamlEncrypterUtils.setupEncrypter(encParams, kekParameters);
        XSAnyUnmarshaller unmarshaller = new XSAnyUnmarshaller();
        try {
            XMLObject xmlObject = unmarshaller.unmarshall(doc.getDocumentElement());
            return encrypter.encryptElement(xmlObject, encParams, kekParameters);
        }
        catch (UnmarshallingException e) {
            throw new SAMLInternalErrorException("Could not unmarshall xml object.", e);
        }
        catch (EncryptionException e) {
            throw new SAMLInternalErrorException("Could not encrypt xml object.", e);
        }
    }

    public static Encrypter setupEncrypter(X509Certificate encryptionCertificate) throws SAMLInternalErrorException {
        return SamlEncrypterUtils.setupEncrypter(SamlEncrypterUtils.createDataEncryptionParameters(), SamlEncrypterUtils.getKeyEncryptionParameters(encryptionCertificate, false));
    }

    public static Encrypter setupEncrypter(X509Certificate encryptionCertificate, boolean includeCert) throws SAMLInternalErrorException {
        return SamlEncrypterUtils.setupEncrypter(SamlEncrypterUtils.createDataEncryptionParameters(), SamlEncrypterUtils.getKeyEncryptionParameters(encryptionCertificate, includeCert));
    }

    private static Encrypter setupEncrypter(DataEncryptionParameters encParams, KeyEncryptionParameters kek) {
        Encrypter encrypter = new Encrypter(encParams, kek);
        encrypter.setKeyPlacement(Encrypter.KeyPlacement.INLINE);
        return encrypter;
    }

    private static KeyEncryptionParameters getKeyEncryptionParameters(X509Certificate encryptionCertificate, boolean includeCert) throws SAMLInternalErrorException {
        KeyEncryptionParameters kekParameters = new KeyEncryptionParameters();
        if ("EC".equals(encryptionCertificate.getPublicKey().getAlgorithm())) {
            kekParameters.setAlgorithm("http://www.w3.org/2001/04/xmlenc#kw-aes256");
            Credential keyAgreementCredential = SamlEncrypterUtils.getKeyAgreementCredential((Credential)CredentialSupport.getSimpleCredential((X509Certificate)encryptionCertificate, null));
            kekParameters.setEncryptionCredential(keyAgreementCredential);
            KeyAgreementKeyInfoGeneratorFactory newKeyInfoGenerator = new KeyAgreementKeyInfoGeneratorFactory();
            kekParameters.setKeyInfoGenerator(newKeyInfoGenerator.newInstance());
            return kekParameters;
        }
        if ("RSA".equals(encryptionCertificate.getPublicKey().getAlgorithm())) {
            kekParameters.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            kekParameters.setEncryptionCredential((Credential)CredentialSupport.getSimpleCredential((X509Certificate)encryptionCertificate, null));
            kekParameters.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha256", null, null));
            if (includeCert) {
                KeyInfoGeneratorFactory kigf = ((EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class)).getKeyTransportKeyInfoGeneratorManager().getDefaultManager().getFactory((Credential)new BasicX509Credential(encryptionCertificate));
                kekParameters.setKeyInfoGenerator(kigf.newInstance());
            }
            return kekParameters;
        }
        throw new SAMLInternalErrorException("Not supported or unknown standard algorithm name: " + encryptionCertificate.getPublicKey().getAlgorithm());
    }

    static Credential getKeyAgreementCredential(Credential credential) throws SAMLInternalErrorException {
        try {
            Collection keyAgreementParameterCollection = ((KeyAgreementEncryptionConfiguration)SecurityConfigurationSupport.getGlobalEncryptionConfiguration().getKeyAgreementConfigurations().get("EC")).getParameters();
            if (keyAgreementParameterCollection == null) {
                throw new SAMLInternalErrorException("Key agreement parameters are null");
            }
            KeyAgreementParameters keyAgreementParameters = new KeyAgreementParameters(keyAgreementParameterCollection);
            KeyAgreementProcessor keyAgreementProcessor = KeyAgreementSupport.getProcessor((String)"http://www.w3.org/2009/xmlenc11#ECDH-ES");
            return keyAgreementProcessor.execute(credential, "http://www.w3.org/2001/04/xmlenc#kw-aes256", keyAgreementParameters);
        }
        catch (KeyAgreementException e) {
            throw new SAMLInternalErrorException("Could not generate key agreement credentials", e);
        }
    }

    private static DataEncryptionParameters createDataEncryptionParameters() throws SAMLInternalErrorException {
        Credential symmetricCredential;
        try {
            symmetricCredential = AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        }
        catch (KeyException | NoSuchAlgorithmException e) {
            throw new SAMLInternalErrorException("Could not generate symmetric key.", e);
        }
        DataEncryptionParameters encParams = new DataEncryptionParameters();
        encParams.setAlgorithm("http://www.w3.org/2009/xmlenc11#aes256-gcm");
        encParams.setEncryptionCredential(symmetricCredential);
        return encParams;
    }
}

