/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.xml;

import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.ECPrivateKey;
import java.util.Base64;
import org.opensaml.saml.common.SAMLObjectContentReference;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509IssuerName;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SerialNumber;
import org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.impl.X509CertificateBuilder;
import org.opensaml.xmlsec.signature.impl.X509DataBuilder;
import org.opensaml.xmlsec.signature.impl.X509IssuerNameBuilder;
import org.opensaml.xmlsec.signature.impl.X509IssuerSerialBuilder;
import org.opensaml.xmlsec.signature.impl.X509SerialNumberBuilder;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLSignatureHandler {
    private static final Logger LOG = LoggerFactory.getLogger(XMLSignatureHandler.class);
    public static final String SHA256 = "SHA-256";
    public static final String SHA256_ALT = "SHA256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA384_ALT = "SHA384";
    public static final String SHA512 = "SHA-512";
    public static final String SHA512_ALT = "SHA512";
    private static final String STRING_ENUM_SEPARATOR = ", ";

    public static void addSignature(SignableXMLObject signable, PrivateKey key, java.security.cert.X509Certificate cert, SigEntryType type) throws CertificateEncodingException {
        String digestAlg = SHA256;
        if ("EC".equals(key.getAlgorithm())) {
            int fieldSize = ((ECPrivateKey)key).getParams().getCurve().getField().getFieldSize();
            switch (fieldSize) {
                case 256: {
                    break;
                }
                case 384: {
                    digestAlg = SHA384;
                    break;
                }
                default: {
                    digestAlg = SHA512;
                }
            }
        }
        XMLSignatureHandler.addSignature(signable, key, cert, type, digestAlg);
    }

    public static void addSignature(SignableXMLObject signable, PrivateKey key, java.security.cert.X509Certificate cert, SigEntryType type, String digestAlg) throws CertificateEncodingException {
        if (type == SigEntryType.NONE) {
            return;
        }
        SignatureImpl sig = new SignatureBuilder().buildObject();
        BasicX509Credential credential = new BasicX509Credential(cert);
        credential.setPrivateKey(key);
        sig.setSigningCredential((Credential)credential);
        switch (key.getAlgorithm()) {
            case "EC": {
                XMLSignatureHandler.handleECSignature(digestAlg, (Signature)sig);
                break;
            }
            case "RSA": {
                XMLSignatureHandler.handleRSASignature(digestAlg, (Signature)sig);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported key algorithm " + key.getAlgorithm() + ", use RSA or EC");
            }
        }
        sig.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        KeyInfo keyInfo = new KeyInfoBuilder().buildObject();
        X509Data x509Data = new X509DataBuilder().buildObject();
        if (type == SigEntryType.CERTIFICATE) {
            XMLSignatureHandler.addCertificate(cert, x509Data);
        } else if (type == SigEntryType.ISSUERSERIAL) {
            XMLSignatureHandler.addIssuerSerial(cert, x509Data);
        }
        keyInfo.getX509Datas().add(x509Data);
        sig.setKeyInfo(keyInfo);
        signable.setSignature((Signature)sig);
        switch (digestAlg) {
            case "SHA-256": 
            case "SHA256": {
                ((SAMLObjectContentReference)sig.getContentReferences().get(0)).setDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
                break;
            }
            case "SHA-384": 
            case "SHA384": {
                ((SAMLObjectContentReference)sig.getContentReferences().get(0)).setDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha384");
                break;
            }
            case "SHA-512": 
            case "SHA512": {
                ((SAMLObjectContentReference)sig.getContentReferences().get(0)).setDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
                break;
            }
        }
    }

    private static void handleRSASignature(String digestAlg, Signature sig) {
        if (SHA256.equals(digestAlg) || SHA256_ALT.equals(digestAlg)) {
            sig.setSignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1");
        } else if (SHA384.equals(digestAlg) || SHA384_ALT.equals(digestAlg)) {
            sig.setSignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1");
        } else if (SHA512.equals(digestAlg) || SHA512_ALT.equals(digestAlg)) {
            sig.setSignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1");
        } else {
            throw new IllegalArgumentException("Given digest algorithm " + digestAlg + " not supported with RSA keys, use SHA-256, SHA-384 or SHA-512");
        }
    }

    private static void handleECSignature(String digestAlg, Signature sig) {
        if (SHA256.equals(digestAlg) || SHA256_ALT.equals(digestAlg)) {
            sig.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
        } else if (SHA384.equals(digestAlg) || SHA384_ALT.equals(digestAlg)) {
            sig.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384");
        } else if (SHA512.equals(digestAlg) || SHA512_ALT.equals(digestAlg)) {
            sig.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
        } else {
            throw new IllegalArgumentException("Given digest algorithm " + digestAlg + " not supported with EC keys, use SHA-256, SHA-384 or SHA-512");
        }
    }

    private static void addCertificate(java.security.cert.X509Certificate cert, X509Data data) throws CertificateEncodingException {
        X509Certificate xmlcert = new X509CertificateBuilder().buildObject();
        xmlcert.setValue(Base64.getEncoder().encodeToString(cert.getEncoded()));
        data.getX509Certificates().add(xmlcert);
    }

    private static void addIssuerSerial(java.security.cert.X509Certificate cert, X509Data data) {
        X509IssuerSerial is = new X509IssuerSerialBuilder().buildObject();
        X509IssuerName in = new X509IssuerNameBuilder().buildObject();
        in.setValue(cert.getIssuerX500Principal().getName());
        is.setX509IssuerName(in);
        X509SerialNumber se = new X509SerialNumberBuilder().buildObject();
        se.setValue(cert.getSerialNumber());
        is.setX509SerialNumber(se);
        data.getX509IssuerSerials().add(is);
    }

    public static int checkSignature(Signature sig, java.security.cert.X509Certificate ... trustedAnchor) throws SignatureException {
        if (trustedAnchor == null || trustedAnchor.length == 0) {
            throw new SignatureException("no trustAnchor given");
        }
        if (sig == null) {
            throw new SignatureException("no signature given");
        }
        SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
        try {
            profileValidator.validate(sig);
        }
        catch (SignatureException e) {
            LOG.debug("Signature does not meet security-related requirements", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        for (int i = 0; i < trustedAnchor.length; ++i) {
            if (trustedAnchor[i] == null) continue;
            BasicX509Credential credential = new BasicX509Credential(trustedAnchor[i]);
            try {
                SignatureValidator.validate((Signature)sig, (Credential)credential);
                return i;
            }
            catch (SignatureException e) {
                LOG.debug("Signature could not be validated with certificate: {} \n Try to continue with other trust anchors", (Object)trustedAnchor[i], (Object)e);
                continue;
            }
            catch (Exception e) {
                throw new SignatureException(e);
            }
        }
        throw new SignatureException("signature check failed");
    }

    private XMLSignatureHandler() {
    }

    public static enum SigEntryType {
        NONE,
        CERTIFICATE,
        ISSUERSERIAL;

    }
}

