/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.panstar.sdk.utils.xml;

import de.governikus.panstar.sdk.utils.exception.XmlException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class XmlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XmlUtils.class);

    private XmlUtils() {
    }

    public static SchemaFactory getSchemaFactory() throws SAXNotRecognizedException, SAXNotSupportedException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return sf;
    }

    public static void validateWithSchema(String xml, URL schemaLocation, SchemaFactory schemaFactory) throws XmlException {
        if (schemaLocation == null) {
            throw new XmlException("No schema found: location is null");
        }
        if (StringUtils.isBlank((CharSequence)schemaLocation.getFile())) {
            throw new XmlException(String.format("Schema location '%s' does not exist...", schemaLocation));
        }
        try {
            Schema schema = schemaFactory.newSchema(schemaLocation);
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(new StringReader(xml));
            validator.validate(source);
        }
        catch (IOException | SAXException e) {
            throw new XmlException(e.getMessage(), e);
        }
    }

    public static void validateWithSchema(String xml, URL schemaLocation) throws XmlException {
        SchemaFactory schemaFactory;
        try {
            schemaFactory = XmlUtils.getSchemaFactory();
        }
        catch (SAXException e) {
            throw new XmlException(e.getMessage(), e);
        }
        XmlUtils.validateWithSchema(xml, schemaLocation, schemaFactory);
    }

    public static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        return transformer;
    }

    public static String transformElement(Element element, Transformer transformer) throws TransformerException {
        DOMSource domSource = new DOMSource(element);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public static String transformElement(Element element) throws TransformerException {
        return XmlUtils.transformElement(element, XmlUtils.getTransformer());
    }

    public static <T> T unmarshal(String xml, Class<T> clazz) throws XmlException {
        LOG.trace("Unmarshalling XML '{}' to object of type '{}'.", (Object)xml, clazz);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (T)jaxbUnmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception ex) {
            throw new XmlException(String.format("Could not parse XML '%s'", xml), ex);
        }
    }

    public static String marshal(Object object) throws XmlException {
        return XmlUtils.marshal(object, false);
    }

    public static String marshal(Object object, boolean fragment) throws XmlException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            marshaller.setProperty("jaxb.fragment", (Object)fragment);
            StringWriter w = new StringWriter();
            marshaller.marshal(object, (Writer)w);
            return w.toString();
        }
        catch (Exception ex) {
            throw new XmlException("Could not parse object", ex);
        }
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilderFactory tmpDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        tmpDocumentBuilderFactory.setNamespaceAware(true);
        String feature = null;
        try {
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            tmpDocumentBuilderFactory.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            tmpDocumentBuilderFactory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            tmpDocumentBuilderFactory.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            tmpDocumentBuilderFactory.setFeature(feature, false);
            tmpDocumentBuilderFactory.setXIncludeAware(false);
            tmpDocumentBuilderFactory.setExpandEntityReferences(false);
            return tmpDocumentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.info("ParserConfigurationException was thrown. The feature '{}' is probably not supported by your XML processor.", (Object)feature);
            throw new IllegalStateException(e);
        }
    }

    public static Document toDocument(String xml, DocumentBuilder documentBuilder) throws XmlException {
        Document document;
        StringReader reader = new StringReader(xml);
        try {
            InputSource inputSource = new InputSource(reader);
            inputSource.setEncoding(StandardCharsets.UTF_8.name());
            document = documentBuilder.parse(inputSource);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException e) {
                throw new XmlException("Could not translate the xml string into a dom-model.", e);
            }
        }
        ((Reader)reader).close();
        return document;
    }

    public static Document toDocument(String xml) throws XmlException {
        return XmlUtils.toDocument(xml, XmlUtils.getDocumentBuilder());
    }

    public static XMLGregorianCalendar toXmlGregorianCalendar(String date) throws DatatypeConfigurationException {
        if (date == null) {
            return null;
        }
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
    }
}

