/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.event;

import android.util.Log;
import de.greenrobot.event.EventBus;
import de.greenrobot.event.EventBusException;
import de.greenrobot.event.Subscribe;
import de.greenrobot.event.SubscriberIndex;
import de.greenrobot.event.SubscriberMethod;
import de.greenrobot.event.ThreadMode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class SubscriberMethodFinder {
    private static final int BRIDGE = 64;
    private static final int SYNTHETIC = 4096;
    private static final int MODIFIERS_IGNORE = 5192;
    private static final Map<String, List<SubscriberMethod>> METHOD_CACHE = new HashMap<String, List<SubscriberMethod>>();
    private static final SubscriberIndex INDEX;
    private final boolean strictMethodVerification;

    SubscriberMethodFinder(boolean strictMethodVerification) {
        this.strictMethodVerification = strictMethodVerification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SubscriberMethod> findSubscriberMethods(Class<?> subscriberClass, boolean forceReflection) {
        List<SubscriberMethod> subscriberMethods;
        String key = subscriberClass.getName();
        Map<String, List<SubscriberMethod>> map = METHOD_CACHE;
        synchronized (map) {
            subscriberMethods = METHOD_CACHE.get(key);
        }
        if (subscriberMethods != null) {
            return subscriberMethods;
        }
        if (INDEX != null && !forceReflection) {
            subscriberMethods = this.findSubscriberMethodsWithIndex(subscriberClass);
            if (subscriberMethods.isEmpty()) {
                subscriberMethods = this.findSubscriberMethodsWithReflection(subscriberClass);
            }
        } else {
            subscriberMethods = this.findSubscriberMethodsWithReflection(subscriberClass);
        }
        if (subscriberMethods.isEmpty()) {
            throw new EventBusException("Subscriber " + subscriberClass + " and its super classes have no public methods with the @Subscribe annotation");
        }
        map = METHOD_CACHE;
        synchronized (map) {
            METHOD_CACHE.put(key, subscriberMethods);
        }
        return subscriberMethods;
    }

    private List<SubscriberMethod> findSubscriberMethodsWithIndex(Class<?> subscriberClass) {
        for (Class<?> clazz = subscriberClass; clazz != null; clazz = clazz.getSuperclass()) {
            SubscriberMethod[] array = INDEX.getSubscribersFor(clazz);
            if (array != null && array.length > 0) {
                ArrayList<SubscriberMethod> subscriberMethods = new ArrayList<SubscriberMethod>();
                for (SubscriberMethod subscriberMethod : array) {
                    subscriberMethods.add(subscriberMethod);
                }
                return subscriberMethods;
            }
            String name = clazz.getName();
            if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("android.")) break;
        }
        return Collections.EMPTY_LIST;
    }

    private List<SubscriberMethod> findSubscriberMethodsWithReflection(Class<?> subscriberClass) {
        String name;
        ArrayList<SubscriberMethod> subscriberMethods = new ArrayList<SubscriberMethod>();
        HashSet<String> eventTypesFound = new HashSet<String>();
        StringBuilder methodKeyBuilder = new StringBuilder();
        for (Class<?> clazz = subscriberClass; !(clazz == null || (name = clazz.getName()).startsWith("java.") || name.startsWith("javax.") || name.startsWith("android.")); clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if ((modifiers & 1) != 0 && (modifiers & 0x1448) == 0) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length == 1) {
                        Subscribe subscribeAnnotation = method.getAnnotation(Subscribe.class);
                        if (subscribeAnnotation == null) continue;
                        String methodName = method.getName();
                        Class<?> eventType = parameterTypes[0];
                        methodKeyBuilder.setLength(0);
                        methodKeyBuilder.append(methodName);
                        methodKeyBuilder.append('>').append(eventType.getName());
                        String methodKey = methodKeyBuilder.toString();
                        if (!eventTypesFound.add(methodKey)) continue;
                        ThreadMode threadMode = subscribeAnnotation.threadMode();
                        subscriberMethods.add(new SubscriberMethod(method, eventType, threadMode, subscribeAnnotation.priority(), subscribeAnnotation.sticky()));
                        continue;
                    }
                    if (!this.strictMethodVerification || !method.isAnnotationPresent(Subscribe.class)) continue;
                    String methodName = name + "." + method.getName();
                    throw new EventBusException("@Subscribe method " + methodName + "must have exactly 1 parameter but has " + parameterTypes.length);
                }
                if (!this.strictMethodVerification || !method.isAnnotationPresent(Subscribe.class)) continue;
                String methodName = name + "." + method.getName();
                throw new EventBusException(methodName + " is a illegal @Subscribe method: must be public, non-static, and non-abstract");
            }
        }
        return subscriberMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<String, List<SubscriberMethod>> map = METHOD_CACHE;
        synchronized (map) {
            METHOD_CACHE.clear();
        }
    }

    static {
        SubscriberIndex newIndex = null;
        try {
            Class<?> clazz = Class.forName("de.greenrobot.event.GeneratedSubscriberIndex");
            newIndex = (SubscriberIndex)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            Log.d((String)EventBus.TAG, (String)"No subscriber index available, reverting to dynamic look-up");
        }
        catch (Exception e) {
            Log.w((String)EventBus.TAG, (String)"Could not init subscriber index, reverting to dynamic look-up", (Throwable)e);
        }
        INDEX = newIndex;
    }
}

