/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.daogenerator;

import de.greenrobot.daogenerator.Entity;
import de.greenrobot.daogenerator.Property;
import de.greenrobot.daogenerator.PropertyOrderList;
import de.greenrobot.daogenerator.PropertyType;
import de.greenrobot.daogenerator.Schema;
import java.util.List;

public class ToMany {
    private final Schema schema;
    private String name;
    private final Entity sourceEntity;
    private final Entity targetEntity;
    private Property[] sourceProperties;
    private final Property[] targetProperties;
    private final PropertyOrderList propertyOrderList;

    public ToMany(Schema schema, Entity sourceEntity, Property[] sourceProperties, Entity targetEntity, Property[] targetProperties) {
        this.schema = schema;
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.sourceProperties = sourceProperties;
        this.targetProperties = targetProperties;
        this.propertyOrderList = new PropertyOrderList();
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public Property[] getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(Property[] sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public Property[] getTargetProperties() {
        return this.targetProperties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void orderAsc(Property ... properties) {
        for (Property property : properties) {
            this.targetEntity.validatePropertyExists(property);
            this.propertyOrderList.addPropertyAsc(property);
        }
    }

    public void orderDesc(Property ... properties) {
        for (Property property : properties) {
            this.targetEntity.validatePropertyExists(property);
            this.propertyOrderList.addPropertyDesc(property);
        }
    }

    public String getOrder() {
        if (this.propertyOrderList.isEmpty()) {
            return null;
        }
        return this.propertyOrderList.getCommaSeparatedString();
    }

    void init2ndPass() {
        int count;
        if (this.name == null) {
            char[] nameCharArray = this.targetEntity.getClassName().toCharArray();
            nameCharArray[0] = Character.toLowerCase(nameCharArray[0]);
            this.name = new String(nameCharArray) + "List";
        }
        if (this.sourceProperties == null) {
            List<Property> pks = this.sourceEntity.getPropertiesPk();
            if (pks.isEmpty()) {
                throw new RuntimeException("Source entity has no primary key, but we need it for " + this);
            }
            this.sourceProperties = new Property[pks.size()];
            this.sourceProperties = pks.toArray(this.sourceProperties);
        }
        if ((count = this.sourceProperties.length) != this.targetProperties.length) {
            throw new RuntimeException("Source properties do not match target properties: " + this);
        }
        for (int i = 0; i < count; ++i) {
            Property sourceProperty = this.sourceProperties[i];
            Property targetProperty = this.targetProperties[i];
            PropertyType sourceType = sourceProperty.getPropertyType();
            PropertyType targetType = targetProperty.getPropertyType();
            if (sourceType == null || targetType == null) {
                throw new RuntimeException("Property type uninitialized");
            }
            if (sourceType == targetType) continue;
            System.err.println("Warning to-one property type does not match target key type: " + this);
        }
    }

    void init3ndPass() {
    }

    public String toString() {
        String sourceName = this.sourceEntity != null ? this.sourceEntity.getClassName() : null;
        String targetName = this.targetEntity != null ? this.targetEntity.getClassName() : null;
        return "ToMany '" + this.name + "' from " + sourceName + " to " + targetName;
    }
}

