/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common.hash;

import java.util.zip.Checksum;

public class CombinedChecksum
implements Checksum {
    private final Checksum checksum1;
    private final Checksum checksum2;

    public CombinedChecksum(Checksum checksum1, Checksum checksum2) {
        this.checksum1 = checksum1;
        this.checksum2 = checksum2;
    }

    @Override
    public void update(int b) {
        this.checksum1.update(b);
        this.checksum2.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checksum1.update(b, off, len);
        this.checksum2.update(b, off, len);
    }

    @Override
    public long getValue() {
        return this.checksum2.getValue() << 32 | this.checksum1.getValue() & 0xFFFFFFFFL;
    }

    @Override
    public void reset() {
        this.checksum1.reset();
        this.checksum2.reset();
    }
}

