/*
 * Decompiled with CFR 0.152.
 */
package de.grobmeier.postmark;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.grobmeier.postmark.DateTimeTypeAdapter;
import de.grobmeier.postmark.NameValuePair;
import de.grobmeier.postmark.PostmarkException;
import de.grobmeier.postmark.PostmarkMessage;
import de.grobmeier.postmark.PostmarkMessageBase;
import de.grobmeier.postmark.PostmarkResponse;
import de.grobmeier.postmark.PostmarkStatus;
import de.grobmeier.postmark.PostmarkTemplate;
import de.grobmeier.postmark.SkipMeExclusionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;

public class PostmarkClient {
    public static final String API_ENDPOINT = "https://api.postmarkapp.com";
    private static Logger logger = Logger.getLogger("com.postmark.java");
    private String serverToken;
    private String serverPath;
    private static GsonBuilder gsonBuilder = new GsonBuilder();

    public PostmarkClient(String serverToken) {
        this(serverToken, API_ENDPOINT);
    }

    public PostmarkClient(String serverToken, String serverPath) {
        this.serverToken = serverToken;
        this.serverPath = serverPath;
    }

    public PostmarkResponse sendMessage(String from, String to, String replyTo, String cc, String subject, String body, boolean isHTML, String tag) throws PostmarkException {
        return this.sendMessage(from, to, replyTo, cc, null, subject, body, isHTML, tag, null);
    }

    public PostmarkResponse sendMessage(String from, String to, String replyTo, String cc, String subject, String body, boolean isHTML, String tag, List<NameValuePair> headers) throws PostmarkException {
        return this.sendMessage(from, to, replyTo, cc, null, subject, body, isHTML, tag, headers);
    }

    public PostmarkResponse sendMessage(String from, String to, String replyTo, String cc, String bcc, String subject, String body, boolean isHTML, String tag, List<NameValuePair> headers) throws PostmarkException {
        PostmarkMessage message = new PostmarkMessage(from, to, replyTo, subject, bcc, cc, body, isHTML, tag, headers);
        return this.sendMessage(message);
    }

    public PostmarkResponse sendMessage(PostmarkTemplate templateMessage) throws PostmarkException {
        return this.sendPostmarkMessage("/email/withTemplate", templateMessage);
    }

    public PostmarkResponse sendMessage(PostmarkMessage message) throws PostmarkException {
        return this.sendPostmarkMessage("/email", message);
    }

    private PostmarkResponse sendPostmarkMessage(String endpoint, PostmarkMessageBase message) throws PostmarkException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        PostmarkResponse theResponse = new PostmarkResponse();
        try {
            HttpPost method = new HttpPost(this.serverPath + endpoint);
            method.addHeader("Accept", "application/json");
            method.addHeader("Content-Type", "application/json; charset=utf-8");
            method.addHeader("X-Postmark-Server-Token", this.serverToken);
            method.addHeader("User-Agent", "Postmark-Java");
            message.validate();
            message.clean();
            Gson gson = gsonBuilder.create();
            String messageContents = gson.toJson((Object)message);
            logger.info("Message contents: " + messageContents);
            StringEntity payload = new StringEntity(messageContents, "UTF-8");
            method.setEntity((HttpEntity)payload);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (status >= 200 && status < 300) {
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    Scanner s = new Scanner(entity.getContent()).useDelimiter("\\A");
                    String result = s.hasNext() ? s.next() : "";
                    logger.warning(result);
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            try {
                String response = (String)httpClient.execute((HttpUriRequest)method, (ResponseHandler)responseHandler);
                logger.info("Message response: " + response);
                theResponse = (PostmarkResponse)gsonBuilder.create().fromJson(response, PostmarkResponse.class);
                theResponse.status = PostmarkStatus.SUCCESS;
            }
            catch (HttpResponseException hre) {
                switch (hre.getStatusCode()) {
                    case 401: 
                    case 422: {
                        logger.log(Level.SEVERE, "There was a problem with the email: " + hre.getMessage());
                        theResponse.setMessage(hre.getMessage());
                        theResponse.status = PostmarkStatus.USERERROR;
                        throw new PostmarkException(hre.getMessage(), theResponse);
                    }
                    case 500: {
                        logger.log(Level.SEVERE, "There has been an error sending your email: " + hre.getMessage());
                        theResponse.setMessage(hre.getMessage());
                        theResponse.status = PostmarkStatus.SERVERERROR;
                        throw new PostmarkException(hre.getMessage(), theResponse);
                    }
                }
                logger.log(Level.SEVERE, "There has been an unknow error sending your email: " + hre.getMessage());
                theResponse.status = PostmarkStatus.UNKNOWN;
                theResponse.setMessage(hre.getMessage());
                throw new PostmarkException(hre.getMessage(), theResponse);
            }
        }
        catch (PostmarkException e) {
            logger.log(Level.SEVERE, "There has been an error sending your email: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "There has been an error sending your email: " + e.getMessage());
            throw new PostmarkException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return theResponse;
    }

    static {
        gsonBuilder.registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeAdapter());
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new SkipMeExclusionStrategy(Boolean.class)});
        gsonBuilder.disableHtmlEscaping();
        logger.addHandler(new ConsoleHandler());
        logger.setLevel(Level.ALL);
    }
}

